/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system;

import org.cyclos.model.system.SystemSubmodule;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.MessageKeyImpl;
import org.cyclos.utils.Submodule;

public class SystemKeys {

    public static class RecurringTasks
    extends MessageKeyImpl {
        public static MessageKey ACCOUNT_BALANCE_CLOSING = new RecurringTasks("AccountBalanceClosing");
        public static MessageKey ACCOUNT_BALANCE_VERIFICATION = new RecurringTasks("AccountBalanceVerification");
        public static MessageKey ADDRESS_LOCATING = new RecurringTasks("AddressLocating");
        public static MessageKey AD_EXPIRED_NOTIFICATION = new RecurringTasks("AdExpiredNotification");
        public static MessageKey ARCHIVE_IMPORTS = new RecurringTasks("ArchiveImports");
        public static MessageKey ARCHIVING = new RecurringTasks("ARCHIVING");
        public static MessageKey BACKGROUND_TASK_EXECUTION = new RecurringTasks("BackgroundTaskExecution");
        public static MessageKey CLEAN_ACCOUNT_BALANCES = new RecurringTasks("CleanAccountBalances");
        public static MessageKey DB_SCHEMA_VERIFICATION = new RecurringTasks("DbSchemaVerification");
        public static MessageKey DISPATCH_ARCHIVE_ACCOUNT_FEES = new RecurringTasks("DispatchArchiveAccountFees");
        public static MessageKey DISPATCH_ARCHIVE_BULK_ACTIONS = new RecurringTasks("DispatchArchiveBulkActions");
        public static MessageKey EXPIRE_EXTERNAL_PAYMENT = new RecurringTasks("ExpireExternalPayment");
        public static MessageKey EXPIRE_PENDING_AUTHORIZATION_PAYMENT = new RecurringTasks("ExpirePendingAuthorizationPayment");
        public static MessageKey EXPIRE_VOUCHERS = new RecurringTasks("ExpireVouchers");
        public static MessageKey EXPIRE_VOUCHERS_ACTIVATION = new RecurringTasks("ExpireVouchersActivation");
        public static MessageKey INSTALLMENT_PROCESSING = new RecurringTasks("InstallmentProcessing");
        public static MessageKey INSTANCE_UPDATE = new RecurringTasks("InstanceUpdate");
        public static MessageKey INTERNET_ADDRESS_RESOLUTION = new RecurringTasks("InternetAddressResolution");
        public static MessageKey MOVE_USERS_TO_GROUP = new RecurringTasks("MoveUsersToGroup");
        public static MessageKey NOTIFY_USERS_ON_INCOMPLETE_REGISTRATIONS = new RecurringTasks("NotifyUsersOnIncompleteRegistrations");
        public static MessageKey NOTIFY_VOUCHERS_ABOUT_TO_EXPIRE = new RecurringTasks("NotifyVouchersAboutToExpire");
        public static MessageKey NOTIFY_VOUCHER_BUYING_ABOUT_TO_EXPIRE = new RecurringTasks("NotifyVoucherBuyingAboutToExpire");
        public static MessageKey PAYMENT_REQUEST_PROCESSING = new RecurringTasks("PaymentRequestProcessing");
        public static MessageKey PURGE_CUSTOM_TASK_LOGS = new RecurringTasks("PurgeCustomTaskLogs");
        public static MessageKey PURGE_DEVICE_ACTIVATIONS = new RecurringTasks("PurgeDeviceActivations");
        public static MessageKey PURGE_EXPIRED_PINS = new RecurringTasks("PurgeExpiredPins");
        public static MessageKey PURGE_EXPIRED_SCRIPT_STORAGES = new RecurringTasks("PurgeExpiredScriptStorages");
        public static MessageKey PURGE_EXTERNAL_OPERATION_EXECUTIONS = new RecurringTasks("PurgeExternalOperationExecutions");
        public static MessageKey PURGE_FAILED_PASSWORD_LOGS = new RecurringTasks("PurgeFailedPasswordLogs");
        public static MessageKey PURGE_FAILED_PRINCIPAL_LOGS = new RecurringTasks("PurgeFailedPrincipalLogs");
        public static MessageKey PURGE_FCM_TOKENS = new RecurringTasks("PurgeFcmTokens");
        public static MessageKey PURGE_FORGOT_PASSWORD_REQUEST_LOGS = new RecurringTasks("PurgeForgotPasswordRequestLogs");
        public static MessageKey PURGE_INVITE_TOKENS = new RecurringTasks("PurgeInviteTokens");
        public static MessageKey PURGE_IP_GEOLOCATIONS = new RecurringTasks("PurgeIpGeolocations");
        public static MessageKey PURGE_LOGIN_LOGS = new RecurringTasks("PurgeLoginLogs");
        public static MessageKey PURGE_MESSAGES_ON_TRASH = new RecurringTasks("PurgeMessagesOnTrash");
        public static MessageKey PURGE_OIDC_AUTHORIZATIONS = new RecurringTasks("PurgeOidcAuthorizations");
        public static MessageKey PURGE_OIDC_TOKENS = new RecurringTasks("PurgeOidcTokens");
        public static MessageKey PURGE_OLD_ERROR_LOGS = new RecurringTasks("PurgeOldErrorLogs");
        public static MessageKey PURGE_OLD_NOTIFICATIONS = new RecurringTasks("PurgeOldNotifications");
        public static MessageKey PURGE_ORPHAN_DATA_TRANSLATIONS = new RecurringTasks("PurgeOrphanDataTranslations");
        public static MessageKey PURGE_OTPS = new RecurringTasks("PurgeOtps");
        public static MessageKey PURGE_REMOTE_ADDRESS_BLOCKS = new RecurringTasks("PurgeRemoteAddressBlocks");
        public static MessageKey PURGE_SESSIONS = new RecurringTasks("PurgeSessions");
        public static MessageKey PURGE_TEMP_FILES = new RecurringTasks("PurgeTempFiles");
        public static MessageKey PURGE_UNCONFIRMED_USERS = new RecurringTasks("PurgeUnconfirmedUsers");
        public static MessageKey PURGE_WIZARD_EXECUTIONS = new RecurringTasks("PurgeWizardExecutions");
        public static MessageKey RECURRENCE = new RecurringTasks("recurrence");
        public static MessageKey RECURRENCE_EVERY_DAY = new RecurringTasks("recurrence.EVERY_DAY");
        public static MessageKey RECURRENCE_EVERY_HALF_HOUR = new RecurringTasks("recurrence.EVERY_HALF_HOUR");
        public static MessageKey RECURRENCE_EVERY_HOUR = new RecurringTasks("recurrence.EVERY_HOUR");
        public static MessageKey RECURRENCE_EVERY_MINUTE = new RecurringTasks("recurrence.EVERY_MINUTE");
        public static MessageKey RECURRENCE_NEXT_DAY = new RecurringTasks("recurrence.NEXT_DAY");
        public static MessageKey RECURRENCE_NEXT_HOUR = new RecurringTasks("recurrence.NEXT_HOUR");
        public static MessageKey REMOVE_ARCHIVED_ENTITIES_FROM_INDEX_RECURRING_TASK = new RecurringTasks("RemoveArchivedEntitiesFromIndexRecurringTask");
        public static MessageKey RUN_CUSTOM = new RecurringTasks("RunCustom");
        public static MessageKey SCHEDULED_ACCOUNT_FEES = new RecurringTasks("ScheduledAccountFees");
        public static MessageKey TICKET_PROCESSING = new RecurringTasks("TicketProcessing");
        public static MessageKey TOKENS = new RecurringTasks("Tokens");
        public static MessageKey TRANSACTION_FEEDBACK_EXPIRATION_REMINDER = new RecurringTasks("TransactionFeedbackExpirationReminder");
        public static MessageKey TRANSACTION_FEEDBACK_EXPIRED = new RecurringTasks("TransactionFeedbackExpired");
        public static MessageKey TRANSACTION_FEEDBACK_REMINDER = new RecurringTasks("TransactionFeedbackReminder");
        public static MessageKey TRANSACTION_NOTIFICATION_PROCESSING = new RecurringTasks("TransactionNotificationProcessing");
        public static MessageKey TRANSFER_NOTIFICATION_PROCESSING = new RecurringTasks("TransferNotificationProcessing");

        private RecurringTasks(String string) {
            super((Submodule)SystemSubmodule.RECURRING_TASKS, string);
        }
    }

    public static class BackgroundTasks
    extends MessageKeyImpl {
        public static MessageKey ARCHIVE_ACCOUNT_FEE_LOG = new BackgroundTasks("archiveAccountFeeLog");
        public static MessageKey ARCHIVE_BULK_ACTION = new BackgroundTasks("archiveBulkAction");
        public static MessageKey CHARGE_ACCOUNT_FEE_BATCH = new BackgroundTasks("chargeAccountFeeBatch");
        public static MessageKey DISPATCH_ACCOUNT_FEE_CHARGES = new BackgroundTasks("dispatchAccountFeeCharges");
        public static MessageKey DISPATCH_ENTITY_NOTIFICATION = new BackgroundTasks("dispatchEntityNotification");
        public static MessageKey INDEX_ENTITIES = new BackgroundTasks("indexEntities");
        public static MessageKey NOTIFY_AD_INTEREST = new BackgroundTasks("notifyAdInterest");
        public static MessageKey NOTIFY_INCOMPLETE_REGISTRATIONS = new BackgroundTasks("notifyIncompleteRegistrations");
        public static MessageKey PROCESS_BULK_ACTION = new BackgroundTasks("processBulkAction");
        public static MessageKey PROCESS_EXTERNAL_PAYMENT = new BackgroundTasks("processExternalPayment");
        public static MessageKey PROCESS_IMPORT = new BackgroundTasks("processImport");
        public static MessageKey PROCESS_INCOMING_MESSAGE = new BackgroundTasks("processIncomingMessage");
        public static MessageKey RESET_RATES = new BackgroundTasks("resetRates");
        public static MessageKey RUN_CUSTOM_RECURRING_TASK = new BackgroundTasks("runCustomRecurringTask");
        public static MessageKey RUN_FILE_SCRIPT = new BackgroundTasks("runFileScript");
        public static MessageKey RUN_INLINE_SCRIPT = new BackgroundTasks("runInlineScript");
        public static MessageKey SEND_CUSTOM_NOTIFICATION = new BackgroundTasks("sendCustomNotification");
        public static MessageKey SEND_EMAIL = new BackgroundTasks("sendEmail");
        public static MessageKey SEND_NOTIFICATION = new BackgroundTasks("sendNotification");
        public static MessageKey VERIFY_ACCOUNT = new BackgroundTasks("verifyAccount");

        private BackgroundTasks(String string) {
            super((Submodule)SystemSubmodule.BACKGROUND_TASKS, string);
        }
    }

    public static class Monitor
    extends MessageKeyImpl {
        public static MessageKey ARCHIVE_DATA = new Monitor("archiveData");
        public static MessageKey ARCHIVE_DATA_CONFIRMATION_MESSAGE = new Monitor("archiveDataConfirmationMessage");
        public static MessageKey ARCHIVE_DATA_SCHEDULED = new Monitor("archiveDataScheduled");
        public static MessageKey AUTO_REFRESH = new Monitor("autoRefresh");
        public static MessageKey AUTO_REFRESH_IN = new Monitor("autoRefreshIn");
        public static MessageKey BACKGROUND_TASK_ENQUEUED = new Monitor("backgroundTask.enqueued");
        public static MessageKey BACKGROUND_TASK_RUNNING = new Monitor("backgroundTask.running");
        public static MessageKey BACKGROUND_TASK_SCHEDULED = new Monitor("backgroundTask.scheduled");
        public static MessageKey CACHE_CLEAR = new Monitor("cache.clear");
        public static MessageKey CACHE_CLEAR_ALL = new Monitor("cache.clearAll");
        public static MessageKey CACHE_CONFIRM_CLEAR = new Monitor("cache.confirmClear");
        public static MessageKey CACHE_CONFIRM_CLEAR_ALL = new Monitor("cache.confirmClearAll");
        public static MessageKey CACHE_EVICTION_COUNT = new Monitor("cache.evictionCount");
        public static MessageKey CACHE_HIT_RATE = new Monitor("cache.hitRate");
        public static MessageKey CACHE_HIT_RATE_NOT_APPLICABLE = new Monitor("cache.hitRate.notApplicable");
        public static MessageKey CACHE_NAME = new Monitor("cache.name");
        public static MessageKey CACHE_ONLY_EMPTY = new Monitor("cache.onlyEmpty");
        public static MessageKey CACHE_ORDER_BY_HIT_RATE_ASC = new Monitor("cache.orderByHitRateAsc");
        public static MessageKey CACHE_ORDER_BY_HIT_RATE_DESC = new Monitor("cache.orderByHitRateDesc");
        public static MessageKey CACHE_ORDER_BY_NAME = new Monitor("cache.orderByName");
        public static MessageKey CACHE_ORDER_BY_REQUEST_COUNT_ASC = new Monitor("cache.orderByRequestCountAsc");
        public static MessageKey CACHE_ORDER_BY_REQUEST_COUNT_DESC = new Monitor("cache.orderByRequestCountDesc");
        public static MessageKey CACHE_ORDER_BY_SIZE_ASC = new Monitor("cache.orderBySizeAsc");
        public static MessageKey CACHE_ORDER_BY_SIZE_DESC = new Monitor("cache.orderBySizeDesc");
        public static MessageKey CACHE_REQUEST_COUNT = new Monitor("cache.requestCount");
        public static MessageKey CACHE_SIZE = new Monitor("cache.size");
        public static MessageKey DATABASE_HISTORY_CYCLOS_VERSION = new Monitor("databaseHistory.cyclosVersion");
        public static MessageKey DATABASE_HISTORY_DATABASE_VERSION = new Monitor("databaseHistory.databaseVersion");
        public static MessageKey DATABASE_HISTORY_DATE = new Monitor("databaseHistory.date");
        public static MessageKey DATABASE_HISTORY_ERROR = new Monitor("databaseHistory.error");
        public static MessageKey DATABASE_HISTORY_ERROR_TITLE = new Monitor("databaseHistory.errorTitle");
        public static MessageKey DATABASE_HISTORY_ONLY_ERROR = new Monitor("databaseHistory.onlyError");
        public static MessageKey DATABASE_HISTORY_VIEW_ERROR = new Monitor("databaseHistory.viewError");
        public static MessageKey ERROR_CAN_NOT_COLLECT_CLUSTER_MEMBER_DATA = new Monitor("error.canNotCollectClusterMemberData");
        public static MessageKey ERROR_CAN_NOT_COLLECT_CLUSTER_MEMBER_DATA_INTERRUPTED = new Monitor("error.canNotCollectClusterMemberData.interrupted");
        public static MessageKey ERROR_CAN_NOT_GET_ARCHIVING_INFO = new Monitor("error.canNotGetArchivingInfo");
        public static MessageKey EXPORT_APPENDIX_A = new Monitor("export.appendix.a");
        public static MessageKey EXPORT_APPENDIX_A_ALL_PROPERTIES_ARE_COMMON = new Monitor("export.appendix.a.allPropertiesAreCommon");
        public static MessageKey EXPORT_APPENDIX_A_COMMON_PROPERTIES = new Monitor("export.appendix.a.commonProperties");
        public static MessageKey EXPORT_APPENDIX_A_DETAILS = new Monitor("export.appendix.a.details");
        public static MessageKey EXPORT_APPENDIX_A_SEE = new Monitor("export.appendix.a.see");
        public static MessageKey EXPORT_APPENDIX_B = new Monitor("export.appendix.b");
        public static MessageKey EXPORT_APPENDIX_B_COMMON_CONFIGURATION = new Monitor("export.appendix.b.commonConfiguration");
        public static MessageKey EXPORT_APPENDIX_B_DETAILS = new Monitor("export.appendix.b.details");
        public static MessageKey EXPORT_APPENDIX_B_NO_CLUSTER = new Monitor("export.appendix.b.noCluster");
        public static MessageKey EXPORT_APPENDIX_B_SEE = new Monitor("export.appendix.b.see");
        public static MessageKey EXPORT_APPENDIX_C = new Monitor("export.appendix.c");
        public static MessageKey EXPORT_APPENDIX_C_DETAILS = new Monitor("export.appendix.c.details");
        public static MessageKey EXPORT_APPENDIX_C_LABEL = new Monitor("export.appendix.c.label");
        public static MessageKey EXPORT_APPENDIX_C_SEE = new Monitor("export.appendix.c.see");
        public static MessageKey EXPORT_APPENDIX_C_SEE_NO_ERRORS = new Monitor("export.appendix.c.see.noErrors");
        public static MessageKey EXPORT_APPENDIX_D = new Monitor("export.appendix.d");
        public static MessageKey EXPORT_APPENDIX_D_DETAILS = new Monitor("export.appendix.d.details");
        public static MessageKey EXPORT_APPENDIX_D_DETAILS_GLOBAL_MODE = new Monitor("export.appendix.d.details.globalMode");
        public static MessageKey EXPORT_APPENDIX_D_LABEL = new Monitor("export.appendix.d.label");
        public static MessageKey EXPORT_APPENDIX_D_SEE = new Monitor("export.appendix.d.see");
        public static MessageKey EXPORT_APPENDIX_D_SEE_NO_ERRORS = new Monitor("export.appendix.d.see.noErrors");
        public static MessageKey EXPORT_PROPERTY_NAME = new Monitor("export.propertyName");
        public static MessageKey EXPORT_PROPERTY_VALUE = new Monitor("export.propertyValue");
        public static MessageKey HEADING = new Monitor("heading");
        public static MessageKey REBUILD_BALANCES = new Monitor("rebuildBalances");
        public static MessageKey REBUILD_BALANCES_CONFIRMATION_MESSAGE = new Monitor("rebuildBalancesConfirmationMessage");
        public static MessageKey REBUILD_BALANCES_RUNNING_CLUSTER = new Monitor("rebuildBalancesRunning.cluster");
        public static MessageKey REBUILD_BALANCES_RUNNING_SINGLE = new Monitor("rebuildBalancesRunning.single");
        public static MessageKey REBUILD_BALANCES_SCHEDULED = new Monitor("rebuildBalancesScheduled");
        public static MessageKey RECURRING_TASK_CONFIRM_SCHEDULE_EXECUTION = new Monitor("recurringTask.confirmScheduleExecution");
        public static MessageKey RECURRING_TASK_LAST_EXECUTION = new Monitor("recurringTask.lastExecution");
        public static MessageKey RECURRING_TASK_NEXT_EXECUTION = new Monitor("recurringTask.nextExecution");
        public static MessageKey RECURRING_TASK_ONLY_RUNNING = new Monitor("recurringTask.onlyRunning");
        public static MessageKey RECURRING_TASK_ORDER_BY_NAME = new Monitor("recurringTask.orderByName");
        public static MessageKey RECURRING_TASK_ORDER_BY_NEXT_EXECUTION_ASC = new Monitor("recurringTask.orderByNextExecutionAsc");
        public static MessageKey RECURRING_TASK_ORDER_BY_NEXT_EXECUTION_DESC = new Monitor("recurringTask.orderByNextExecutionDesc");
        public static MessageKey RECURRING_TASK_ORDER_BY_RECURRENCE_ASC = new Monitor("recurringTask.orderByRecurrenceAsc");
        public static MessageKey RECURRING_TASK_ORDER_BY_RECURRENCE_DESC = new Monitor("recurringTask.orderByRecurrenceDesc");
        public static MessageKey RECURRING_TASK_RUN = new Monitor("recurringTask.run");
        public static MessageKey RECURRING_TASK_RUNNING_CLUSTER = new Monitor("recurringTask.running.cluster");
        public static MessageKey RECURRING_TASK_RUNNING_SINGLE = new Monitor("recurringTask.running.single");
        public static MessageKey RECURRING_TASK_SCHEDULING_IN_PROCESS = new Monitor("recurringTask.schedulingInProcess");
        public static MessageKey RECURRING_TASK_TOOK = new Monitor("recurringTask.took");
        public static MessageKey REFRESHING = new Monitor("refreshing");
        public static MessageKey REPORT_DOWNLOAD = new Monitor("reportDownload");
        public static MessageKey REPORT_DOWNLOAD_LINK = new Monitor("reportDownloadLink");
        public static MessageKey REPORT_NAME = new Monitor("reportName");
        public static MessageKey SUMMARY_APPLICATION_NAME = new Monitor("summary.applicationName");
        public static MessageKey SUMMARY_APPLICATION_PROPERTIES = new Monitor("summary.applicationProperties");
        public static MessageKey SUMMARY_APPLICATION_PROPERTIES_ALL_IN_COMMON = new Monitor("summary.applicationPropertiesAllInCommon");
        public static MessageKey SUMMARY_APPLICATION_PROPERTIES_SHOW_ALSO_COMMONS = new Monitor("summary.applicationPropertiesShowAlsoCommons");
        public static MessageKey SUMMARY_APPLICATION_PROPERTIES_SHOW_COMMONS = new Monitor("summary.applicationPropertiesShowCommons");
        public static MessageKey SUMMARY_APPLICATION_PROPERTIES_TITLE_CLUSTER = new Monitor("summary.applicationPropertiesTitle.cluster");
        public static MessageKey SUMMARY_APPLICATION_PROPERTIES_TITLE_SINGLE = new Monitor("summary.applicationPropertiesTitle.single");
        public static MessageKey SUMMARY_APPLICATION_PROPERTIES_VIEW = new Monitor("summary.applicationPropertiesView");
        public static MessageKey SUMMARY_ARCHIVING = new Monitor("summary.archiving");
        public static MessageKey SUMMARY_ARCHIVING_CYCLOS_ARCHIVING_DATE = new Monitor("summary.archiving.cyclosArchivingDate");
        public static MessageKey SUMMARY_ARCHIVING_CYCLOS_ARCHIVING_DATE_NEVER = new Monitor("summary.archiving.cyclosArchivingDate.never");
        public static MessageKey SUMMARY_ARCHIVING_CYCLOS_ARCHIVING_DATE_RUNNING = new Monitor("summary.archiving.cyclosArchivingDate.running");
        public static MessageKey SUMMARY_ARCHIVING_EXTERNAL_REVISION = new Monitor("summary.archiving.externalRevision");
        public static MessageKey SUMMARY_ARCHIVING_EXTERNAL_REVISION_UNKNOWN = new Monitor("summary.archiving.externalRevisionUnknown");
        public static MessageKey SUMMARY_ARCHIVING_EXTERNAL_STATUS = new Monitor("summary.archiving.externalStatus");
        public static MessageKey SUMMARY_ARCHIVING_EXTERNAL_STATUS_DELAYED = new Monitor("summary.archiving.externalStatus.delayed");
        public static MessageKey SUMMARY_ARCHIVING_EXTERNAL_STATUS_IN_SYNC = new Monitor("summary.archiving.externalStatus.inSync");
        public static MessageKey SUMMARY_ARCHIVING_EXTERNAL_STATUS_NEVER = new Monitor("summary.archiving.externalStatus.never");
        public static MessageKey SUMMARY_ARCHIVING_EXTERNAL_STATUS_RUNNING = new Monitor("summary.archiving.externalStatus.running");
        public static MessageKey SUMMARY_ARCHIVING_FIRST_TRANSFER_DATE = new Monitor("summary.archiving.firstTransferDate");
        public static MessageKey SUMMARY_ARCHIVING_LAST_TRANSFER_DATE = new Monitor("summary.archiving.lastTransferDate");
        public static MessageKey SUMMARY_BACKGROUND_TASKS = new Monitor("summary.backgroundTasks");
        public static MessageKey SUMMARY_BACKGROUND_TASKS_INFO = new Monitor("summary.backgroundTasks.info");
        public static MessageKey SUMMARY_BACKGROUND_TASKS_QUEUE = new Monitor("summary.backgroundTasksQueue");
        public static MessageKey SUMMARY_BACKGROUND_TASKS_QUEUE_VALUE = new Monitor("summary.backgroundTasksQueueValue");
        public static MessageKey SUMMARY_BACKGROUND_TASKS_VALUE = new Monitor("summary.backgroundTasksValue");
        public static MessageKey SUMMARY_BACKGROUND_TASKS_VALUE_NO_TASKS = new Monitor("summary.backgroundTasksValueNoTasks");
        public static MessageKey SUMMARY_CLUSTERING = new Monitor("summary.clustering");
        public static MessageKey SUMMARY_CLUSTERING_CLUSTER = new Monitor("summary.clustering.cluster");
        public static MessageKey SUMMARY_CLUSTERING_CONFIGURATION = new Monitor("summary.clustering.configuration");
        public static MessageKey SUMMARY_CLUSTERING_CONFIGURATION_DIFFERENT = new Monitor("summary.clustering.configurationDifferent");
        public static MessageKey SUMMARY_CLUSTERING_CONFIGURATION_SAME = new Monitor("summary.clustering.configurationSame");
        public static MessageKey SUMMARY_CLUSTERING_CONFIGURATION_TITLE = new Monitor("summary.clustering.configurationTitle");
        public static MessageKey SUMMARY_CLUSTERING_CONFIGURATION_VIEW = new Monitor("summary.clustering.configurationView");
        public static MessageKey SUMMARY_CLUSTERING_NO_CLUSTER = new Monitor("summary.clustering.noCluster");
        public static MessageKey SUMMARY_CONNECTED_USERS = new Monitor("summary.connectedUsers");
        public static MessageKey SUMMARY_CONNECTED_USERS_INFO = new Monitor("summary.connectedUsersInfo");
        public static MessageKey SUMMARY_DATABASE = new Monitor("summary.database");
        public static MessageKey SUMMARY_DATABASE_TEMPLATE = new Monitor("summary.databaseTemplate");
        public static MessageKey SUMMARY_DATABASE_VACUUM_NEVER_RUN = new Monitor("summary.databaseVacuumNeverRun");
        public static MessageKey SUMMARY_LAST_BALANCES_CLOSING_DATE = new Monitor("summary.lastBalancesClosingDate");
        public static MessageKey SUMMARY_LAST_BALANCES_CLOSING_DATE_NEVER_RUN = new Monitor("summary.lastBalancesClosingDateNeverRun");
        public static MessageKey SUMMARY_MEMBER_NAME_CLUSTER = new Monitor("summary.memberName.cluster");
        public static MessageKey SUMMARY_MEMBER_NAME_SINGLE = new Monitor("summary.memberName.single");
        public static MessageKey SUMMARY_ORGANIZATION_NAME = new Monitor("summary.organizationName");
        public static MessageKey SUMMARY_SERVER_ACTIVE_REQUESTS = new Monitor("summary.server.activeRequests");
        public static MessageKey SUMMARY_SERVER_CPU_AVAILABLE = new Monitor("summary.server.cpu.available");
        public static MessageKey SUMMARY_SERVER_CPU_LOAD = new Monitor("summary.server.cpuLoad");
        public static MessageKey SUMMARY_SERVER_CPU_PHYSICAL = new Monitor("summary.server.cpu.physical");
        public static MessageKey SUMMARY_SERVER_CPU_TEMPLATE = new Monitor("summary.server.cpuTemplate");
        public static MessageKey SUMMARY_SERVER_CYCLOS_COMMIT_ID = new Monitor("summary.server.cyclosCommitId");
        public static MessageKey SUMMARY_SERVER_CYCLOS_VERSION = new Monitor("summary.server.cyclosVersion");
        public static MessageKey SUMMARY_SERVER_JAVA_MEM = new Monitor("summary.server.javaMem");
        public static MessageKey SUMMARY_SERVER_JAVA_VERSION = new Monitor("summary.server.javaVersion");
        public static MessageKey SUMMARY_SERVER_MEMORY = new Monitor("summary.server.memory");
        public static MessageKey SUMMARY_SERVER_MEMORY_TEMPLATE = new Monitor("summary.server.memoryTemplate");
        public static MessageKey SUMMARY_SERVER_OPERATING_SYSTEM = new Monitor("summary.server.operatingSystem");
        public static MessageKey SUMMARY_SERVER_RUNNING_BACKGROUND_TASKS = new Monitor("summary.server.runningBackgroundTasks");
        public static MessageKey SUMMARY_SERVER_RUNNING_RECURRING_TASKS = new Monitor("summary.server.runningRecurringTasks");
        public static MessageKey SUMMARY_SERVER_SCRIPTING_GLOBALS_SIZE = new Monitor("summary.server.scriptingGlobalsSize");
        public static MessageKey SUMMARY_SERVER_UPTIME = new Monitor("summary.server.uptime");
        public static MessageKey SUMMARY_SERVER_UPTIME_TEMPLATE = new Monitor("summary.server.uptimeTemplate");
        public static MessageKey SUMMARY_SERVER_WEBSERVER = new Monitor("summary.server.webserver");
        public static MessageKey SUMMARY_UNKNOWN = new Monitor("summary.unknown");
        public static MessageKey TAB_BACKGROUND_TASKS = new Monitor("tab.backgroundTasks");
        public static MessageKey TAB_CACHES = new Monitor("tab.caches");
        public static MessageKey TAB_DATABASE_UPGRADES = new Monitor("tab.databaseUpgrades");
        public static MessageKey TAB_RECURRING_TASKS = new Monitor("tab.recurringTasks");
        public static MessageKey TAB_SUMMARY = new Monitor("tab.summary");
        public static MessageKey TASK_NAME = new Monitor("task.name");
        public static MessageKey TASK_NEVER_RAN = new Monitor("task.neverRan");
        public static MessageKey TASK_STATUS = new Monitor("task.status");
        public static MessageKey TASK_STATUS_IDLE = new Monitor("task.status.IDLE");
        public static MessageKey TASK_STATUS_RUNNING = new Monitor("task.status.RUNNING");
        public static MessageKey TASK_STATUS_SCHEDULED = new Monitor("task.status.SCHEDULED");
        public static MessageKey VACUUM_DATABASE = new Monitor("vacuumDatabase");
        public static MessageKey VACUUM_DATABASE_CONFIRMATION_MESSAGE = new Monitor("vacuumDatabaseConfirmationMessage");
        public static MessageKey VACUUM_DATABASE_RUNNING = new Monitor("vacuumDatabaseRunning");
        public static MessageKey VACUUM_DATABASE_SCHEDULED = new Monitor("vacuumDatabaseScheduled");
        public static MessageKey WARNINGS_INVALID_DB_POOL_SIZE = new Monitor("warnings.invalidDbPoolSize");
        public static MessageKey WARNINGS_TITLE = new Monitor("warnings.title");

        private Monitor(String string) {
            super((Submodule)SystemSubmodule.MONITOR, string);
        }
    }

    public static class WizardFields
    extends MessageKeyImpl {
        public static MessageKey OWNER_WIZARD = new WizardFields("ownerWizard");

        private WizardFields(String string) {
            super((Submodule)SystemSubmodule.WIZARD_FIELDS, string);
        }
    }

    public static class WizardSteps
    extends MessageKeyImpl {
        public static MessageKey EXTERNAL_REDIRECT = new WizardSteps("externalRedirect");
        public static MessageKey FIELDS = new WizardSteps("fields");
        public static MessageKey FIELDS_ADD_ALL = new WizardSteps("fields.addAll");
        public static MessageKey FIELDS_ADD_ALL_READ_ONLY = new WizardSteps("fields.addAllReadOnly");
        public static MessageKey FIELDS_CLEAR = new WizardSteps("fields.clear");
        public static MessageKey FIELDS_EMPTY_LINE_1 = new WizardSteps("fields.empty.line1");
        public static MessageKey FIELDS_EMPTY_LINE_2 = new WizardSteps("fields.empty.line2");
        public static MessageKey FIELDS_EMPTY_LINE_3 = new WizardSteps("fields.empty.line3");
        public static MessageKey FIELDS_ERROR_READ_ONLY_AND_VERIFICATION = new WizardSteps("fields.error.readOnlyAndVerification");
        public static MessageKey FIELDS_MARKER_READONLY = new WizardSteps("fields.marker.readonly");
        public static MessageKey FIELDS_MARKER_REQUIRE_VERIFICATION = new WizardSteps("fields.marker.requireVerification");
        public static MessageKey FIELDS_NAME = new WizardSteps("fields.name");
        public static MessageKey FIELDS_READONLY = new WizardSteps("fields.readonly");
        public static MessageKey FIELDS_REQUIRE_VERIFICATION = new WizardSteps("fields.requireVerification");
        public static MessageKey FIELDS_TYPE_AGREEMENTS = new WizardSteps("fields.type.AGREEMENTS");
        public static MessageKey FIELDS_TYPE_CAPTCHA = new WizardSteps("fields.type.CAPTCHA");
        public static MessageKey FIELDS_TYPE_CONTACT_INFO = new WizardSteps("fields.type.CONTACT_INFO");
        public static MessageKey FIELDS_TYPE_PASSWORDS = new WizardSteps("fields.type.PASSWORDS");
        public static MessageKey FIELDS_TYPE_SECURITY_QUESTION = new WizardSteps("fields.type.SECURITY_QUESTION");
        public static MessageKey FIELD_VISIBILITY = new WizardSteps("fieldVisibility");
        public static MessageKey GROUPS = new WizardSteps("groups");
        public static MessageKey GROUPS_EMPTY = new WizardSteps("groups.empty");
        public static MessageKey HEADING_DETAILS = new WizardSteps("heading.details");
        public static MessageKey HEADING_NEW = new WizardSteps("heading.new");
        public static MessageKey INFORMATION_TEXT = new WizardSteps("informationText");
        public static MessageKey NATURE = new WizardSteps("nature");
        public static MessageKey NATURE_EMAIL_VERIFICATION = new WizardSteps("nature.EMAIL_VERIFICATION");
        public static MessageKey NATURE_FORM_FIELDS = new WizardSteps("nature.FORM_FIELDS");
        public static MessageKey NATURE_GROUP = new WizardSteps("nature.GROUP");
        public static MessageKey NATURE_IDENTITY_PROVIDER = new WizardSteps("nature.IDENTITY_PROVIDER");
        public static MessageKey NATURE_PHONE_VERIFICATION = new WizardSteps("nature.PHONE_VERIFICATION");
        public static MessageKey TITLE = new WizardSteps("title");
        public static MessageKey WIZARD = new WizardSteps("wizard");

        private WizardSteps(String string) {
            super((Submodule)SystemSubmodule.WIZARD_STEPS, string);
        }
    }

    public static class Wizards
    extends MessageKeyImpl {
        public static MessageKey ADMIN_MENU = new Wizards("adminMenu");
        public static MessageKey ALREADY_EXECUTED = new Wizards("alreadyExecuted");
        public static MessageKey CHANNELS = new Wizards("channels");
        public static MessageKey EXECUTION_CODE = new Wizards("execution.code");
        public static MessageKey EXECUTION_CODE_EMAIL_SENT = new Wizards("execution.code.emailSent");
        public static MessageKey EXECUTION_CODE_EMAIL_SENT_STEP = new Wizards("execution.code.emailSent.step");
        public static MessageKey EXECUTION_CODE_NEW = new Wizards("execution.code.new");
        public static MessageKey EXECUTION_CODE_NEW_SECONDS = new Wizards("execution.code.new.seconds");
        public static MessageKey EXECUTION_CODE_SEND = new Wizards("execution.code.send");
        public static MessageKey EXECUTION_CODE_SMS_SENT = new Wizards("execution.code.smsSent");
        public static MessageKey EXECUTION_CODE_SMS_SENT_STEP = new Wizards("execution.code.smsSent.step");
        public static MessageKey EXECUTION_CODE_STEP = new Wizards("execution.code.step");
        public static MessageKey EXECUTION_CONTACT_INFO = new Wizards("execution.contactInfo");
        public static MessageKey EXECUTION_EMAIL_VERIFICATION = new Wizards("execution.emailVerification");
        public static MessageKey EXECUTION_SMS_VERIFICATION = new Wizards("execution.smsVerification");
        public static MessageKey HEADING_DETAILS = new Wizards("heading.details");
        public static MessageKey HEADING_LIST = new Wizards("heading.list");
        public static MessageKey HEADING_NEW = new Wizards("heading.new");
        public static MessageKey INCOMPLETE_REGISTRATION_NOTIFICATION_BODY = new Wizards("incompleteRegistrationNotification.body");
        public static MessageKey INCOMPLETE_REGISTRATION_NOTIFICATION_SUBJECT = new Wizards("incompleteRegistrationNotification.subject");
        public static MessageKey LABEL = new Wizards("label");
        public static MessageKey MOBILE_ICON = new Wizards("mobileIcon");
        public static MessageKey NATURE = new Wizards("nature");
        public static MessageKey NATURE_MENU = new Wizards("nature.MENU");
        public static MessageKey NATURE_REGISTRATION = new Wizards("nature.REGISTRATION");
        public static MessageKey NATURE_SYSTEM = new Wizards("nature.SYSTEM");
        public static MessageKey NATURE_USER = new Wizards("nature.USER");
        public static MessageKey NOTIFY_ON_INCOMPLETE_REGISTRATION = new Wizards("notifyOnIncompleteRegistration");
        public static MessageKey PROFILE_SECTION = new Wizards("profileSection");
        public static MessageKey REQUIRE_CONFIRMATION_CREDENTIAL = new Wizards("requireConfirmationCredential");
        public static MessageKey RESULT_TYPE = new Wizards("resultType");
        public static MessageKey RESULT_TYPE_PLAIN_TEXT = new Wizards("resultType.PLAIN_TEXT");
        public static MessageKey RESULT_TYPE_REGISTRATION = new Wizards("resultType.REGISTRATION");
        public static MessageKey RESULT_TYPE_RICH_TEXT = new Wizards("resultType.RICH_TEXT");
        public static MessageKey SCRIPT = new Wizards("script");
        public static MessageKey SCRIPT_PARAMETERS = new Wizards("scriptParameters");
        public static MessageKey SHOW_PROGRESS = new Wizards("showProgress");
        public static MessageKey SHOW_PROGRESS_INFO = new Wizards("showProgress.info");
        public static MessageKey TAB_FIELDS = new Wizards("tab.fields");
        public static MessageKey TAB_STEPS = new Wizards("tab.steps");
        public static MessageKey TRANSITION = new Wizards("transition");
        public static MessageKey USER_MENU = new Wizards("userMenu");

        private Wizards(String string) {
            super((Submodule)SystemSubmodule.WIZARDS, string);
        }
    }

    public static class WebServices
    extends MessageKeyImpl {
        public static MessageKey ERROR_NO_SCRIPTS = new WebServices("error.noScripts");
        public static MessageKey ERROR_UNIQUE_URL_MAPPINGS = new WebServices("error.uniqueUrlMappings");
        public static MessageKey HEADING_DETAILS = new WebServices("heading.details");
        public static MessageKey HEADING_LIST = new WebServices("heading.list");
        public static MessageKey HEADING_NEW = new WebServices("heading.new");
        public static MessageKey IP_WHITELIST = new WebServices("ipWhitelist");
        public static MessageKey IP_WHITELIST_ANY = new WebServices("ipWhitelist.any");
        public static MessageKey METHOD = new WebServices("method");
        public static MessageKey METHOD_BOTH = new WebServices("method.BOTH");
        public static MessageKey METHOD_GET = new WebServices("method.GET");
        public static MessageKey METHOD_POST = new WebServices("method.POST");
        public static MessageKey PASSWORD = new WebServices("password");
        public static MessageKey PASSWORD_DEFINED = new WebServices("passwordDefined");
        public static MessageKey PASSWORD_SET = new WebServices("passwordSet");
        public static MessageKey RUN_AS = new WebServices("runAs");
        public static MessageKey RUN_AS_GUEST = new WebServices("runAs.GUEST");
        public static MessageKey RUN_AS_GUEST_WITH_AUTHORIZATION = new WebServices("runAs.GUEST_WITH_AUTHORIZATION");
        public static MessageKey RUN_AS_USER = new WebServices("runAs.USER");
        public static MessageKey SCRIPT = new WebServices("script");
        public static MessageKey SCRIPT_PARAMETERS = new WebServices("scriptParameters");
        public static MessageKey URL_MAPPINGS = new WebServices("urlMappings");
        public static MessageKey USERNAME = new WebServices("username");

        private WebServices(String string) {
            super((Submodule)SystemSubmodule.WEB_SERVICES, string);
        }
    }

    public static class EntityLogs
    extends MessageKeyImpl {
        public static MessageKey AS_MANAGER = new EntityLogs("asManager");
        public static MessageKey BELONGS_TO = new EntityLogs("belongsTo");
        public static MessageKey BY = new EntityLogs("by");
        public static MessageKey CHANGES_PERFORMED_BY_ME = new EntityLogs("changesPerformedByMe");
        public static MessageKey CHANNEL = new EntityLogs("CHANNEL");
        public static MessageKey CREATED_BY = new EntityLogs("createdBy");
        public static MessageKey DATE = new EntityLogs("date");
        public static MessageKey DEFINED = new EntityLogs("defined");
        public static MessageKey DELETED = new EntityLogs("deleted");
        public static MessageKey DELETED_BY = new EntityLogs("deletedBy");
        public static MessageKey ENTITY_CREATED = new EntityLogs("entityCreated");
        public static MessageKey ENTITY_NAME = new EntityLogs("entityName");
        public static MessageKey EVENT_CREATE = new EntityLogs("event.CREATE");
        public static MessageKey EVENT_DELETE = new EntityLogs("event.DELETE");
        public static MessageKey EVENT_UPDATE = new EntityLogs("event.UPDATE");
        public static MessageKey FIELD = new EntityLogs("field");
        public static MessageKey FILTER_ACTION = new EntityLogs("filter.action");
        public static MessageKey FILTER_RECORD_TYPE = new EntityLogs("filter.recordType");
        public static MessageKey FILTER_USER = new EntityLogs("filter.user");
        public static MessageKey GENERAL_TYPE_AD = new EntityLogs("generalType.AD");
        public static MessageKey GENERAL_TYPE_CONFIGURATION = new EntityLogs("generalType.CONFIGURATION");
        public static MessageKey GENERAL_TYPE_RECORD = new EntityLogs("generalType.RECORD");
        public static MessageKey GENERAL_TYPE_USER = new EntityLogs("generalType.USER");
        public static MessageKey HEADING = new EntityLogs("heading");
        public static MessageKey HEADING_CONFIGURATION_GENERAL_SEARCH = new EntityLogs("heading.configurationGeneralSearch");
        public static MessageKey HEADING_DETAILS = new EntityLogs("heading.details");
        public static MessageKey HEADING_USER = new EntityLogs("heading.user");
        public static MessageKey HEADING_USER_GENERAL_SEARCH = new EntityLogs("heading.userGeneralSearch");
        public static MessageKey LOCKED = new EntityLogs("locked");
        public static MessageKey NETWORK = new EntityLogs("network");
        public static MessageKey NEW_VALUE = new EntityLogs("newValue");
        public static MessageKey NOT_APPLICABLE = new EntityLogs("notApplicable");
        public static MessageKey OLD_VALUE = new EntityLogs("oldValue");
        public static MessageKey ONLY_GLOBAL = new EntityLogs("onlyGlobal");
        public static MessageKey ORDER_BY_DATE_DESC = new EntityLogs("orderByDateDesc");
        public static MessageKey ORDER_BY_PROPERTY_ASC = new EntityLogs("orderByPropertyAsc");
        public static MessageKey PERIOD = new EntityLogs("period");
        public static MessageKey PERMISSIONS_HEADING = new EntityLogs("permissionsHeading");
        public static MessageKey REMOTE_ADDRESS = new EntityLogs("remoteAddress");
        public static MessageKey TYPE = new EntityLogs("type");
        public static MessageKey TYPES = new EntityLogs("types");
        public static MessageKey TYPES_ALL_ENTITIES = new EntityLogs("types.allEntities");
        public static MessageKey TYPE_ACCOUNT_FEE = new EntityLogs("type.ACCOUNT_FEE");
        public static MessageKey TYPE_ACCOUNT_TYPE = new EntityLogs("type.ACCOUNT_TYPE");
        public static MessageKey TYPE_AD = new EntityLogs("type.AD");
        public static MessageKey TYPE_ADDRESS = new EntityLogs("type.ADDRESS");
        public static MessageKey TYPE_AD_CUSTOM_FIELD = new EntityLogs("type.AD_CUSTOM_FIELD");
        public static MessageKey TYPE_AD_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.AD_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_AGREEMENT = new EntityLogs("type.AGREEMENT");
        public static MessageKey TYPE_AUTHORIZATION_LEVEL = new EntityLogs("type.AUTHORIZATION_LEVEL");
        public static MessageKey TYPE_CHANNEL_CONFIGURATION = new EntityLogs("type.CHANNEL_CONFIGURATION");
        public static MessageKey TYPE_CONFIGURATION = new EntityLogs("type.CONFIGURATION");
        public static MessageKey TYPE_CONTACT_CUSTOM_FIELD = new EntityLogs("type.CONTACT_CUSTOM_FIELD");
        public static MessageKey TYPE_CONTACT_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.CONTACT_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_CONTACT_INFO_CUSTOM_FIELD = new EntityLogs("type.CONTACT_INFO_CUSTOM_FIELD");
        public static MessageKey TYPE_CONTACT_INFO_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.CONTACT_INFO_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_CURRENCY = new EntityLogs("type.CURRENCY");
        public static MessageKey TYPE_CUSTOM_BACKGROUND_TASK = new EntityLogs("type.CUSTOM_BACKGROUND_TASK");
        public static MessageKey TYPE_CUSTOM_OPERATION = new EntityLogs("type.CUSTOM_OPERATION");
        public static MessageKey TYPE_CUSTOM_OPERATION_CUSTOM_FIELD = new EntityLogs("type.CUSTOM_OPERATION_CUSTOM_FIELD");
        public static MessageKey TYPE_CUSTOM_OPERATION_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.CUSTOM_OPERATION_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_CUSTOM_RECURRING_TASK = new EntityLogs("type.CUSTOM_RECURRING_TASK");
        public static MessageKey TYPE_CUSTOM_SCRIPT = new EntityLogs("type.CUSTOM_SCRIPT");
        public static MessageKey TYPE_CUSTOM_WEB_SERVICE = new EntityLogs("type.CUSTOM_WEB_SERVICE");
        public static MessageKey TYPE_CUSTOM_WIZARD = new EntityLogs("type.CUSTOM_WIZARD");
        public static MessageKey TYPE_CUSTOM_WIZARD_CUSTOM_FIELD = new EntityLogs("type.CUSTOM_WIZARD_CUSTOM_FIELD");
        public static MessageKey TYPE_CUSTOM_WIZARD_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.CUSTOM_WIZARD_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_CUSTOM_WIZARD_STEP = new EntityLogs("type.CUSTOM_WIZARD_STEP");
        public static MessageKey TYPE_DOCUMENT_CUSTOM_FIELD = new EntityLogs("type.DOCUMENT_CUSTOM_FIELD");
        public static MessageKey TYPE_DOCUMENT_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.DOCUMENT_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_EXPORT_FORMAT = new EntityLogs("type.EXPORT_FORMAT");
        public static MessageKey TYPE_FILTER_USER_ACTIONS = new EntityLogs("typeFilter.USER_ACTIONS");
        public static MessageKey TYPE_FILTER_USER_FIELDS = new EntityLogs("typeFilter.USER_FIELDS");
        public static MessageKey TYPE_IDENTITY_PROVIDER = new EntityLogs("type.IDENTITY_PROVIDER");
        public static MessageKey TYPE_LANGUAGE = new EntityLogs("type.LANGUAGE");
        public static MessageKey TYPE_OIDC_CLIENT = new EntityLogs("type.OIDC_CLIENT");
        public static MessageKey TYPE_OPERATOR = new EntityLogs("type.OPERATOR");
        public static MessageKey TYPE_PASSWORD_TYPE = new EntityLogs("type.PASSWORD_TYPE");
        public static MessageKey TYPE_PHONE = new EntityLogs("type.PHONE");
        public static MessageKey TYPE_PRINCIPAL_TYPE = new EntityLogs("type.PRINCIPAL_TYPE");
        public static MessageKey TYPE_PRIVACY_CONTROL = new EntityLogs("type.PRIVACY_CONTROL");
        public static MessageKey TYPE_PRODUCT = new EntityLogs("type.PRODUCT");
        public static MessageKey TYPE_RECORD_CUSTOM_FIELD = new EntityLogs("type.RECORD_CUSTOM_FIELD");
        public static MessageKey TYPE_RECORD_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.RECORD_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_RECORD_TYPE = new EntityLogs("type.RECORD_TYPE");
        public static MessageKey TYPE_SERVICE_INTERCEPTOR = new EntityLogs("type.SERVICE_INTERCEPTOR");
        public static MessageKey TYPE_SMS_OPERATION_CONFIGURATION = new EntityLogs("type.SMS_OPERATION_CONFIGURATION");
        public static MessageKey TYPE_SYSTEM_RECORD = new EntityLogs("type.SYSTEM_RECORD");
        public static MessageKey TYPE_TOKEN = new EntityLogs("type.TOKEN");
        public static MessageKey TYPE_TRANSACTION_CUSTOM_FIELD = new EntityLogs("type.TRANSACTION_CUSTOM_FIELD");
        public static MessageKey TYPE_TRANSACTION_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.TRANSACTION_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_TRANSFER_FEE = new EntityLogs("type.TRANSFER_FEE");
        public static MessageKey TYPE_TRANSFER_FILTER = new EntityLogs("type.TRANSFER_FILTER");
        public static MessageKey TYPE_TRANSFER_TYPE = new EntityLogs("type.TRANSFER_TYPE");
        public static MessageKey TYPE_USER = new EntityLogs("type.USER");
        public static MessageKey TYPE_USER_CUSTOM_FIELD = new EntityLogs("type.USER_CUSTOM_FIELD");
        public static MessageKey TYPE_USER_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.USER_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_USER_RECORD = new EntityLogs("type.USER_RECORD");
        public static MessageKey TYPE_VOUCHER_CONFIGURATION = new EntityLogs("type.VOUCHER_CONFIGURATION");
        public static MessageKey TYPE_VOUCHER_CUSTOM_FIELD = new EntityLogs("type.VOUCHER_CUSTOM_FIELD");
        public static MessageKey TYPE_VOUCHER_CUSTOM_FIELD_POSSIBLE_VALUE = new EntityLogs("type.VOUCHER_CUSTOM_FIELD_POSSIBLE_VALUE");
        public static MessageKey TYPE_VOUCHER_TYPE = new EntityLogs("type.VOUCHER_TYPE");
        public static MessageKey UPDATED_BY = new EntityLogs("updatedBy");
        public static MessageKey VIEW_ENTITY = new EntityLogs("viewEntity");

        private EntityLogs(String string) {
            super((Submodule)SystemSubmodule.ENTITY_LOGS, string);
        }
    }

    public static class Interceptors
    extends MessageKeyImpl {
        public static MessageKey ENABLED = new Interceptors("enabled");
        public static MessageKey ERROR_NO_SCRIPTS = new Interceptors("error.noScripts");
        public static MessageKey HEADING_DETAILS = new Interceptors("heading.details");
        public static MessageKey HEADING_LIST = new Interceptors("heading.list");
        public static MessageKey HEADING_NEW = new Interceptors("heading.new");
        public static MessageKey OPERATIONS = new Interceptors("operations");
        public static MessageKey OPERATIONS_ALL = new Interceptors("operations.all");
        public static MessageKey SCRIPT = new Interceptors("script");
        public static MessageKey SCRIPT_PARAMETERS = new Interceptors("scriptParameters");
        public static MessageKey SERVICES = new Interceptors("services");
        public static MessageKey SERVICES_ALL = new Interceptors("services.all");

        private Interceptors(String string) {
            super((Submodule)SystemSubmodule.INTERCEPTORS, string);
        }
    }

    public static class Imports
    extends MessageKeyImpl {
        public static MessageKey ABORT = new Imports("abort");
        public static MessageKey ABORTING = new Imports("aborting");
        public static MessageKey ARCHIVE_DATE_MESSAGE = new Imports("archiveDate.message");
        public static MessageKey BY = new Imports("by");
        public static MessageKey CREATION_DATE = new Imports("creationDate");
        public static MessageKey CURRENCY = new Imports("currency");
        public static MessageKey DEFAULT_AMOUNT = new Imports("defaultAmount");
        public static MessageKey DEFAULT_GROUP = new Imports("defaultGroup");
        public static MessageKey ERROR_CANNOT_IMPORT_NFC = new Imports("error.cannotImportNfc");
        public static MessageKey ERROR_DATE_CONVERSION = new Imports("error.dateConversion");
        public static MessageKey ERROR_GENERAL_REFERENCE_LEVEL = new Imports("error.generalReference.level");
        public static MessageKey ERROR_GENERAL_REFERENCE_TO_NOT_FOUND = new Imports("error.generalReference.toNotFound");
        public static MessageKey ERROR_GROUP_DISABLED = new Imports("error.groupDisabled");
        public static MessageKey ERROR_IMPORT_HEADERS_NOT_FOUND = new Imports("error.importHeadersNotFound");
        public static MessageKey ERROR_INTERNAL_ERROR = new Imports("error.internalError");
        public static MessageKey ERROR_INVALID_BOOLEAN_VALUE = new Imports("error.invalidBooleanValue");
        public static MessageKey ERROR_INVALID_BROKER = new Imports("error.invalidBroker");
        public static MessageKey ERROR_INVALID_IMAGE_PATH = new Imports("error.invalidImagePath");
        public static MessageKey ERROR_INVALID_NUMBER_FORMAT = new Imports("error.invalidNumberFormat");
        public static MessageKey ERROR_INVALID_PRINCIPAL = new Imports("error.invalidPrincipal");
        public static MessageKey ERROR_INVALID_TRANSFER_TYPE = new Imports("error.invalidTransferType");
        public static MessageKey ERROR_INVALID_VALUE = new Imports("error.invalidValue");
        public static MessageKey ERROR_MAX_ITEMS_REACHED = new Imports("error.maxItemsReached");
        public static MessageKey ERROR_MESSAGES = new Imports("errorMessages");
        public static MessageKey ERROR_MISSING_REQUIRED_IMPORT_HEADERS = new Imports("error.missingRequiredImportHeaders");
        public static MessageKey ERROR_NOTHING_TO_IMPORT = new Imports("error.nothingToImport");
        public static MessageKey ERROR_POSSIBLE_VALUE_NOT_FOUND = new Imports("error.possibleValueNotFound");
        public static MessageKey ERROR_REQUIRED_FILE = new Imports("error.requiredFile");
        public static MessageKey FILE = new Imports("file");
        public static MessageKey GROUP = new Imports("group");
        public static MessageKey HEADING_BANKING_SEARCH = new Imports("heading.banking.search");
        public static MessageKey HEADING_DETAILS = new Imports("heading.details");
        public static MessageKey HEADING_LINE_DETAILS = new Imports("heading.lineDetails");
        public static MessageKey HEADING_NEW = new Imports("heading.new");
        public static MessageKey HEADING_SEARCH = new Imports("heading.search");
        public static MessageKey HEADING_USER_PAYMENTS_DETAILS = new Imports("heading.userPayments.details");
        public static MessageKey HEADING_USER_PAYMENTS_LINE_DETAILS = new Imports("heading.userPayments.lineDetails");
        public static MessageKey HEADING_USER_PAYMENTS_NEW = new Imports("heading.userPayments.new");
        public static MessageKey HEADING_USER_PAYMENTS_SEARCH = new Imports("heading.userPayments.search");
        public static MessageKey HEADING_USER_SEND_VOUCHERS_DETAILS = new Imports("heading.userSendVouchers.details");
        public static MessageKey HEADING_USER_SEND_VOUCHERS_LINE_DETAILS = new Imports("heading.userSendVouchers.lineDetails");
        public static MessageKey HEADING_USER_SEND_VOUCHERS_NEW = new Imports("heading.userSendVouchers.new");
        public static MessageKey HEADING_USER_SEND_VOUCHERS_SEARCH = new Imports("heading.userSendVouchers.search");
        public static MessageKey IGNORED_FIELDS = new Imports("ignoredFields");
        public static MessageKey IMPORT = new Imports("import");
        public static MessageKey IMPORT_ERRORS = new Imports("importErrors");
        public static MessageKey IMPORT_FILE_STATUS = new Imports("importFileStatus");
        public static MessageKey IMPORT_FILE_STATUS_ABORTED = new Imports("importFileStatus.ABORTED");
        public static MessageKey IMPORT_FILE_STATUS_ARCHIVED = new Imports("importFileStatus.ARCHIVED");
        public static MessageKey IMPORT_FILE_STATUS_IMPORTED = new Imports("importFileStatus.IMPORTED");
        public static MessageKey IMPORT_FILE_STATUS_IMPORTING = new Imports("importFileStatus.IMPORTING");
        public static MessageKey IMPORT_FILE_STATUS_INTERNAL_ERROR = new Imports("importFileStatus.INTERNAL_ERROR");
        public static MessageKey IMPORT_FILE_STATUS_INVALID = new Imports("importFileStatus.INVALID");
        public static MessageKey IMPORT_FILE_STATUS_READING_CSV = new Imports("importFileStatus.READING_CSV");
        public static MessageKey IMPORT_FILE_STATUS_READING_ZIP = new Imports("importFileStatus.READING_ZIP");
        public static MessageKey IMPORT_FILE_STATUS_READY = new Imports("importFileStatus.READY");
        public static MessageKey IMPORT_IN_PROGRESS = new Imports("importInProgress");
        public static MessageKey IMPORT_LINES = new Imports("importLines");
        public static MessageKey IMPORT_LINE_STATUS = new Imports("importLineStatus");
        public static MessageKey IMPORT_LINE_STATUS_IMPORTED = new Imports("importLineStatus.IMPORTED");
        public static MessageKey IMPORT_LINE_STATUS_IMPORT_ERROR = new Imports("importLineStatus.IMPORT_ERROR");
        public static MessageKey IMPORT_LINE_STATUS_READY = new Imports("importLineStatus.READY");
        public static MessageKey IMPORT_LINE_STATUS_SKIPPED = new Imports("importLineStatus.SKIPPED");
        public static MessageKey IMPORT_LINE_STATUS_VALIDATION_ERROR = new Imports("importLineStatus.VALIDATION_ERROR");
        public static MessageKey IMPORT_NEW = new Imports("importNew");
        public static MessageKey IMPORT_READY_RESULTS = new Imports("importReadyResults");
        public static MessageKey IMPORT_SECTION = new Imports("importSection");
        public static MessageKey IMPORT_SUCCESS = new Imports("importSuccess");
        public static MessageKey IMPORT_TYPE = new Imports("importType");
        public static MessageKey IMPORT_TYPE_ADS_IMPORT = new Imports("importType.ADS_IMPORT");
        public static MessageKey IMPORT_TYPE_GENERAL_REFERENCES_IMPORT = new Imports("importType.GENERAL_REFERENCES_IMPORT");
        public static MessageKey IMPORT_TYPE_PAYMENTS_IMPORT = new Imports("importType.PAYMENTS_IMPORT");
        public static MessageKey IMPORT_TYPE_RECORDS_IMPORT = new Imports("importType.RECORDS_IMPORT");
        public static MessageKey IMPORT_TYPE_TOKENS_IMPORT = new Imports("importType.TOKENS_IMPORT");
        public static MessageKey IMPORT_TYPE_TRANSFERS_IMPORT = new Imports("importType.TRANSFERS_IMPORT");
        public static MessageKey IMPORT_TYPE_USERS_IMPORT = new Imports("importType.USERS_IMPORT");
        public static MessageKey IMPORT_TYPE_USER_PAYMENTS_IMPORT = new Imports("importType.USER_PAYMENTS_IMPORT");
        public static MessageKey IMPORT_TYPE_USER_SEND_VOUCHERS_IMPORT = new Imports("importType.USER_SEND_VOUCHERS_IMPORT");
        public static MessageKey INCLUDE_SELECTED = new Imports("includeSelected");
        public static MessageKey INVALID_CUSTOM_FIELD = new Imports("invalidCustomField");
        public static MessageKey INVALID_ENTITY = new Imports("invalidEntity");
        public static MessageKey INVALID_NUMBER_OF_CSV_FILES = new Imports("invalidNumberOfCsvFiles");
        public static MessageKey INVALID_USER = new Imports("invalidUser");
        public static MessageKey IS_HIDDEN = new Imports("isHidden");
        public static MessageKey KEYWORDS = new Imports("keywords");
        public static MessageKey LINE = new Imports("line");
        public static MessageKey MISSING_GROUP = new Imports("missingGroup");
        public static MessageKey PROCESSING_DATE = new Imports("processingDate");
        public static MessageKey PROGRESS = new Imports("progress");
        public static MessageKey RECORD_TYPE = new Imports("recordType");
        public static MessageKey SEND_ACTIVATION_EMAIL = new Imports("sendActivationEmail");
        public static MessageKey SKIPPED = new Imports("skipped");
        public static MessageKey SKIP_SELECTED = new Imports("skipSelected");
        public static MessageKey TOKENS_INVALID_TOKEN_TYPE = new Imports("tokens.invalidTokenType");
        public static MessageKey TRANSFER_FROM_IS_REQUIRED = new Imports("transfer.fromIsRequired");
        public static MessageKey TRANSFER_STATUS_FLOW_NOT_ALLOWED = new Imports("transferStatusFlowNotAllowed");
        public static MessageKey TRANSFER_STATUS_INVALID = new Imports("transferStatusInvalid");
        public static MessageKey TRANSFER_TO_IS_REQUIRED = new Imports("transfer.toIsRequired");
        public static MessageKey TRANSFER_TYPE_IS_REQUIRED = new Imports("transfer.typeIsRequired");
        public static MessageKey TRANSFER_USAGE_WARNING = new Imports("transfer.usageWarning");
        public static MessageKey UPLOAD = new Imports("upload");
        public static MessageKey UPLOADING_FILE = new Imports("uploadingFile");
        public static MessageKey UPLOAD_FILE = new Imports("uploadFile");
        public static MessageKey USER_IMPORT_FIELDS_ADDRESS_NAME = new Imports("userImportFields.ADDRESS_NAME");
        public static MessageKey USER_IMPORT_FIELDS_LANDLINE_NAME = new Imports("userImportFields.LANDLINE_NAME");
        public static MessageKey USER_IMPORT_FIELDS_LANDLINE_NUMBER = new Imports("userImportFields.LANDLINE_NUMBER");
        public static MessageKey USER_IMPORT_FIELDS_LANDLINE_PRIVATE = new Imports("userImportFields.LANDLINE_PRIVATE");
        public static MessageKey USER_IMPORT_FIELDS_MOBILE_NAME = new Imports("userImportFields.MOBILE_NAME");
        public static MessageKey USER_IMPORT_FIELDS_MOBILE_NUMBER = new Imports("userImportFields.MOBILE_NUMBER");
        public static MessageKey USER_IMPORT_FIELDS_MOBILE_PRIVATE = new Imports("userImportFields.MOBILE_PRIVATE");
        public static MessageKey USER_IMPORT_FIELDS_PASSWORD = new Imports("userImportFields.PASSWORD");
        public static MessageKey USER_IMPORT_FIELDS_PASSWORD_FORCE_CHANGE = new Imports("userImportFields.PASSWORD_FORCE_CHANGE");
        public static MessageKey USER_IMPORT_FIELDS_PASSWORD_VALUE = new Imports("userImportFields.PASSWORD_VALUE");
        public static MessageKey USE_AMOUNT_FROM_FILE = new Imports("useAmountFromFile");
        public static MessageKey USE_GROUP_FROM_FILE = new Imports("useGroupFromFile");
        public static MessageKey VALIDATION_ERRORS = new Imports("validationErrors");
        public static MessageKey VALIDATION_IN_PROGRESS = new Imports("validationInProgress");
        public static MessageKey VALIDATION_SECTION = new Imports("validationSection");
        public static MessageKey VALIDATION_SUCCESS = new Imports("validationSuccess");
        public static MessageKey VIEW_ERRORS = new Imports("viewErrors");
        public static MessageKey VIEW_IMPORTED_DATA = new Imports("viewImportedData");
        public static MessageKey VOUCHER_INFORMATION = new Imports("voucher.information");

        private Imports(String string) {
            super((Submodule)SystemSubmodule.IMPORTS, string);
        }
    }

    public static class SmsOperationConfigurations
    extends MessageKeyImpl {
        public static MessageKey ACCOUNT_TYPE = new SmsOperationConfigurations("accountType");
        public static MessageKey ALIASES = new SmsOperationConfigurations("aliases");
        public static MessageKey CHANNEL_CONFIGURATION = new SmsOperationConfigurations("channelConfiguration");
        public static MessageKey ENABLED = new SmsOperationConfigurations("enabled");
        public static MessageKey ERROR_INVALID_ALIAS_WORDS_COUNT = new SmsOperationConfigurations("error.invalidAliasWordsCount");
        public static MessageKey GROUP = new SmsOperationConfigurations("group");
        public static MessageKey HEADING_DETAILS = new SmsOperationConfigurations("heading.details");
        public static MessageKey HEADING_NEW = new SmsOperationConfigurations("heading.new");
        public static MessageKey HEADING_SMS_TEXTS = new SmsOperationConfigurations("heading.smsTexts");
        public static MessageKey HELP_MESSAGE = new SmsOperationConfigurations("helpMessage");
        public static MessageKey LOG_PLAIN_SMS = new SmsOperationConfigurations("logPlainSms");
        public static MessageKey NATURE = new SmsOperationConfigurations("nature");
        public static MessageKey NATURE_ACCEPT_PAYMENT_REQUEST = new SmsOperationConfigurations("nature.ACCEPT_PAYMENT_REQUEST");
        public static MessageKey NATURE_ACCOUNT_INFORMATION = new SmsOperationConfigurations("nature.ACCOUNT_INFORMATION");
        public static MessageKey NATURE_CUSTOM = new SmsOperationConfigurations("nature.CUSTOM");
        public static MessageKey NATURE_DENY_PAYMENT_REQUEST = new SmsOperationConfigurations("nature.DENY_PAYMENT_REQUEST");
        public static MessageKey NATURE_HELP = new SmsOperationConfigurations("nature.HELP");
        public static MessageKey NATURE_PAYMENT = new SmsOperationConfigurations("nature.PAYMENT");
        public static MessageKey NATURE_PERFORM_EXTERNAL_PAYMENT = new SmsOperationConfigurations("nature.PERFORM_EXTERNAL_PAYMENT");
        public static MessageKey NATURE_REDEEM_VOUCHER = new SmsOperationConfigurations("nature.REDEEM_VOUCHER");
        public static MessageKey NATURE_REGISTER = new SmsOperationConfigurations("nature.REGISTER");
        public static MessageKey NATURE_SEND_PAYMENT_REQUEST = new SmsOperationConfigurations("nature.SEND_PAYMENT_REQUEST");
        public static MessageKey NATURE_TEXT = new SmsOperationConfigurations("nature.TEXT");
        public static MessageKey OPERATION_EXECUTION = new SmsOperationConfigurations("operationExecution");
        public static MessageKey OPERATION_EXECUTION_ALL = new SmsOperationConfigurations("operationExecution.ALL");
        public static MessageKey OPERATION_EXECUTION_ONLY_BY_GUESTS = new SmsOperationConfigurations("operationExecution.ONLY_BY_GUESTS");
        public static MessageKey OPERATION_EXECUTION_ONLY_BY_REGISTERED_USERS = new SmsOperationConfigurations("operationExecution.ONLY_BY_REGISTERED_USERS");
        public static MessageKey PAYMENT_TYPE = new SmsOperationConfigurations("paymentType");
        public static MessageKey SCRIPT = new SmsOperationConfigurations("script");
        public static MessageKey SCRIPT_PARAMETERS = new SmsOperationConfigurations("scriptParameters");
        public static MessageKey SEND_PAYMENT_REQUEST_EXPIRATION = new SmsOperationConfigurations("sendPaymentRequestExpiration");
        public static MessageKey TEXT = new SmsOperationConfigurations("text");
        public static MessageKey USE_PASSWORD = new SmsOperationConfigurations("usePassword");

        private SmsOperationConfigurations(String string) {
            super((Submodule)SystemSubmodule.SMS_OPERATION_CONFIGURATIONS, string);
        }
    }

    public static class Setup
    extends MessageKeyImpl {
        public static MessageKey ERROR_AUTHENTICATION = new Setup("error.authentication");
        public static MessageKey LICENSE_PASSWORD = new Setup("licensePassword");
        public static MessageKey LICENSE_USERNAME = new Setup("licenseUsername");
        public static MessageKey WIZARD_ADMINISTRATOR = new Setup("wizard.administrator");
        public static MessageKey WIZARD_ADMINISTRATOR_INFORMATION = new Setup("wizard.administrator.information");
        public static MessageKey WIZARD_CONFIGURATION = new Setup("wizard.configuration");
        public static MessageKey WIZARD_CONFIGURATION_INFORMATION = new Setup("wizard.configuration.information");
        public static MessageKey WIZARD_LICENSE_AUTHENTICATION = new Setup("wizard.licenseAuthentication");
        public static MessageKey WIZARD_LICENSE_AUTHENTICATION_INFORMATION = new Setup("wizard.licenseAuthentication.information");

        private Setup(String string) {
            super((Submodule)SystemSubmodule.SETUP, string);
        }
    }

    public static class Scripts
    extends MessageKeyImpl {
        public static MessageKey CODE = new Scripts("code");
        public static MessageKey CODE_CUSTOM_OPERATION_AVAILABILITY = new Scripts("code.customOperation.AVAILABILITY");
        public static MessageKey CODE_CUSTOM_OPERATION_CALLBACK = new Scripts("code.customOperation.CALLBACK");
        public static MessageKey CODE_CUSTOM_OPERATION_DEFAULT = new Scripts("code.customOperation.DEFAULT");
        public static MessageKey CODE_CUSTOM_OPERATION_PRE_RUN = new Scripts("code.customOperation.PRE_RUN");
        public static MessageKey CODE_CUSTOM_WIZARD_CALLBACK = new Scripts("code.customWizard.CALLBACK");
        public static MessageKey CODE_CUSTOM_WIZARD_DEFAULT = new Scripts("code.customWizard.DEFAULT");
        public static MessageKey CODE_CUSTOM_WIZARD_EXTERNAL_REDIRECT = new Scripts("code.customWizard.EXTERNAL_REDIRECT");
        public static MessageKey CODE_CUSTOM_WIZARD_START = new Scripts("code.customWizard.START");
        public static MessageKey CODE_CUSTOM_WIZARD_TRANSITION = new Scripts("code.customWizard.TRANSITION");
        public static MessageKey CODE_EXTENSION_POINT_SAVED = new Scripts("code.extensionPoint.SAVED");
        public static MessageKey CODE_EXTENSION_POINT_VALIDATED = new Scripts("code.extensionPoint.VALIDATED");
        public static MessageKey CODE_INBOUND_SMS_GENERATE_RESPONSE = new Scripts("code.inboundSms.GENERATE_RESPONSE");
        public static MessageKey CODE_INBOUND_SMS_RESOLVE_SMS_DATA = new Scripts("code.inboundSms.RESOLVE_SMS_DATA");
        public static MessageKey CODE_LOAD_VALUES_ENTITY = new Scripts("code.loadValues.ENTITY");
        public static MessageKey CODE_LOAD_VALUES_FILTER = new Scripts("code.loadValues.FILTER");
        public static MessageKey CODE_PHONE_NUMBER_HANDLING_EXAMPLE = new Scripts("code.phoneNumberHandling.EXAMPLE");
        public static MessageKey CODE_PHONE_NUMBER_HANDLING_PARSE = new Scripts("code.phoneNumberHandling.PARSE");
        public static MessageKey CODE_SERVICE_INTERCEPTOR_AFTER = new Scripts("code.serviceInterceptor.AFTER");
        public static MessageKey CODE_SERVICE_INTERCEPTOR_BEFORE = new Scripts("code.serviceInterceptor.BEFORE");
        public static MessageKey CODE_SESSION_HANDLING_LOGIN = new Scripts("code.sessionHandling.LOGIN");
        public static MessageKey CODE_SESSION_HANDLING_LOGOUT = new Scripts("code.sessionHandling.LOGOUT");
        public static MessageKey CODE_SESSION_HANDLING_RESOLVE = new Scripts("code.sessionHandling.RESOLVE");
        public static MessageKey CODE_SESSION_HANDLING_SEARCH = new Scripts("code.sessionHandling.SEARCH");
        public static MessageKey CODE_SESSION_HANDLING_SET_PROPERTIES = new Scripts("code.sessionHandling.SET_PROPERTIES");
        public static MessageKey CONTENT = new Scripts("content");
        public static MessageKey DEPENDENCIES = new Scripts("dependencies");
        public static MessageKey ERROR_CIRCULAR_DEPENDENCIES = new Scripts("error.circularDependencies");
        public static MessageKey GET_CODE_FOR_DEBUG = new Scripts("getCodeForDebug");
        public static MessageKey GET_CODE_FOR_DEBUG_DISABLED = new Scripts("getCodeForDebug.disabled");
        public static MessageKey HEADING_DETAILS = new Scripts("heading.details");
        public static MessageKey HEADING_NEW = new Scripts("heading.new");
        public static MessageKey HEADING_RUN = new Scripts("heading.run");
        public static MessageKey HEADING_SEARCH = new Scripts("heading.search");
        public static MessageKey PARAMETERS = new Scripts("parameters");
        public static MessageKey RUN = new Scripts("run");
        public static MessageKey RUN_AS_SYSTEM = new Scripts("runAsSystem");
        public static MessageKey RUN_DONE_NO_RESULT = new Scripts("run.done.noResult");
        public static MessageKey RUN_DONE_TITLE = new Scripts("run.done.title");
        public static MessageKey RUN_SCRIPT = new Scripts("run.script");
        public static MessageKey TYPE = new Scripts("type");
        public static MessageKey TYPE_ACCOUNT_FEE_CALCULATION = new Scripts("type.ACCOUNT_FEE_CALCULATION");
        public static MessageKey TYPE_ACCOUNT_NUMBER_GENERATION = new Scripts("type.ACCOUNT_NUMBER_GENERATION");
        public static MessageKey TYPE_BACKGROUND_TASK = new Scripts("type.BACKGROUND_TASK");
        public static MessageKey TYPE_CONTENT_HELPER = new Scripts("type.CONTENT_HELPER");
        public static MessageKey TYPE_CUSTOM_FIELD_VALIDATION = new Scripts("type.CUSTOM_FIELD_VALIDATION");
        public static MessageKey TYPE_CUSTOM_OPERATION = new Scripts("type.CUSTOM_OPERATION");
        public static MessageKey TYPE_CUSTOM_WEB_SERVICE = new Scripts("type.CUSTOM_WEB_SERVICE");
        public static MessageKey TYPE_CUSTOM_WIZARD = new Scripts("type.CUSTOM_WIZARD");
        public static MessageKey TYPE_EXPORT_FORMAT = new Scripts("type.EXPORT_FORMAT");
        public static MessageKey TYPE_EXTENSION_POINT = new Scripts("type.EXTENSION_POINT");
        public static MessageKey TYPE_INBOUND_SMS = new Scripts("type.INBOUND_SMS");
        public static MessageKey TYPE_IP_GEOLOCATION = new Scripts("type.IP_GEOLOCATION");
        public static MessageKey TYPE_LIBRARY = new Scripts("type.LIBRARY");
        public static MessageKey TYPE_LINK_GENERATION = new Scripts("type.LINK_GENERATION");
        public static MessageKey TYPE_LOAD_CUSTOM_FIELD_VALUES = new Scripts("type.LOAD_CUSTOM_FIELD_VALUES");
        public static MessageKey TYPE_NOTIFICATION = new Scripts("type.NOTIFICATION");
        public static MessageKey TYPE_OUTBOUND_SMS = new Scripts("type.OUTBOUND_SMS");
        public static MessageKey TYPE_PASSWORD_HANDLING = new Scripts("type.PASSWORD_HANDLING");
        public static MessageKey TYPE_PHONE_NUMBER_HANDLING = new Scripts("type.PHONE_NUMBER_HANDLING");
        public static MessageKey TYPE_SCHEDULED_TASK = new Scripts("type.SCHEDULED_TASK");
        public static MessageKey TYPE_SERVICE_INTERCEPTOR = new Scripts("type.SERVICE_INTERCEPTOR");
        public static MessageKey TYPE_SESSION_HANDLING = new Scripts("type.SESSION_HANDLING");
        public static MessageKey TYPE_SMS_OPERATION = new Scripts("type.SMS_OPERATION");
        public static MessageKey TYPE_TRANSFER_FEE_CALCULATION = new Scripts("type.TRANSFER_FEE_CALCULATION");
        public static MessageKey TYPE_TRANSFER_STATUS = new Scripts("type.TRANSFER_STATUS");
        public static MessageKey USED_IN_NOT_USED = new Scripts("usedIn.notUsed");
        public static MessageKey USED_IN_TAB = new Scripts("usedIn.tab");
        public static MessageKey USED_IN_TITLE = new Scripts("usedIn.title");
        public static MessageKey USED_IN_TYPE = new Scripts("usedIn.type");
        public static MessageKey USED_IN_TYPE_ACCOUNT_FEE = new Scripts("usedIn.type.ACCOUNT_FEE");
        public static MessageKey USED_IN_TYPE_AD_FIELD = new Scripts("usedIn.type.AD_FIELD");
        public static MessageKey USED_IN_TYPE_BACKGROUND_TASK = new Scripts("usedIn.type.BACKGROUND_TASK");
        public static MessageKey USED_IN_TYPE_BANNER = new Scripts("usedIn.type.BANNER");
        public static MessageKey USED_IN_TYPE_CHANNEL_CONFIGURATION = new Scripts("usedIn.type.CHANNEL_CONFIGURATION");
        public static MessageKey USED_IN_TYPE_CONFIGURATION = new Scripts("usedIn.type.CONFIGURATION");
        public static MessageKey USED_IN_TYPE_CONTACT_FIELD = new Scripts("usedIn.type.CONTACT_FIELD");
        public static MessageKey USED_IN_TYPE_CONTACT_INFO_FIELD = new Scripts("usedIn.type.CONTACT_INFO_FIELD");
        public static MessageKey USED_IN_TYPE_DOCUMENT = new Scripts("usedIn.type.DOCUMENT");
        public static MessageKey USED_IN_TYPE_DOCUMENT_FIELD = new Scripts("usedIn.type.DOCUMENT_FIELD");
        public static MessageKey USED_IN_TYPE_EXPORT_FORMAT = new Scripts("usedIn.type.EXPORT_FORMAT");
        public static MessageKey USED_IN_TYPE_EXTENSION_POINT = new Scripts("usedIn.type.EXTENSION_POINT");
        public static MessageKey USED_IN_TYPE_MENU_ITEM = new Scripts("usedIn.type.MENU_ITEM");
        public static MessageKey USED_IN_TYPE_MOBILE_PAGE = new Scripts("usedIn.type.MOBILE_PAGE");
        public static MessageKey USED_IN_TYPE_OPERATION = new Scripts("usedIn.type.OPERATION");
        public static MessageKey USED_IN_TYPE_OPERATION_FIELD = new Scripts("usedIn.type.OPERATION_FIELD");
        public static MessageKey USED_IN_TYPE_PASSWORD_TYPE = new Scripts("usedIn.type.PASSWORD_TYPE");
        public static MessageKey USED_IN_TYPE_RECORD_FIELD = new Scripts("usedIn.type.RECORD_FIELD");
        public static MessageKey USED_IN_TYPE_SCHEDULED_TASK = new Scripts("usedIn.type.SCHEDULED_TASK");
        public static MessageKey USED_IN_TYPE_SCRIPT = new Scripts("usedIn.type.SCRIPT");
        public static MessageKey USED_IN_TYPE_SERVICE_INTERCEPTOR = new Scripts("usedIn.type.SERVICE_INTERCEPTOR");
        public static MessageKey USED_IN_TYPE_SMS_OPERATION = new Scripts("usedIn.type.SMS_OPERATION");
        public static MessageKey USED_IN_TYPE_STATIC_CONTENT = new Scripts("usedIn.type.STATIC_CONTENT");
        public static MessageKey USED_IN_TYPE_TRANSACTION_FIELD = new Scripts("usedIn.type.TRANSACTION_FIELD");
        public static MessageKey USED_IN_TYPE_TRANSFER_FEE = new Scripts("usedIn.type.TRANSFER_FEE");
        public static MessageKey USED_IN_TYPE_TRANSFER_STATUS_FLOW = new Scripts("usedIn.type.TRANSFER_STATUS_FLOW");
        public static MessageKey USED_IN_TYPE_USER_FIELD = new Scripts("usedIn.type.USER_FIELD");
        public static MessageKey USED_IN_TYPE_VOUCHER_FIELD = new Scripts("usedIn.type.VOUCHER_FIELD");
        public static MessageKey USED_IN_TYPE_VOUCHER_TEMPLATE = new Scripts("usedIn.type.VOUCHER_TEMPLATE");
        public static MessageKey USED_IN_TYPE_WEB_SERVICE = new Scripts("usedIn.type.WEB_SERVICE");
        public static MessageKey USED_IN_TYPE_WIZARD = new Scripts("usedIn.type.WIZARD");
        public static MessageKey USED_IN_TYPE_WIZARD_FIELD = new Scripts("usedIn.type.WIZARD_FIELD");
        public static MessageKey USED_IN_TYPE_WIZARD_STEP = new Scripts("usedIn.type.WIZARD_STEP");
        public static MessageKey USE_TEMPLATE = new Scripts("useTemplate");
        public static MessageKey USE_TEMPLATE_CONFIRMATION = new Scripts("useTemplate.confirmation");
        public static MessageKey USE_TEMPLATE_CONFIRMATION_TITLE = new Scripts("useTemplate.confirmation.title");
        public static MessageKey USE_TEMPLATE_TOOLTIP = new Scripts("useTemplate.tooltip");

        private Scripts(String string) {
            super((Submodule)SystemSubmodule.SCRIPTS, string);
        }
    }

    public static class ScheduledTasks
    extends MessageKeyImpl {
        public static MessageKey BACKGROUND_HEADING_DETAILS = new ScheduledTasks("background.heading.details");
        public static MessageKey BACKGROUND_HEADING_NEW = new ScheduledTasks("background.heading.new");
        public static MessageKey BACKGROUND_HEADING_TAB = new ScheduledTasks("background.heading.tab");
        public static MessageKey BACKGROUND_LOGS_HEADING_TAB = new ScheduledTasks("backgroundLogs.heading.tab");
        public static MessageKey DATE = new ScheduledTasks("date");
        public static MessageKey DAY = new ScheduledTasks("day");
        public static MessageKey DISABLED = new ScheduledTasks("disabled");
        public static MessageKey ENABLED = new ScheduledTasks("enabled");
        public static MessageKey ERROR_ALREADY_RUNNING = new ScheduledTasks("error.alreadyRunning");
        public static MessageKey ERROR_BACKGROUND_NO_SCRIPTS = new ScheduledTasks("error.background.noScripts");
        public static MessageKey ERROR_HEADING = new ScheduledTasks("error.heading");
        public static MessageKey ERROR_INTERRUPTED_ON_SHUTDOWN = new ScheduledTasks("error.interruptedOnShutdown");
        public static MessageKey ERROR_LINK = new ScheduledTasks("error.link");
        public static MessageKey ERROR_RECURRING_NO_SCRIPTS = new ScheduledTasks("error.recurring.noScripts");
        public static MessageKey HEADING_LIST = new ScheduledTasks("heading.list");
        public static MessageKey HOUR = new ScheduledTasks("hour");
        public static MessageKey LAST_STATUS = new ScheduledTasks("lastStatus");
        public static MessageKey NEXT_EXECUTION = new ScheduledTasks("nextExecution");
        public static MessageKey PRIORITY = new ScheduledTasks("priority");
        public static MessageKey PRIORITY_HIGH = new ScheduledTasks("priority.HIGH");
        public static MessageKey PRIORITY_LOW = new ScheduledTasks("priority.LOW");
        public static MessageKey PRIORITY_NORMAL = new ScheduledTasks("priority.NORMAL");
        public static MessageKey PURGE_LOGS_DAYS = new ScheduledTasks("purgeLogsDays");
        public static MessageKey RECURRENCE = new ScheduledTasks("recurrence");
        public static MessageKey RECURRING_HEADING_DETAILS = new ScheduledTasks("recurring.heading.details");
        public static MessageKey RECURRING_HEADING_NEW = new ScheduledTasks("recurring.heading.new");
        public static MessageKey RECURRING_HEADING_TAB = new ScheduledTasks("recurring.heading.tab");
        public static MessageKey RESULT = new ScheduledTasks("result");
        public static MessageKey RUN_NOW = new ScheduledTasks("runNow");
        public static MessageKey RUN_NOW_CONFIRM = new ScheduledTasks("runNow.confirm");
        public static MessageKey RUN_NOW_DONE = new ScheduledTasks("runNow.done");
        public static MessageKey SCRIPT = new ScheduledTasks("script");
        public static MessageKey SCRIPT_PARAMETERS = new ScheduledTasks("scriptParameters");
        public static MessageKey STATUS = new ScheduledTasks("status");
        public static MessageKey STATUS_ERROR = new ScheduledTasks("status.ERROR");
        public static MessageKey STATUS_NEVER_RAN = new ScheduledTasks("status.NEVER_RAN");
        public static MessageKey STATUS_RUNNING = new ScheduledTasks("status.RUNNING");
        public static MessageKey STATUS_SUCCESS = new ScheduledTasks("status.SUCCESS");
        public static MessageKey TAB_LOG = new ScheduledTasks("tab.log");
        public static MessageKey TIME_TAKEN = new ScheduledTasks("timeTaken");
        public static MessageKey VERBOSE_LOG = new ScheduledTasks("verboseLog");
        public static MessageKey VERBOSE_LOG_INFO = new ScheduledTasks("verboseLog.info");

        private ScheduledTasks(String string) {
            super((Submodule)SystemSubmodule.SCHEDULED_TASKS, string);
        }
    }

    public static class Reports
    extends MessageKeyImpl {
        public static MessageKey GROUPS = new Reports("groups");
        public static MessageKey GROUPS_REQUIRED = new Reports("groupsRequired");
        public static MessageKey PERIOD = new Reports("period");
        public static MessageKey SYSTEM_AD_INFORMATION = new Reports("system.adInformation");
        public static MessageKey SYSTEM_AD_INFORMATION_ACTIVE = new Reports("system.adInformation.ACTIVE");
        public static MessageKey SYSTEM_AD_INFORMATION_ACTIVE_USERS_WITH_ADS = new Reports("system.adInformation.activeUsersWithAds");
        public static MessageKey SYSTEM_AD_INFORMATION_DISABLED = new Reports("system.adInformation.DISABLED");
        public static MessageKey SYSTEM_AD_INFORMATION_DRAFT = new Reports("system.adInformation.DRAFT");
        public static MessageKey SYSTEM_AD_INFORMATION_EXPIRED = new Reports("system.adInformation.EXPIRED");
        public static MessageKey SYSTEM_AD_INFORMATION_HIDDEN = new Reports("system.adInformation.HIDDEN");
        public static MessageKey SYSTEM_AD_INFORMATION_PENDING = new Reports("system.adInformation.PENDING");
        public static MessageKey SYSTEM_AD_INFORMATION_SCHEDULED = new Reports("system.adInformation.SCHEDULED");
        public static MessageKey SYSTEM_BUTTONS_OVERWRITE = new Reports("system.buttons.overwrite");
        public static MessageKey SYSTEM_BUTTONS_OVERWRITE_CONFIRM = new Reports("system.buttons.overwriteConfirm");
        public static MessageKey SYSTEM_BUTTONS_REMOVE = new Reports("system.buttons.remove");
        public static MessageKey SYSTEM_BUTTONS_REMOVE_CONFIRM = new Reports("system.buttons.removeConfirm");
        public static MessageKey SYSTEM_BUTTONS_SAVE = new Reports("system.buttons.save");
        public static MessageKey SYSTEM_BUTTONS_SAVE_AS = new Reports("system.buttons.saveAs");
        public static MessageKey SYSTEM_CURRENCY = new Reports("system.currency");
        public static MessageKey SYSTEM_ERROR_MULTIPLE_REPORTS_NOT_ALLOWED = new Reports("system.error.multipleReportsNotAllowed");
        public static MessageKey SYSTEM_EXPENDITURE = new Reports("system.expenditure");
        public static MessageKey SYSTEM_FILTERS = new Reports("system.filters");
        public static MessageKey SYSTEM_FILTERS_CURRENCY_RESULT = new Reports("system.filters.currencyResult");
        public static MessageKey SYSTEM_FILTERS_INFORMATION = new Reports("system.filters.information");
        public static MessageKey SYSTEM_FILTERS_NOT_FULLY_APPLIED = new Reports("system.filters.notFullyApplied");
        public static MessageKey SYSTEM_FILTERS_NO_TRANSFER_TYPES = new Reports("system.filters.noTransferTypes");
        public static MessageKey SYSTEM_FILTERS_PREFERENCE_NAME = new Reports("system.filters.preferenceName");
        public static MessageKey SYSTEM_FILTERS_SAVED_PREFERENCES = new Reports("system.filters.savedPreferences");
        public static MessageKey SYSTEM_FILTERS_SAVE_PREFERENCE_TITLE = new Reports("system.filters.savePreferenceTitle");
        public static MessageKey SYSTEM_FILTERS_SUCCESFULLY_REMOVED = new Reports("system.filters.succesfullyRemoved");
        public static MessageKey SYSTEM_FILTERS_SUCCESSFULLY_SAVED = new Reports("system.filters.successfullySaved");
        public static MessageKey SYSTEM_FILTERS_TRANSFER_TYPE_RESULT = new Reports("system.filters.transferTypeResult");
        public static MessageKey SYSTEM_FILTERS_USE_PREFERENCES = new Reports("system.filters.usePreferences");
        public static MessageKey SYSTEM_HEADING = new Reports("system.heading");
        public static MessageKey SYSTEM_INCOME = new Reports("system.income");
        public static MessageKey SYSTEM_NUMBER_LOGINS = new Reports("system.numberLogins");
        public static MessageKey SYSTEM_NUMBER_OF_ENABLED_USERS = new Reports("system.numberOfEnabledUsers");
        public static MessageKey SYSTEM_NUMBER_OF_REMOVED_USERS = new Reports("system.numberOfRemovedUsers");
        public static MessageKey SYSTEM_NUMBER_OF_USERS = new Reports("system.numberOfUsers");
        public static MessageKey SYSTEM_NUMBER_OF_USERS_OVER_PERIOD = new Reports("system.numberOfUsersOverPeriod");
        public static MessageKey SYSTEM_PERCENTAGE_NO_TRADE = new Reports("system.percentageNoTrade");
        public static MessageKey SYSTEM_PERIOD_BEGIN = new Reports("system.period.begin");
        public static MessageKey SYSTEM_PERIOD_END = new Reports("system.period.end");
        public static MessageKey SYSTEM_PERIOD_NAME = new Reports("system.period.name");
        public static MessageKey SYSTEM_PERIOD_RESULTS_GROSS_EXPENDITURE = new Reports("system.periodResults.grossExpenditure");
        public static MessageKey SYSTEM_PERIOD_RESULTS_GROSS_INCOME = new Reports("system.periodResults.grossIncome");
        public static MessageKey SYSTEM_PERIOD_RESULTS_NUMBER_INCOMING = new Reports("system.periodResults.numberIncoming");
        public static MessageKey SYSTEM_PERIOD_RESULTS_NUMBER_OUTGOING = new Reports("system.periodResults.numberOutgoing");
        public static MessageKey SYSTEM_PERIOD_SPECIFY_OTHER = new Reports("system.period.specifyOther");
        public static MessageKey SYSTEM_REFERENCES = new Reports("system.references");
        public static MessageKey SYSTEM_REFERENCES_TOTAL = new Reports("system.references.total");
        public static MessageKey SYSTEM_RESULTS = new Reports("system.results");
        public static MessageKey SYSTEM_SUB_HEADING = new Reports("system.subHeading");
        public static MessageKey SYSTEM_SYSTEM_ACCOUNTS = new Reports("system.systemAccounts");
        public static MessageKey SYSTEM_SYSTEM_ACCOUNT_BALANCE = new Reports("system.systemAccountBalance");
        public static MessageKey SYSTEM_TRANSFER_TYPES = new Reports("system.transferTypes");
        public static MessageKey SYSTEM_USER_ACCOUNTS = new Reports("system.userAccounts");
        public static MessageKey SYSTEM_USER_ACCOUNT_BALANCE = new Reports("system.userAccountBalance");
        public static MessageKey SYSTEM_USER_GROUP_INFORMATION = new Reports("system.userGroupInformation");
        public static MessageKey USER_DETAILS_LEVEL_SUMMARY = new Reports("user.detailsLevel.SUMMARY");
        public static MessageKey USER_DETAILS_LEVEL_SUMMARY_TRANSACTIONS = new Reports("user.detailsLevel.SUMMARY_TRANSACTIONS");
        public static MessageKey USER_TYPE_ACCOUNTS = new Reports("user.type.ACCOUNTS");
        public static MessageKey USER_TYPE_ADS = new Reports("user.type.ADS");
        public static MessageKey USER_TYPE_INVOICES = new Reports("user.type.INVOICES");
        public static MessageKey USER_TYPE_REFERENCES = new Reports("user.type.REFERENCES");
        public static MessageKey USER_TYPE_TRANSACTIONS = new Reports("user.type.TRANSACTIONS");
        public static MessageKey USER_TYPE_TRANSFER_FEEDBACKS = new Reports("user.type.TRANSFER_FEEDBACKS");
        public static MessageKey USER_TYPE_USER = new Reports("user.type.USER");

        private Reports(String string) {
            super((Submodule)SystemSubmodule.REPORTS, string);
        }
    }

    public static class Profiling
    extends MessageKeyImpl {
        public static MessageKey COMMENTS = new Profiling("comments");
        public static MessageKey COMMON_OPERATIONS = new Profiling("commonOperations");
        public static MessageKey CUSTOM_WEB_SERVICES = new Profiling("customWebServices");
        public static MessageKey DISCARDED_COUNT = new Profiling("discardedCount");
        public static MessageKey DOWNLOAD = new Profiling("download");
        public static MessageKey DURATION = new Profiling("duration");
        public static MessageKey END_DATE = new Profiling("endDate");
        public static MessageKey ENTRY_COUNT = new Profiling("entryCount");
        public static MessageKey ERROR_NO_ENTRY_POINTS = new Profiling("error.noEntryPoints");
        public static MessageKey HEADING = new Profiling("heading");
        public static MessageKey INCLUDE_BUILT_IN_TASKS = new Profiling("includeBuiltInTasks");
        public static MessageKey INCLUDE_CACHEABLE_QUERIES = new Profiling("includeCacheableQueries");
        public static MessageKey INCLUDE_LOW_LEVEL_QUERIES = new Profiling("includeLowLevelQueries");
        public static MessageKey INCLUDE_SCRIPT_CODE = new Profiling("includeScriptCode");
        public static MessageKey INCLUDE_SCRIPT_CODE_INFO = new Profiling("includeScriptCode.info");
        public static MessageKey INCLUDE_SERVICES_SKIPPED_FROM_LOG = new Profiling("includeServicesSkippedFromLog");
        public static MessageKey INFO_FINISHED = new Profiling("info.finished");
        public static MessageKey INFO_STARTED = new Profiling("info.started");
        public static MessageKey INFO_STOPPED = new Profiling("info.stopped");
        public static MessageKey LOW_LEVEL_QUERIES = new Profiling("lowLevelQueries");
        public static MessageKey NAME_TEMPLATE = new Profiling("nameTemplate");
        public static MessageKey OPERATIONS_TO_INCLUDE = new Profiling("operationsToInclude");
        public static MessageKey OPERATIONS_TO_INCLUDE_ALL = new Profiling("operationsToInclude.all");
        public static MessageKey REMOVE_ALL = new Profiling("removeAll");
        public static MessageKey SCHEDULED_TASKS = new Profiling("scheduledTasks");
        public static MessageKey SECTION_ENTRY_POINTS = new Profiling("section.entryPoints");
        public static MessageKey SECTION_OPTIONS = new Profiling("section.options");
        public static MessageKey SERVICES = new Profiling("services");
        public static MessageKey SERVICES_TO_INCLUDE = new Profiling("servicesToInclude");
        public static MessageKey SERVICES_TO_INCLUDE_ALL = new Profiling("servicesToInclude.all");
        public static MessageKey SKIP_READ_ONLY_TRANSACTIONS = new Profiling("skipReadOnlyTransactions");
        public static MessageKey START = new Profiling("start");
        public static MessageKey START_DATE = new Profiling("startDate");
        public static MessageKey STOP = new Profiling("stop");
        public static MessageKey TAB_DEFAULT = new Profiling("tab.default");
        public static MessageKey TAB_HISTORY = new Profiling("tab.history");
        public static MessageKey WITH_SCRIPTS_ONLY = new Profiling("withScriptsOnly");

        private Profiling(String string) {
            super((Submodule)SystemSubmodule.PROFILING, string);
        }
    }

    public static class OperationFields
    extends MessageKeyImpl {
        public static MessageKey OWNER_OPERATION = new OperationFields("ownerOperation");
        public static MessageKey READONLY_IN_FORM = new OperationFields("readonlyInForm");

        private OperationFields(String string) {
            super((Submodule)SystemSubmodule.OPERATION_FIELDS, string);
        }
    }

    public static class Operations
    extends MessageKeyImpl {
        public static MessageKey ACTIONS_ACTION_OPERATION = new Operations("actions.actionOperation");
        public static MessageKey ACTIONS_ERROR_INVALID_PARAMETERS = new Operations("actions.error.invalidParameters");
        public static MessageKey ACTIONS_HEADING_DETAILS = new Operations("actions.heading.details");
        public static MessageKey ACTIONS_HEADING_NEW = new Operations("actions.heading.new");
        public static MessageKey ACTIONS_LABEL = new Operations("actions.label");
        public static MessageKey ACTIONS_NAME = new Operations("actions.name");
        public static MessageKey ACTIONS_OWNER_OPERATION = new Operations("actions.ownerOperation");
        public static MessageKey ACTIONS_PARAMETERS = new Operations("actions.parameters");
        public static MessageKey ACTIONS_PARAMETER_SCRIPT_DEFINED = new Operations("actions.parameter.scriptDefined");
        public static MessageKey ACTIONS_PRIMARY = new Operations("actions.primary");
        public static MessageKey ACTIONS_VISIBILITY = new Operations("actions.visibility");
        public static MessageKey ACTIONS_VISIBILITY_AFTER_RUN = new Operations("actions.visibility.AFTER_RUN");
        public static MessageKey ACTIONS_VISIBILITY_BEFORE_RUN = new Operations("actions.visibility.BEFORE_RUN");
        public static MessageKey ACTIONS_VISIBILITY_BOTH = new Operations("actions.visibility.BOTH");
        public static MessageKey ADMIN_MENU = new Operations("adminMenu");
        public static MessageKey ALLOW_EXPORT = new Operations("allowExport");
        public static MessageKey ALLOW_PRINT = new Operations("allowPrint");
        public static MessageKey ALREADY_EXECUTED = new Operations("alreadyExecuted");
        public static MessageKey CHANNELS = new Operations("channels");
        public static MessageKey CLOSE_AFTER_SECONDS = new Operations("closeAfterSeconds");
        public static MessageKey CONFIRMATION_TEXT = new Operations("confirmationText");
        public static MessageKey CURRENCY_COLUMN = new Operations("currencyColumn");
        public static MessageKey CUSTOM_SUBMIT_LABEL = new Operations("customSubmitLabel");
        public static MessageKey ENABLED_FOR_ACTIVE_USERS = new Operations("enabledForActiveUsers");
        public static MessageKey ENABLED_FOR_PENDING_USERS = new Operations("enabledForPendingUsers");
        public static MessageKey ERROR_ACTIONS_NOT_SUPPORTED = new Operations("error.actionsNotSupported");
        public static MessageKey ERROR_NO_SCRIPTS = new Operations("error.noScripts");
        public static MessageKey ERROR_SCRIPT_NOT_EXTERNAL_REDIRECT = new Operations("error.scriptNotExternalRedirect");
        public static MessageKey FILE_DOWNLOAD_STARTED = new Operations("fileDownloadStarted");
        public static MessageKey FILE_UPLOAD = new Operations("fileUpload");
        public static MessageKey FRONTEND_MENU = new Operations("frontendMenu");
        public static MessageKey HAS_FILE_UPLOAD = new Operations("hasFileUpload");
        public static MessageKey HEADING_DETAILS = new Operations("heading.details");
        public static MessageKey HEADING_LIST = new Operations("heading.list");
        public static MessageKey HEADING_NEW = new Operations("heading.new");
        public static MessageKey INFORMATION_TEXT = new Operations("informationText");
        public static MessageKey LABEL = new Operations("label");
        public static MessageKey MOBILE_ICON = new Operations("mobileIcon");
        public static MessageKey NO_ACTIONS = new Operations("noActions");
        public static MessageKey OPEN_DETAIL_IN_NEW_WINDOW = new Operations("openDetailInNewWindow");
        public static MessageKey PREVIEW_RECEIPT = new Operations("previewReceipt");
        public static MessageKey PREVIEW_RECEIPT_CHARS_PER_LINE = new Operations("previewReceipt.charsPerLine");
        public static MessageKey PREVIEW_RECEIPT_RANGE = new Operations("previewReceipt.range");
        public static MessageKey PROFILE_SECTION = new Operations("profileSection");
        public static MessageKey RECORD_TYPES = new Operations("recordTypes");
        public static MessageKey REQUIRE_CONFIRMATION_CREDENTIAL = new Operations("requireConfirmationCredential");
        public static MessageKey RESULT_INFORMATION_TEXT = new Operations("resultInformationText");
        public static MessageKey RESULT_TYPE = new Operations("resultType");
        public static MessageKey RESULT_TYPE_BULK_ACTION = new Operations("resultType.BULK_ACTION");
        public static MessageKey RESULT_TYPE_EXTERNAL_REDIRECT = new Operations("resultType.EXTERNAL_REDIRECT");
        public static MessageKey RESULT_TYPE_FILE_DOWNLOAD = new Operations("resultType.FILE_DOWNLOAD");
        public static MessageKey RESULT_TYPE_NOTIFICATION = new Operations("resultType.NOTIFICATION");
        public static MessageKey RESULT_TYPE_PLAIN_TEXT = new Operations("resultType.PLAIN_TEXT");
        public static MessageKey RESULT_TYPE_RESULT_PAGE = new Operations("resultType.RESULT_PAGE");
        public static MessageKey RESULT_TYPE_RICH_TEXT = new Operations("resultType.RICH_TEXT");
        public static MessageKey RESULT_TYPE_URL = new Operations("resultType.URL");
        public static MessageKey ROW_ACTION = new Operations("rowAction");
        public static MessageKey ROW_ACTION_LOCATION = new Operations("rowAction.LOCATION");
        public static MessageKey ROW_ACTION_NONE = new Operations("rowAction.NONE");
        public static MessageKey ROW_ACTION_OPERATION = new Operations("rowAction.OPERATION");
        public static MessageKey ROW_ACTION_URL = new Operations("rowAction.URL");
        public static MessageKey ROW_LOCATION = new Operations("rowLocation");
        public static MessageKey ROW_OPERATION = new Operations("rowOperation");
        public static MessageKey ROW_PARAMETERS = new Operations("rowParameters");
        public static MessageKey ROW_URL = new Operations("rowUrl");
        public static MessageKey SCANNED_QR_CODE = new Operations("scannedQrCode");
        public static MessageKey SCOPE = new Operations("scope");
        public static MessageKey SCOPE_ADVERTISEMENT = new Operations("scope.ADVERTISEMENT");
        public static MessageKey SCOPE_BULK_ACTION = new Operations("scope.BULK_ACTION");
        public static MessageKey SCOPE_CONTACT = new Operations("scope.CONTACT");
        public static MessageKey SCOPE_CONTACT_INFO = new Operations("scope.CONTACT_INFO");
        public static MessageKey SCOPE_INTERNAL = new Operations("scope.INTERNAL");
        public static MessageKey SCOPE_MENU = new Operations("scope.MENU");
        public static MessageKey SCOPE_RECORD = new Operations("scope.RECORD");
        public static MessageKey SCOPE_SYSTEM = new Operations("scope.SYSTEM");
        public static MessageKey SCOPE_TRANSFER = new Operations("scope.TRANSFER");
        public static MessageKey SCOPE_USER = new Operations("scope.USER");
        public static MessageKey SCRIPT = new Operations("script");
        public static MessageKey SCRIPT_PARAMETERS = new Operations("scriptParameters");
        public static MessageKey SEARCH_AUTOMATICALLY = new Operations("searchAutomatically");
        public static MessageKey SHOW_FORM = new Operations("showForm");
        public static MessageKey SHOW_FORM_ALWAYS = new Operations("showForm.ALWAYS");
        public static MessageKey SHOW_FORM_MISSING_ANY = new Operations("showForm.MISSING_ANY");
        public static MessageKey SHOW_FORM_MISSING_REQUIRED = new Operations("showForm.MISSING_REQUIRED");
        public static MessageKey SUBMIT_WITH_QR_CODE_SCAN = new Operations("submitWithQrCodeScan");
        public static MessageKey SUBMIT_WITH_QR_CODE_SCAN_INVALID_FOR_RESULT_TYPE = new Operations("submitWithQrCodeScan.invalidForResultType");
        public static MessageKey TAB_ACTIONS = new Operations("tab.actions");
        public static MessageKey TAB_FIELDS = new Operations("tab.fields");
        public static MessageKey TRANSFER_TYPES = new Operations("transferTypes");
        public static MessageKey USER_MENU = new Operations("userMenu");

        private Operations(String string) {
            super((Submodule)SystemSubmodule.OPERATIONS, string);
        }
    }

    public static class Networks
    extends MessageKeyImpl {
        public static MessageKey CREATION_DATE = new Networks("creationDate");
        public static MessageKey DEFAULT_NETWORK = new Networks("defaultNetwork");
        public static MessageKey DEFAULT_ONLY = new Networks("defaultOnly");
        public static MessageKey DEFAULT_URL = new Networks("defaultUrl");
        public static MessageKey DISABLE_SERVICE_INTERCEPTORS = new Networks("disableServiceInterceptors");
        public static MessageKey DISABLE_SERVICE_INTERCEPTORS_CONFIRM = new Networks("disableServiceInterceptors.confirm");
        public static MessageKey DISABLE_SERVICE_INTERCEPTORS_DONE = new Networks("disableServiceInterceptors.done");
        public static MessageKey EMPTY = new Networks("empty");
        public static MessageKey ENABLED = new Networks("enabled");
        public static MessageKey ERROR_CANNOT_DISABLE_DEFAULT = new Networks("error.cannotDisableDefault");
        public static MessageKey ERROR_MAXIMUM_MANAGED_NETWORKS = new Networks("error.maximumManagedNetworks");
        public static MessageKey HEADING_DETAILS = new Networks("heading.details");
        public static MessageKey HEADING_LIST = new Networks("heading.list");
        public static MessageKey HEADING_NEW = new Networks("heading.new");
        public static MessageKey MANAGED_BY_GROUP = new Networks("managedByGroup");
        public static MessageKey MANAGED_BY_GROUPS = new Networks("managedByGroups");
        public static MessageKey ORDER_BY_DATE = new Networks("orderBy.DATE");
        public static MessageKey ORDER_BY_NAME = new Networks("orderBy.NAME");
        public static MessageKey PARENT_CONFIGURATION = new Networks("parentConfiguration");
        public static MessageKey SWITCH = new Networks("switch");
        public static MessageKey SWITCH_TO_THIS_NETWORK = new Networks("switchToThisNetwork");
        public static MessageKey WIZARD = new Networks("wizard");
        public static MessageKey WIZARD_ADMINISTRATOR = new Networks("wizard.administrator");
        public static MessageKey WIZARD_ADMINISTRATOR_INFORMATION = new Networks("wizard.administrator.information");
        public static MessageKey WIZARD_ADVERTISEMENTS = new Networks("wizard.advertisements");
        public static MessageKey WIZARD_ADVERTISEMENTS_INFORMATION = new Networks("wizard.advertisements.information");
        public static MessageKey WIZARD_AFTER_SETUP = new Networks("wizard.afterSetup");
        public static MessageKey WIZARD_BROKERS = new Networks("wizard.brokers");
        public static MessageKey WIZARD_BROKERS_INFORMATION = new Networks("wizard.brokers.information");
        public static MessageKey WIZARD_CURRENCY = new Networks("wizard.currency");
        public static MessageKey WIZARD_CURRENCY_INFORMATION = new Networks("wizard.currency.information");
        public static MessageKey WIZARD_LOCALIZATION = new Networks("wizard.localization");
        public static MessageKey WIZARD_LOCALIZATION_INFORMATION = new Networks("wizard.localization.information");
        public static MessageKey WIZARD_MESSAGE_CATEGORIES = new Networks("wizard.messageCategories");
        public static MessageKey WIZARD_MESSAGE_CATEGORIES_INFORMATION = new Networks("wizard.messageCategories.information");
        public static MessageKey WIZARD_NETWORK = new Networks("wizard.network");
        public static MessageKey WIZARD_NETWORK_INFORMATION = new Networks("wizard.network.information");
        public static MessageKey WIZARD_PROFILE_FIELDS = new Networks("wizard.profileFields");
        public static MessageKey WIZARD_PROFILE_FIELDS_INFORMATION = new Networks("wizard.profileFields.information");
        public static MessageKey WIZARD_RECORDS = new Networks("wizard.records");
        public static MessageKey WIZARD_RECORDS_INFORMATION = new Networks("wizard.records.information");
        public static MessageKey WIZARD_REFERENCES = new Networks("wizard.references");
        public static MessageKey WIZARD_REFERENCES_INFORMATION = new Networks("wizard.references.information");
        public static MessageKey WIZARD_SYSTEM_ACCOUNTS = new Networks("wizard.systemAccounts");
        public static MessageKey WIZARD_SYSTEM_ACCOUNTS_INFORMATION = new Networks("wizard.systemAccounts.information");
        public static MessageKey WIZARD_USER_ACCOUNT = new Networks("wizard.userAccount");
        public static MessageKey WIZARD_USER_ACCOUNT_INFORMATION = new Networks("wizard.userAccount.information");

        private Networks(String string) {
            super((Submodule)SystemSubmodule.NETWORKS, string);
        }
    }

    public static class Licensing
    extends MessageKeyImpl {
        public static MessageKey ACTIVATION_DATE = new Licensing("activationDate");
        public static MessageKey CURRENT_USERS = new Licensing("currentUsers");
        public static MessageKey CYCLOS_COMMIT_ID = new Licensing("cyclosCommitId");
        public static MessageKey CYCLOS_VERSION = new Licensing("cyclosVersion");
        public static MessageKey ERROR_LAST_ONLINE_UPDATE_TOO_OLD = new Licensing("error.lastOnlineUpdateTooOld");
        public static MessageKey ERROR_LICENSE_EXPIRED = new Licensing("error.licenseExpired");
        public static MessageKey ERROR_MAX_OPEN_VOUCHERS_REACHED = new Licensing("error.maxOpenVouchersReached");
        public static MessageKey ERROR_MAX_USERS_REACHED = new Licensing("error.maxUsersReached");
        public static MessageKey EXPIRATION_DATE = new Licensing("expirationDate");
        public static MessageKey EXPIRATION_DATE_UNLIMITED = new Licensing("expirationDate.unlimited");
        public static MessageKey HEADING = new Licensing("heading");
        public static MessageKey LAST_UPDATE = new Licensing("lastUpdate");
        public static MessageKey LICENSE_KEY = new Licensing("licenseKey");
        public static MessageKey MAX_USERS = new Licensing("maxUsers");
        public static MessageKey MAX_USERS_UNLIMITED = new Licensing("maxUsers.unlimited");
        public static MessageKey OFFLINE_UPDATE = new Licensing("offlineUpdate");
        public static MessageKey ONLINE_UPDATE = new Licensing("onlineUpdate");
        public static MessageKey ORGANIZATION_NAME = new Licensing("organizationName");
        public static MessageKey TYPE = new Licensing("type");
        public static MessageKey UPDATED = new Licensing("updated");

        private Licensing(String string) {
            super((Submodule)SystemSubmodule.LICENSING, string);
        }
    }

    public static class Languages
    extends MessageKeyImpl {
        public static MessageKey DATE_FORMAT_DMY_DASH = new Languages("dateFormat.DMY_DASH");
        public static MessageKey DATE_FORMAT_DMY_PERIOD = new Languages("dateFormat.DMY_PERIOD");
        public static MessageKey DATE_FORMAT_DMY_SLASH = new Languages("dateFormat.DMY_SLASH");
        public static MessageKey DATE_FORMAT_MDY_DASH = new Languages("dateFormat.MDY_DASH");
        public static MessageKey DATE_FORMAT_MDY_PERIOD = new Languages("dateFormat.MDY_PERIOD");
        public static MessageKey DATE_FORMAT_MDY_SLASH = new Languages("dateFormat.MDY_SLASH");
        public static MessageKey DATE_FORMAT_YMD_DASH = new Languages("dateFormat.YMD_DASH");
        public static MessageKey DATE_FORMAT_YMD_PERIOD = new Languages("dateFormat.YMD_PERIOD");
        public static MessageKey DATE_FORMAT_YMD_SLASH = new Languages("dateFormat.YMD_SLASH");
        public static MessageKey DISTANCE_UNIT_KILOMETER = new Languages("distanceUnit.KILOMETER");
        public static MessageKey DISTANCE_UNIT_MILE = new Languages("distanceUnit.MILE");
        public static MessageKey ERROR_MAX_LEVELS = new Languages("error.maxLevels");
        public static MessageKey HEADING_DETAILS = new Languages("heading.details");
        public static MessageKey HEADING_LIST = new Languages("heading.list");
        public static MessageKey HEADING_NEW = new Languages("heading.new");
        public static MessageKey LIST_SEPARATOR_COLON = new Languages("listSeparator.COLON");
        public static MessageKey LIST_SEPARATOR_COMMA = new Languages("listSeparator.COMMA");
        public static MessageKey LIST_SEPARATOR_PIPE = new Languages("listSeparator.PIPE");
        public static MessageKey LIST_SEPARATOR_SEMI_COLON = new Languages("listSeparator.SEMI_COLON");
        public static MessageKey NUMBER_FORMAT_COMMA_AS_DECIMAL = new Languages("numberFormat.COMMA_AS_DECIMAL");
        public static MessageKey NUMBER_FORMAT_PERIOD_AS_DECIMAL = new Languages("numberFormat.PERIOD_AS_DECIMAL");
        public static MessageKey PARENT = new Languages("parent");
        public static MessageKey TEMPLATE = new Languages("template");
        public static MessageKey TIME_FORMAT_H_12 = new Languages("timeFormat.H12");
        public static MessageKey TIME_FORMAT_H_24 = new Languages("timeFormat.H24");

        private Languages(String string) {
            super((Submodule)SystemSubmodule.LANGUAGES, string);
        }
    }

    public static class IpAddresses
    extends MessageKeyImpl {
        public static MessageKey ADDRESS = new IpAddresses("address");
        public static MessageKey BLOCKED_UNTIL = new IpAddresses("blockedUntil");
        public static MessageKey BLOCKED_UNTIL_TIME = new IpAddresses("blockedUntilTime");
        public static MessageKey BLOCK_TIME = new IpAddresses("blockTime");
        public static MessageKey BY = new IpAddresses("by");
        public static MessageKey COMMENT = new IpAddresses("comment");
        public static MessageKey DATE = new IpAddresses("date");
        public static MessageKey ERRORS_CANNOT_DENY_OWN_ADDRESS = new IpAddresses("errors.cannotDenyOwnAddress");
        public static MessageKey GEOLOCATION = new IpAddresses("geolocation");
        public static MessageKey HEADING_DETAILS = new IpAddresses("heading.details");
        public static MessageKey HEADING_NEW = new IpAddresses("heading.new");
        public static MessageKey HEADING_SEARCH = new IpAddresses("heading.search");
        public static MessageKey INFO_TEXT = new IpAddresses("infoText");
        public static MessageKey LOGS = new IpAddresses("logs");
        public static MessageKey STATUS = new IpAddresses("status");
        public static MessageKey STATUS_ALLOWED = new IpAddresses("status.ALLOWED");
        public static MessageKey STATUS_BLOCKED = new IpAddresses("status.BLOCKED");
        public static MessageKey STATUS_DENIED = new IpAddresses("status.DENIED");
        public static MessageKey STATUS_RESTORED = new IpAddresses("status.RESTORED");
        public static MessageKey UNBLOCK = new IpAddresses("unblock");
        public static MessageKey UNBLOCK_DONE = new IpAddresses("unblock.done");

        private IpAddresses(String string) {
            super((Submodule)SystemSubmodule.IP_ADDRESSES, string);
        }
    }

    public static class Images
    extends MessageKeyImpl {
        public static MessageKey CATEGORY = new Images("category");
        public static MessageKey CONTENT = new Images("content");
        public static MessageKey COPY_URL = new Images("copyUrl");
        public static MessageKey CREATION_DATE = new Images("creationDate");
        public static MessageKey DEFAULT_CATEGORY_NAME = new Images("defaultCategory.name");
        public static MessageKey DIMENSIONS = new Images("dimensions");
        public static MessageKey ERROR_CANNOT_REMOVE_PROFILE_IMAGE = new Images("error.cannotRemoveProfileImage");
        public static MessageKey HEADING_CONFIGURATION_IMAGES = new Images("heading.configurationImages");
        public static MessageKey HEADING_CUSTOM_SVG_DETAILS = new Images("heading.customSvg.details");
        public static MessageKey HEADING_CUSTOM_SVG_LIST = new Images("heading.customSvg.list");
        public static MessageKey HEADING_CUSTOM_SVG_NEW = new Images("heading.customSvg.new");
        public static MessageKey HEADING_LIST = new Images("heading.list");
        public static MessageKey INVALID_CONTENT = new Images("invalidContent");
        public static MessageKey LENGTH = new Images("length");

        private Images(String string) {
            super((Submodule)SystemSubmodule.IMAGES, string);
        }
    }

    public static class Fields
    extends MessageKeyImpl {
        public static MessageKey ALLOWED_MIME_TYPES = new Fields("allowedMimeTypes");
        public static MessageKey ALL_SELECTED_LABEL = new Fields("allSelectedLabel");
        public static MessageKey CONTROL = new Fields("control");
        public static MessageKey CONTROL_CHECKBOX = new Fields("control.CHECKBOX");
        public static MessageKey CONTROL_ENTITY_SELECTION = new Fields("control.ENTITY_SELECTION");
        public static MessageKey CONTROL_MULTI_SELECTION = new Fields("control.MULTI_SELECTION");
        public static MessageKey CONTROL_RADIO = new Fields("control.RADIO");
        public static MessageKey CONTROL_RICH_EDITOR = new Fields("control.RICH_EDITOR");
        public static MessageKey CONTROL_SINGLE_SELECTION = new Fields("control.SINGLE_SELECTION");
        public static MessageKey CONTROL_TEXT = new Fields("control.TEXT");
        public static MessageKey CONTROL_TEXTAREA = new Fields("control.TEXTAREA");
        public static MessageKey CONTROL_UPLOAD = new Fields("control.UPLOAD");
        public static MessageKey DECIMAL_DIGITS = new Fields("decimalDigits");
        public static MessageKey DEFAULT_DATE_TODAY = new Fields("defaultDateToday");
        public static MessageKey DEFAULT_VALUE = new Fields("defaultValue");
        public static MessageKey DOCUMENT = new Fields("document");
        public static MessageKey EXACT_MATCH = new Fields("exactMatch");
        public static MessageKey EXPANDED_CATEGORIES = new Fields("expandedCategories");
        public static MessageKey HEADING_DETAILS = new Fields("heading.details");
        public static MessageKey HEADING_DETAILS_POSSIBLE_VALUE = new Fields("heading.details.possibleValue");
        public static MessageKey HEADING_DETAILS_POSSIBLE_VALUE_CATEGORY = new Fields("heading.details.possibleValueCategory");
        public static MessageKey HEADING_LIST = new Fields("heading.list");
        public static MessageKey HEADING_NEW = new Fields("heading.new");
        public static MessageKey HEADING_NEW_POSSIBLE_VALUE = new Fields("heading.new.possibleValue");
        public static MessageKey HEADING_NEW_POSSIBLE_VALUE_CATEGORY = new Fields("heading.new.possibleValueCategory");
        public static MessageKey IGNORE_SANITIZER = new Fields("ignoreSanitizer");
        public static MessageKey INFORMATION_TEXT = new Fields("informationText");
        public static MessageKey INTERNAL_NAME_WARNING = new Fields("internalNameWarning");
        public static MessageKey LENGTH_CONSTRAINT = new Fields("lengthConstraint");
        public static MessageKey LINKED_ENTITY_RECORD_TYPE = new Fields("linkedEntity.recordType");
        public static MessageKey LINKED_ENTITY_TYPE = new Fields("linkedEntityType");
        public static MessageKey LINKED_ENTITY_TYPE_ADVERTISEMENT = new Fields("linkedEntityType.ADVERTISEMENT");
        public static MessageKey LINKED_ENTITY_TYPE_RECORD = new Fields("linkedEntityType.RECORD");
        public static MessageKey LINKED_ENTITY_TYPE_TRANSACTION = new Fields("linkedEntityType.TRANSACTION");
        public static MessageKey LINKED_ENTITY_TYPE_TRANSFER = new Fields("linkedEntityType.TRANSFER");
        public static MessageKey LINKED_ENTITY_TYPE_USER = new Fields("linkedEntityType.USER");
        public static MessageKey LOAD_VALUES_SCRIPT = new Fields("loadValuesScript");
        public static MessageKey LOAD_VALUES_SCRIPT_PARAMETERS = new Fields("loadValuesScriptParameters");
        public static MessageKey MAX_FILES = new Fields("maxFiles");
        public static MessageKey MAX_WORD_SIZE = new Fields("maxWordSize");
        public static MessageKey NAME = new Fields("name");
        public static MessageKey OTHER_MIME_TYPES = new Fields("otherMimeTypes");
        public static MessageKey PATTERN = new Fields("pattern");
        public static MessageKey POSSIBLE_VALUES = new Fields("possibleValues");
        public static MessageKey POSSIBLE_VALUE_CATEGORIES = new Fields("possibleValueCategories");
        public static MessageKey POSSIBLE_VALUE_CATEGORY = new Fields("possibleValue.category");
        public static MessageKey POSSIBLE_VALUE_CUSTOM_FIELD = new Fields("possibleValue.customField");
        public static MessageKey POSSIBLE_VALUE_DEFAULT_ON_CREATION = new Fields("possibleValue.defaultOnCreation");
        public static MessageKey POSSIBLE_VALUE_DEFAULT_ON_SEARCH = new Fields("possibleValue.defaultOnSearch");
        public static MessageKey POSSIBLE_VALUE_ERROR_MORE_THAN_ONE_DEFAULT = new Fields("possibleValue.error.moreThanOneDefault");
        public static MessageKey POSSIBLE_VALUE_VALUE = new Fields("possibleValue.value");
        public static MessageKey PROCESS_AFTER_SCAN = new Fields("processAfterScan");
        public static MessageKey REQUIRED = new Fields("required");
        public static MessageKey SAVE_ENUMERATED = new Fields("saveEnumerated");
        public static MessageKey SHOW_QR_CODE_SCAN = new Fields("showQrCodeScan");
        public static MessageKey SIZE = new Fields("size");
        public static MessageKey SIZE_FULL = new Fields("size.FULL");
        public static MessageKey SIZE_LARGE = new Fields("size.LARGE");
        public static MessageKey SIZE_MEDIUM = new Fields("size.MEDIUM");
        public static MessageKey SIZE_SMALL = new Fields("size.SMALL");
        public static MessageKey SIZE_TINY = new Fields("size.TINY");
        public static MessageKey STORAGE_DIRECTORY = new Fields("storageDirectory");
        public static MessageKey TYPE = new Fields("type");
        public static MessageKey TYPE_BOOLEAN = new Fields("type.BOOLEAN");
        public static MessageKey TYPE_DATE = new Fields("type.DATE");
        public static MessageKey TYPE_DECIMAL = new Fields("type.DECIMAL");
        public static MessageKey TYPE_DYNAMIC_MULTI_SELECTION = new Fields("type.DYNAMIC_MULTI_SELECTION");
        public static MessageKey TYPE_DYNAMIC_SELECTION = new Fields("type.DYNAMIC_SELECTION");
        public static MessageKey TYPE_FILE = new Fields("type.FILE");
        public static MessageKey TYPE_IMAGE = new Fields("type.IMAGE");
        public static MessageKey TYPE_INTEGER = new Fields("type.INTEGER");
        public static MessageKey TYPE_LINKED_ENTITY = new Fields("type.LINKED_ENTITY");
        public static MessageKey TYPE_MULTI_SELECTION = new Fields("type.MULTI_SELECTION");
        public static MessageKey TYPE_RICH_TEXT = new Fields("type.RICH_TEXT");
        public static MessageKey TYPE_SINGLE_SELECTION = new Fields("type.SINGLE_SELECTION");
        public static MessageKey TYPE_STRING = new Fields("type.STRING");
        public static MessageKey TYPE_TEXT = new Fields("type.TEXT");
        public static MessageKey TYPE_URL = new Fields("type.URL");
        public static MessageKey UNIQUE = new Fields("unique");
        public static MessageKey VALIDATION_DETAILS = new Fields("validationDetails");
        public static MessageKey VALIDATION_SCRIPT = new Fields("validationScript");
        public static MessageKey VALIDATION_SCRIPT_PARAMETERS = new Fields("validationScriptParameters");
        public static MessageKey VALUE_MATCH = new Fields("valueMatch");
        public static MessageKey VALUE_MATCH_EXACT = new Fields("valueMatch.EXACT");
        public static MessageKey VALUE_MATCH_LANGUAGE = new Fields("valueMatch.LANGUAGE");
        public static MessageKey VALUE_MATCH_TEXT = new Fields("valueMatch.TEXT");
        public static MessageKey VALUE_RANGE = new Fields("valueRange");

        private Fields(String string) {
            super((Submodule)SystemSubmodule.FIELDS, string);
        }
    }

    public static class ExtensionPoints
    extends MessageKeyImpl {
        public static MessageKey AGREEMENTS = new ExtensionPoints("agreements");
        public static MessageKey ENABLED = new ExtensionPoints("enabled");
        public static MessageKey ERROR_NO_SCRIPTS = new ExtensionPoints("error.noScripts");
        public static MessageKey EVENTS = new ExtensionPoints("events");
        public static MessageKey EVENTS_ACCEPT = new ExtensionPoints("events.ACCEPT");
        public static MessageKey EVENTS_ACTIVATE = new ExtensionPoints("events.ACTIVATE");
        public static MessageKey EVENTS_AUTHORIZE = new ExtensionPoints("events.AUTHORIZE");
        public static MessageKey EVENTS_BUY = new ExtensionPoints("events.BUY");
        public static MessageKey EVENTS_CANCEL = new ExtensionPoints("events.CANCEL");
        public static MessageKey EVENTS_CHANGE_GROUP = new ExtensionPoints("events.CHANGE_GROUP");
        public static MessageKey EVENTS_CHANGE_STATUS = new ExtensionPoints("events.CHANGE_STATUS");
        public static MessageKey EVENTS_CHARGEBACK = new ExtensionPoints("events.CHARGEBACK");
        public static MessageKey EVENTS_CONFIRM = new ExtensionPoints("events.CONFIRM");
        public static MessageKey EVENTS_CREATE = new ExtensionPoints("events.CREATE");
        public static MessageKey EVENTS_CREATE_TICKET = new ExtensionPoints("events.CREATE_TICKET");
        public static MessageKey EVENTS_DELETE = new ExtensionPoints("events.DELETE");
        public static MessageKey EVENTS_DENY = new ExtensionPoints("events.DENY");
        public static MessageKey EVENTS_EXPIRE = new ExtensionPoints("events.EXPIRE");
        public static MessageKey EVENTS_FILE_STATUS_CHANGED = new ExtensionPoints("events.FILE_STATUS_CHANGED");
        public static MessageKey EVENTS_GENERATE = new ExtensionPoints("events.GENERATE");
        public static MessageKey EVENTS_INSTALLMENT_CHANGE_STATUS = new ExtensionPoints("events.INSTALLMENT_CHANGE_STATUS");
        public static MessageKey EVENTS_LINE_PROCESSED = new ExtensionPoints("events.LINE_PROCESSED");
        public static MessageKey EVENTS_LINE_READ = new ExtensionPoints("events.LINE_READ");
        public static MessageKey EVENTS_PREVIEW = new ExtensionPoints("events.PREVIEW");
        public static MessageKey EVENTS_REDEEM = new ExtensionPoints("events.REDEEM");
        public static MessageKey EVENTS_REJECT = new ExtensionPoints("events.REJECT");
        public static MessageKey EVENTS_SEND_REQUEST = new ExtensionPoints("events.SEND_REQUEST");
        public static MessageKey EVENTS_TOP_UP = new ExtensionPoints("events.TOP_UP");
        public static MessageKey EVENTS_UNBLOCK = new ExtensionPoints("events.UNBLOCK");
        public static MessageKey EVENTS_UPDATE = new ExtensionPoints("events.UPDATE");
        public static MessageKey GROUPS = new ExtensionPoints("groups");
        public static MessageKey HEADING_DETAILS = new ExtensionPoints("heading.details");
        public static MessageKey HEADING_LIST = new ExtensionPoints("heading.list");
        public static MessageKey HEADING_NEW = new ExtensionPoints("heading.new");
        public static MessageKey IMPORT_TYPES = new ExtensionPoints("importTypes");
        public static MessageKey NATURE = new ExtensionPoints("nature");
        public static MessageKey NATURE_AD = new ExtensionPoints("nature.AD");
        public static MessageKey NATURE_AGREEMENT = new ExtensionPoints("nature.AGREEMENT");
        public static MessageKey NATURE_AUTHORIZATION = new ExtensionPoints("nature.AUTHORIZATION");
        public static MessageKey NATURE_IMPORT = new ExtensionPoints("nature.IMPORT");
        public static MessageKey NATURE_OPERATOR = new ExtensionPoints("nature.OPERATOR");
        public static MessageKey NATURE_ORDER = new ExtensionPoints("nature.ORDER");
        public static MessageKey NATURE_PHONE = new ExtensionPoints("nature.PHONE");
        public static MessageKey NATURE_RECORD = new ExtensionPoints("nature.RECORD");
        public static MessageKey NATURE_TRANSACTION = new ExtensionPoints("nature.TRANSACTION");
        public static MessageKey NATURE_TRANSFER = new ExtensionPoints("nature.TRANSFER");
        public static MessageKey NATURE_USER = new ExtensionPoints("nature.USER");
        public static MessageKey NATURE_USER_ADDRESS = new ExtensionPoints("nature.USER_ADDRESS");
        public static MessageKey NATURE_VOUCHER = new ExtensionPoints("nature.VOUCHER");
        public static MessageKey RECORD_TYPES = new ExtensionPoints("recordTypes");
        public static MessageKey SCRIPT = new ExtensionPoints("script");
        public static MessageKey SCRIPT_PARAMETERS = new ExtensionPoints("scriptParameters");
        public static MessageKey TRANSFER_TYPES = new ExtensionPoints("transferTypes");
        public static MessageKey VOUCHER_CONFIGURATIONS = new ExtensionPoints("voucherConfigurations");

        private ExtensionPoints(String string) {
            super((Submodule)SystemSubmodule.EXTENSION_POINTS, string);
        }
    }

    public static class ExportFormats
    extends MessageKeyImpl {
        public static MessageKey BINARY = new ExportFormats("binary");
        public static MessageKey CONTENT_TYPE = new ExportFormats("contentType");
        public static MessageKey CONTEXTS = new ExportFormats("contexts");
        public static MessageKey CONTEXT_ACCOUNT_HISTORY = new ExportFormats("context.ACCOUNT_HISTORY");
        public static MessageKey CONTEXT_ADVERTISEMENT_DETAILS = new ExportFormats("context.ADVERTISEMENT_DETAILS");
        public static MessageKey CONTEXT_ARCHIVED_ACCOUNT_HISTORY = new ExportFormats("context.ARCHIVED_ACCOUNT_HISTORY");
        public static MessageKey CONTEXT_ARCHIVED_TRANSFER = new ExportFormats("context.ARCHIVED_TRANSFER");
        public static MessageKey CONTEXT_BALANCE_LIMITS_OVERVIEW = new ExportFormats("context.BALANCE_LIMITS_OVERVIEW");
        public static MessageKey CONTEXT_CUSTOM_OPERATION = new ExportFormats("context.CUSTOM_OPERATION");
        public static MessageKey CONTEXT_ENTITY_LOGS = new ExportFormats("context.ENTITY_LOGS");
        public static MessageKey CONTEXT_INSTALLMENTS_OVERVIEW = new ExportFormats("context.INSTALLMENTS_OVERVIEW");
        public static MessageKey CONTEXT_INSTALLMENTS_SEARCH = new ExportFormats("context.INSTALLMENTS_SEARCH");
        public static MessageKey CONTEXT_ORDER_DETAILS = new ExportFormats("context.ORDER_DETAILS");
        public static MessageKey CONTEXT_PAYMENT_AMOUNT_LIMITS_OVERVIEW = new ExportFormats("context.PAYMENT_AMOUNT_LIMITS_OVERVIEW");
        public static MessageKey CONTEXT_RECORDS_OVERVIEW = new ExportFormats("context.RECORDS_OVERVIEW");
        public static MessageKey CONTEXT_RECORDS_SEARCH = new ExportFormats("context.RECORDS_SEARCH");
        public static MessageKey CONTEXT_SHARED_FIELDS_RECORDS_SEARCH = new ExportFormats("context.SHARED_FIELDS_RECORDS_SEARCH");
        public static MessageKey CONTEXT_TOKENS_SEARCH = new ExportFormats("context.TOKENS_SEARCH");
        public static MessageKey CONTEXT_TRANSACTIONS_OVERVIEW = new ExportFormats("context.TRANSACTIONS_OVERVIEW");
        public static MessageKey CONTEXT_TRANSACTIONS_SEARCH = new ExportFormats("context.TRANSACTIONS_SEARCH");
        public static MessageKey CONTEXT_TRANSFERS_OVERVIEW = new ExportFormats("context.TRANSFERS_OVERVIEW");
        public static MessageKey CONTEXT_TRANS_DETAILS = new ExportFormats("context.TRANS_DETAILS");
        public static MessageKey CONTEXT_USERS_SEARCH = new ExportFormats("context.USERS_SEARCH");
        public static MessageKey CONTEXT_USERS_WITH_BALANCES = new ExportFormats("context.USERS_WITH_BALANCES");
        public static MessageKey CONTEXT_USER_VOUCHERS_SEARCH = new ExportFormats("context.USER_VOUCHERS_SEARCH");
        public static MessageKey CONTEXT_VOUCHERS_SEARCH = new ExportFormats("context.VOUCHERS_SEARCH");
        public static MessageKey CONTEXT_VOUCHER_DETAILS = new ExportFormats("context.VOUCHER_DETAILS");
        public static MessageKey CONTEXT_VOUCHER_TRANSACTION_DETAILS = new ExportFormats("context.VOUCHER_TRANSACTION_DETAILS");
        public static MessageKey ENABLED = new ExportFormats("enabled");
        public static MessageKey ENCODING = new ExportFormats("encoding");
        public static MessageKey FILE_EXTENSION = new ExportFormats("fileExtension");
        public static MessageKey HEADING_DETAILS = new ExportFormats("heading.details");
        public static MessageKey HEADING_LIST = new ExportFormats("heading.list");
        public static MessageKey HEADING_NEW = new ExportFormats("heading.new");
        public static MessageKey INVALID_CONTEXT = new ExportFormats("invalid.context");
        public static MessageKey SCRIPT = new ExportFormats("script");
        public static MessageKey SCRIPT_PARAMETERS = new ExportFormats("scriptParameters");

        private ExportFormats(String string) {
            super((Submodule)SystemSubmodule.EXPORT_FORMATS, string);
        }
    }

    public static class ChannelConfigurations
    extends MessageKeyImpl {
        public static MessageKey ACCESS_PASSWORD = new ChannelConfigurations("accessPassword");
        public static MessageKey ALLOW_LOGIN = new ChannelConfigurations("allowLogin");
        public static MessageKey ALLOW_LOGIN_DISABLE = new ChannelConfigurations("allowLogin.disable");
        public static MessageKey ALLOW_LOGIN_ENABLE = new ChannelConfigurations("allowLogin.enable");
        public static MessageKey CHANNEL = new ChannelConfigurations("channel");
        public static MessageKey CONFIGURATION = new ChannelConfigurations("configuration");
        public static MessageKey CONFIGURATION_NOT_ACCESSIBLE_FOR_LOGIN = new ChannelConfigurations("configurationNotAccessibleForLogin");
        public static MessageKey CONFIRMATION_ONCE_PER_SESSION = new ChannelConfigurations("confirmationOncePerSession");
        public static MessageKey CREDENTIALS_DEVICE = new ChannelConfigurations("credentials.device");
        public static MessageKey CREDENTIALS_PASSWORD = new ChannelConfigurations("credentials.password");
        public static MessageKey CREDENTIALS_TOTP = new ChannelConfigurations("credentials.totp");
        public static MessageKey DEFAULT_PRINCIPAL_TYPE = new ChannelConfigurations("defaultPrincipalType");
        public static MessageKey DEVICE_PIN = new ChannelConfigurations("devicePin");
        public static MessageKey DEVICE_PIN_ENABLE = new ChannelConfigurations("devicePin.enable");
        public static MessageKey DEVICE_PIN_EXPIRES_AFTER = new ChannelConfigurations("devicePin.expiresAfter");
        public static MessageKey DEVICE_PIN_LENGTH = new ChannelConfigurations("devicePin.length");
        public static MessageKey DEVICE_PIN_MAX_TRIES = new ChannelConfigurations("devicePin.maxTries");
        public static MessageKey DEVICE_PIN_ON_STARTUP = new ChannelConfigurations("devicePinOnStartup");
        public static MessageKey ENABLED = new ChannelConfigurations("enabled");
        public static MessageKey ERROR_CREDENTIALS_REQUIRED = new ChannelConfigurations("error.credentialsRequired");
        public static MessageKey ERROR_MAIN_NEEDS_USERNAME = new ChannelConfigurations("error.mainNeedsUsername");
        public static MessageKey HEADING_DETAILS = new ChannelConfigurations("heading.details");
        public static MessageKey HEADING_LIST = new ChannelConfigurations("heading.list");
        public static MessageKey IDENTIFICATION_METHOD_AUTOCOMPLETE = new ChannelConfigurations("identificationMethod.AUTOCOMPLETE");
        public static MessageKey IDENTIFICATION_METHOD_CONTACTS = new ChannelConfigurations("identificationMethod.CONTACTS");
        public static MessageKey IDENTIFICATION_METHOD_PRINCIPAL_TYPE = new ChannelConfigurations("identificationMethod.PRINCIPAL_TYPE");
        public static MessageKey IDENTITY_PROVIDERS = new ChannelConfigurations("identityProviders");
        public static MessageKey IDENTITY_PROVIDERS_ERROR_REQUIRED_TRUSTED_DEVICE = new ChannelConfigurations("identityProviders.error.requiredTrustedDevice");
        public static MessageKey IP_WHITELIST = new ChannelConfigurations("ipWhitelist");
        public static MessageKey IP_WHITELIST_ANY = new ChannelConfigurations("ipWhitelist.any");
        public static MessageKey MOBILE_NUMBER_SOURCE = new ChannelConfigurations("mobileNumberSource");
        public static MessageKey NO_DEFAULT_PRINCIPAL_TYPE = new ChannelConfigurations("noDefaultPrincipalType");
        public static MessageKey PASSWORD = new ChannelConfigurations("password");
        public static MessageKey PAYMENTS_AUTOCOMPLETE = new ChannelConfigurations("payments.autocomplete");
        public static MessageKey PAYMENTS_CONTACTS = new ChannelConfigurations("payments.contacts");
        public static MessageKey PAYMENTS_DEFAULT_ID_METHOD = new ChannelConfigurations("payments.defaultIdMethod");
        public static MessageKey PAYMENTS_DEFAULT_PRINCIPAL_TYPE = new ChannelConfigurations("payments.defaultPrincipalType");
        public static MessageKey PAYMENTS_PRINCIPAL_TYPES = new ChannelConfigurations("payments.principalTypes");
        public static MessageKey PAYMENTS_PRINCIPAL_TYPES_EASY_INVOICE = new ChannelConfigurations("payments.principalTypes.easyInvoice");
        public static MessageKey PAYMENTS_SCAN_QR_CODE = new ChannelConfigurations("payments.scanQrCode");
        public static MessageKey POS_CONFIRMATION_NO_CREDENTIALS = new ChannelConfigurations("posConfirmation.noCredentials");
        public static MessageKey PRINCIPAL_TYPES = new ChannelConfigurations("principalTypes");
        public static MessageKey PRINCIPAL_TYPES_EASY_INVOICE = new ChannelConfigurations("principalTypes.easyInvoice");
        public static MessageKey PRINCIPAL_TYPES_ERROR_TRUSTED_DEVICE = new ChannelConfigurations("principalTypes.error.trustedDevice");
        public static MessageKey PROMPT_ON_STARTUP_INFORMATION = new ChannelConfigurations("promptOnStartupInformation");
        public static MessageKey REGISTRATION_WITH_IDENTITY_PROVIDERS = new ChannelConfigurations("registrationWithIdentityProviders");
        public static MessageKey REGISTRATION_WITH_IDENTITY_PROVIDERS_DISABLED = new ChannelConfigurations("registrationWithIdentityProviders.DISABLED");
        public static MessageKey REGISTRATION_WITH_IDENTITY_PROVIDERS_ENABLED_DIRECT = new ChannelConfigurations("registrationWithIdentityProviders.ENABLED_DIRECT");
        public static MessageKey REGISTRATION_WITH_IDENTITY_PROVIDERS_ENABLED_FORM = new ChannelConfigurations("registrationWithIdentityProviders.ENABLED_FORM");
        public static MessageKey REPEATED_SECONDARY_ACCESS_PASSWORD = new ChannelConfigurations("repeatedSecondaryAccessPassword");
        public static MessageKey REQUIRE_AUTHENTICATION_FOR_DEVICE_CONFIRMATION = new ChannelConfigurations("requireAuthenticationForDeviceConfirmation");
        public static MessageKey REQUIRE_TRUSTED_DEVICE_FOR_LOGIN = new ChannelConfigurations("requireTrustedDeviceForLogin");
        public static MessageKey REQUIRE_TRUSTED_DEVICE_FOR_LOGIN_NOTIFICATION = new ChannelConfigurations("requireTrustedDeviceForLogin.notification");
        public static MessageKey RESET_SECONDARY_ACCESS_PASSWORD = new ChannelConfigurations("resetSecondaryAccessPassword");
        public static MessageKey SCRIPT = new ChannelConfigurations("script");
        public static MessageKey SCRIPT_PARAMETERS = new ChannelConfigurations("scriptParameters");
        public static MessageKey SECTION_ACCESS = new ChannelConfigurations("section.access");
        public static MessageKey SECTION_CONFIRMATION = new ChannelConfigurations("section.confirmation");
        public static MessageKey SECTION_DEVICE_PIN = new ChannelConfigurations("section.devicePin");
        public static MessageKey SECTION_INBOUND_SMS = new ChannelConfigurations("section.inboundSms");
        public static MessageKey SECTION_LOGIN_CONFIRMATION = new ChannelConfigurations("section.loginConfirmation");
        public static MessageKey SECTION_PERFORM_PAYMENTS = new ChannelConfigurations("section.performPayments");
        public static MessageKey SECTION_POS_CONFIRMATION = new ChannelConfigurations("section.posConfirmation");
        public static MessageKey SECTION_RECEIVE_PAYMENTS = new ChannelConfigurations("section.receivePayments");
        public static MessageKey SESSION_TIMEOUT = new ChannelConfigurations("sessionTimeout");
        public static MessageKey SHOW_QR_CODE_FOR_USER_IDENTIFICATION_METHODS = new ChannelConfigurations("showQrCodeForUserIdentificationMethods");
        public static MessageKey SKIP_CONFIRMATION_FOR_TRUSTED_DEVICES = new ChannelConfigurations("skipConfirmationForTrustedDevices");
        public static MessageKey SMS_MESSAGE_SOURCE = new ChannelConfigurations("smsMessageSource");
        public static MessageKey SMS_MOBILE_NOT_UNIQUE = new ChannelConfigurations("sms.mobileNotUnique");
        public static MessageKey SMS_OPERATIONS = new ChannelConfigurations("smsOperations");
        public static MessageKey TRUSTED_DEVICE_ON_STARTUP = new ChannelConfigurations("trustedDeviceOnStartup");
        public static MessageKey URL = new ChannelConfigurations("url");
        public static MessageKey USERNAME = new ChannelConfigurations("username");
        public static MessageKey USER_ACCESS = new ChannelConfigurations("userAccess");
        public static MessageKey USER_ACCESS_DEFAULT_DISABLED = new ChannelConfigurations("userAccess.DEFAULT_DISABLED");
        public static MessageKey USER_ACCESS_DEFAULT_ENABLED = new ChannelConfigurations("userAccess.DEFAULT_ENABLED");
        public static MessageKey USER_ACCESS_ENFORCED_ENABLED = new ChannelConfigurations("userAccess.ENFORCED_ENABLED");

        private ChannelConfigurations(String string) {
            super((Submodule)SystemSubmodule.CHANNEL_CONFIGURATIONS, string);
        }
    }

    public static class Configurations
    extends MessageKeyImpl {
        public static MessageKey ACCOUNT_NUMBER = new Configurations("accountNumber");
        public static MessageKey ACCOUNT_NUMBER_ENABLED = new Configurations("accountNumberEnabled");
        public static MessageKey ACCOUNT_NUMBER_MASK = new Configurations("accountNumberMask");
        public static MessageKey ACCOUNT_NUMBER_MASK_WARN = new Configurations("accountNumberMaskWarn");
        public static MessageKey ACCOUNT_NUMBER_SCRIPT = new Configurations("accountNumberScript");
        public static MessageKey ACCOUNT_NUMBER_SCRIPT_PARAMETERS = new Configurations("accountNumberScriptParameters");
        public static MessageKey ACCOUNT_STATUS_INDICATORS = new Configurations("accountStatusIndicators");
        public static MessageKey ADDRESS_CONFIGURATION = new Configurations("addressConfiguration");
        public static MessageKey ADDRESS_FIELDS = new Configurations("addressFields");
        public static MessageKey ADS_RESULT_TYPE = new Configurations("adsResultType");
        public static MessageKey ADS_SORT_ORDER = new Configurations("adsSortOrder");
        public static MessageKey AD_CATEGORIES_RESULT_TYPE = new Configurations("adCategoriesResultType");
        public static MessageKey AD_CATEGORIES_RESULT_TYPE_BULLET_LIST = new Configurations("adCategoriesResultType.BULLET_LIST");
        public static MessageKey AD_CATEGORIES_RESULT_TYPE_IMAGE_LIST = new Configurations("adCategoriesResultType.IMAGE_LIST");
        public static MessageKey AD_FIELDS_VISIBLE_TO_GUESTS = new Configurations("adFieldsVisibleToGuests");
        public static MessageKey AD_INITIAL_SEARCH_TYPE = new Configurations("adInitialSearchType");
        public static MessageKey AD_INITIAL_SEARCH_TYPE_ADS = new Configurations("adInitialSearchType.ADS");
        public static MessageKey AD_INITIAL_SEARCH_TYPE_CATEGORIES = new Configurations("adInitialSearchType.CATEGORIES");
        public static MessageKey AD_SUB_CATEGORIES_RESULTS = new Configurations("adSubCategoriesResults");
        public static MessageKey ALLOWED_LANGUAGES = new Configurations("allowedLanguages");
        public static MessageKey ALLOW_ACCESS_MODE = new Configurations("allowAccessMode");
        public static MessageKey ALLOW_ACCESS_MODE_ANY = new Configurations("allowAccessMode.ANY");
        public static MessageKey ALLOW_ACCESS_MODE_CURRENT_ONLY = new Configurations("allowAccessMode.CURRENT_ONLY");
        public static MessageKey ALLOW_ACCESS_MODE_CURRENT_OR_ANCESTORS = new Configurations("allowAccessMode.CURRENT_OR_ANCESTORS");
        public static MessageKey ALLOW_FRONTEND_SWITCHING = new Configurations("allowFrontendSwitching");
        public static MessageKey ALLOW_MULTIPLE_REPORTS = new Configurations("allowMultipleReports");
        public static MessageKey ALLOW_QUICK_PAYMENT_MOBILE = new Configurations("allowQuickPaymentMobile");
        public static MessageKey ALLOW_VIEW_USER_AD = new Configurations("allowViewUserAd");
        public static MessageKey ALLOW_VIEW_USER_WEB_SHOP = new Configurations("allowViewUserWebShop");
        public static MessageKey ALWAYS_SHOW_INTERNATIONAL_PHONE_NUMBER = new Configurations("alwaysShowInternationalPhoneNumber");
        public static MessageKey API_URL = new Configurations("apiUrl");
        public static MessageKey API_URL_DEFAULT = new Configurations("apiUrl.default");
        public static MessageKey API_URL_NOT_USED = new Configurations("apiUrl.notUsed");
        public static MessageKey APPLE_STORE_URL_MOBILE = new Configurations("appleStoreUrlMobile");
        public static MessageKey APPLICATION_DESCRIPTION = new Configurations("applicationDescription");
        public static MessageKey APPLICATION_NAME = new Configurations("applicationName");
        public static MessageKey APPLICATION_USERNAME = new Configurations("applicationUsername");
        public static MessageKey APPLY_DEFAULT_USER_SEARCH_FILTERS_ON_PAYMENT = new Configurations("applyDefaultUserSearchFiltersOnPayment");
        public static MessageKey APPLY_THEMES = new Configurations("applyThemes");
        public static MessageKey APP_THEME = new Configurations("appTheme");
        public static MessageKey AUTOCOMPLETE_RESULTS = new Configurations("autocompleteResults");
        public static MessageKey BANNER_ROTATE_SECONDS = new Configurations("bannerRotateSeconds");
        public static MessageKey CAPTCHA_CONFIGURATION = new Configurations("captchaConfiguration");
        public static MessageKey CAPTCHA_EFFECT = new Configurations("captchaEffect");
        public static MessageKey CAPTCHA_EFFECT_FISH_EYE = new Configurations("captchaEffect.FISH_EYE");
        public static MessageKey CAPTCHA_EFFECT_SHADOW = new Configurations("captchaEffect.SHADOW");
        public static MessageKey CAPTCHA_EFFECT_WATER = new Configurations("captchaEffect.WATER");
        public static MessageKey CAPTCHA_ON_FORGOT_PASSWORD = new Configurations("captchaOnForgotPassword");
        public static MessageKey CAPTCHA_ON_PUBLIC_REGISTRATION = new Configurations("captchaOnPublicRegistration");
        public static MessageKey CAPTCHA_PROVIDER = new Configurations("captchaProvider");
        public static MessageKey CAPTCHA_PROVIDER_INTERNAL = new Configurations("captchaProvider.INTERNAL");
        public static MessageKey CAPTCHA_PROVIDER_RECAPTCHA_V_2 = new Configurations("captchaProvider.RECAPTCHA_V2");
        public static MessageKey CAPTCHA_RECAPTCHA_KEY = new Configurations("captchaRecaptchaKey");
        public static MessageKey CAPTCHA_RECAPTCHA_SECRET = new Configurations("captchaRecaptchaSecret");
        public static MessageKey CAPTCHA_TEXT_COLOR = new Configurations("captchaTextColor");
        public static MessageKey CAPTCHA_TEXT_LENGTH = new Configurations("captchaTextLength");
        public static MessageKey COMMUNITY_MENU_LABEL = new Configurations("communityMenuLabel");
        public static MessageKey COUNTRY = new Configurations("country");
        public static MessageKey CUSTOM_SESSION = new Configurations("customSession");
        public static MessageKey CUSTOM_SESSION_ENABLED = new Configurations("customSessionEnabled");
        public static MessageKey CUSTOM_SESSION_SCRIPT = new Configurations("customSessionScript");
        public static MessageKey CUSTOM_SESSION_SCRIPT_PARAMETERS = new Configurations("customSessionScriptParameters");
        public static MessageKey DATE_FORMAT = new Configurations("dateFormat");
        public static MessageKey DEFAULT_ACCOUNT_HISTORY_PERIOD = new Configurations("defaultAccountHistoryPeriod");
        public static MessageKey DEFAULT_ACCOUNT_HISTORY_PERIOD_ALL_TIME = new Configurations("defaultAccountHistoryPeriod.ALL_TIME");
        public static MessageKey DEFAULT_ACCOUNT_HISTORY_PERIOD_CURRENT_MONTH = new Configurations("defaultAccountHistoryPeriod.CURRENT_MONTH");
        public static MessageKey DEFAULT_ACCOUNT_HISTORY_PERIOD_CURRENT_WEEK = new Configurations("defaultAccountHistoryPeriod.CURRENT_WEEK");
        public static MessageKey DEFAULT_ACCOUNT_HISTORY_PERIOD_CURRENT_YEAR = new Configurations("defaultAccountHistoryPeriod.CURRENT_YEAR");
        public static MessageKey DEFAULT_ACCOUNT_HISTORY_PERIOD_LAST_12_MONTHS = new Configurations("defaultAccountHistoryPeriod.LAST_12_MONTHS");
        public static MessageKey DEFAULT_ACCOUNT_HISTORY_PERIOD_LAST_3_MONTHS = new Configurations("defaultAccountHistoryPeriod.LAST_3_MONTHS");
        public static MessageKey DEFAULT_ACCOUNT_HISTORY_PERIOD_LAST_MONTH = new Configurations("defaultAccountHistoryPeriod.LAST_MONTH");
        public static MessageKey DEFAULT_ACCOUNT_HISTORY_PERIOD_TODAY = new Configurations("defaultAccountHistoryPeriod.TODAY");
        public static MessageKey DEFAULT_CITY = new Configurations("defaultCity");
        public static MessageKey DEFAULT_FOR_NETWORK = new Configurations("defaultForNetwork");
        public static MessageKey DEFAULT_LANGUAGE = new Configurations("defaultLanguage");
        public static MessageKey DEFAULT_MAP_LOCATION = new Configurations("defaultMapLocation");
        public static MessageKey DEFAULT_MAP_ZOOM_MOBILE = new Configurations("defaultMapZoomMobile");
        public static MessageKey DEFAULT_MAP_ZOOM_WEB = new Configurations("defaultMapZoomWeb");
        public static MessageKey DEFAULT_REGION = new Configurations("defaultRegion");
        public static MessageKey DEFAULT_USER_IMAGE = new Configurations("defaultUserImage");
        public static MessageKey DISTANCE_UNIT = new Configurations("distanceUnit");
        public static MessageKey DYNA_OIDC_ALLOW_UNENCRYPTED_URIS = new Configurations("dynaOidcAllowUnencryptedUris");
        public static MessageKey DYNA_OIDC_CLIENTS = new Configurations("dynaOidcClients");
        public static MessageKey DYNA_OIDC_ENABLED = new Configurations("dynaOidcEnabled");
        public static MessageKey EMAIL_NAME = new Configurations("emailName");
        public static MessageKey EMAIL_REQUIRED = new Configurations("emailRequired");
        public static MessageKey EMAIL_UNIQUE = new Configurations("emailUnique");
        public static MessageKey EMAIL_UNIQUE_WARNING = new Configurations("emailUnique.warning");
        public static MessageKey EMAIL_VALIDATION = new Configurations("emailValidation");
        public static MessageKey EMAIL_VALIDATION_EDIT_BY_ADMIN = new Configurations("emailValidation.EDIT_BY_ADMIN");
        public static MessageKey EMAIL_VALIDATION_EDIT_BY_BROKER = new Configurations("emailValidation.EDIT_BY_BROKER");
        public static MessageKey EMAIL_VALIDATION_EDIT_BY_SELF = new Configurations("emailValidation.EDIT_BY_SELF");
        public static MessageKey EMAIL_VALIDATION_IMPORTED_USERS = new Configurations("emailValidation.IMPORTED_USERS");
        public static MessageKey EMAIL_VALIDATION_OPERATOR_REGISTRATION_BY_MEMBER = new Configurations("emailValidation.OPERATOR_REGISTRATION_BY_MEMBER");
        public static MessageKey EMAIL_VALIDATION_PUBLIC_REGISTRATION = new Configurations("emailValidation.PUBLIC_REGISTRATION");
        public static MessageKey EMAIL_VALIDATION_REGISTRATION_BY_ADMIN = new Configurations("emailValidation.REGISTRATION_BY_ADMIN");
        public static MessageKey EMAIL_VALIDATION_REGISTRATION_BY_BROKER = new Configurations("emailValidation.REGISTRATION_BY_BROKER");
        public static MessageKey EMAIL_VALIDATION_REGISTRATION_BY_MEMBER = new Configurations("emailValidation.REGISTRATION_BY_MEMBER");
        public static MessageKey ENABLE_BLUETOOTH_PRINTER_MOBILE = new Configurations("enableBluetoothPrinterMobile");
        public static MessageKey ENABLE_SERVICES_LOG = new Configurations("enableServicesLog");
        public static MessageKey ERROR_DUPLICATE_LOCALE_IN_ALLOWED_LANGUAGES = new Configurations("error.duplicateLocaleInAllowedLanguages");
        public static MessageKey ERROR_INVALID_GROUPS_FOR_USER_SEARCH_FOR_GUEST = new Configurations("error.invalidGroupsForUserSearchForGuest");
        public static MessageKey ERROR_INVALID_PATH = new Configurations("error.invalidPath");
        public static MessageKey ERROR_REJECTED_RECAPTCHA_SECRET = new Configurations("error.rejectedRecaptchaSecret");
        public static MessageKey ERROR_ROOT_URL_CONTAINS_RESERVED_WORD = new Configurations("error.rootUrlContainsReservedWord");
        public static MessageKey FILTER_BY_GROUPS = new Configurations("filterByGroups");
        public static MessageKey FIREBASE_PRIVATE_KEY = new Configurations("firebasePrivateKey");
        public static MessageKey FORGOT_PASSWORD_MODE = new Configurations("forgotPasswordMode");
        public static MessageKey FORGOT_PASSWORD_MODE_DISABLED = new Configurations("forgotPasswordMode.DISABLED");
        public static MessageKey FORGOT_PASSWORD_MODE_ENABLED = new Configurations("forgotPasswordMode.ENABLED");
        public static MessageKey FORGOT_PASSWORD_MODE_SECURITY_QUESTION = new Configurations("forgotPasswordMode.SECURITY_QUESTION");
        public static MessageKey FORGOT_PASSWORD_SEND_MEDIUM = new Configurations("forgotPasswordSendMedium");
        public static MessageKey FORGOT_PASSWORD_SEND_MEDIUM_BOTH = new Configurations("forgotPasswordSendMedium.both");
        public static MessageKey FRONTEND = new Configurations("frontend");
        public static MessageKey FRONTEND_CLASSIC = new Configurations("frontend.CLASSIC");
        public static MessageKey FRONTEND_DASHBOARD_ACCOUNTS = new Configurations("frontendDashboardAccounts");
        public static MessageKey FRONTEND_DASHBOARD_ACCOUNTS_INDIVIDUAL = new Configurations("frontendDashboardAccounts.INDIVIDUAL");
        public static MessageKey FRONTEND_DASHBOARD_ACCOUNTS_MERGED = new Configurations("frontendDashboardAccounts.MERGED");
        public static MessageKey FRONTEND_DASHBOARD_ACCOUNTS_NONE = new Configurations("frontendDashboardAccounts.NONE");
        public static MessageKey FRONTEND_DASHBOARD_ADS = new Configurations("frontendDashboardAds");
        public static MessageKey FRONTEND_DASHBOARD_USERS = new Configurations("frontendDashboardUsers");
        public static MessageKey FRONTEND_LANDING_PAGE_HOME = new Configurations("frontendLandingPage.HOME");
        public static MessageKey FRONTEND_LANDING_PAGE_LOGIN = new Configurations("frontendLandingPage.LOGIN");
        public static MessageKey FRONTEND_MENU_BAR = new Configurations("frontendMenuBar");
        public static MessageKey FRONTEND_MOBILE_LANDING_PAGE_HOME = new Configurations("frontendMobileLandingPage.HOME");
        public static MessageKey FRONTEND_MOBILE_MENU_TITLE = new Configurations("frontendMobileMenuTitle");
        public static MessageKey FRONTEND_MOBILE_TITLE = new Configurations("frontendMobileTitle");
        public static MessageKey FRONTEND_NEW = new Configurations("frontend.NEW");
        public static MessageKey FRONTEND_TITLE = new Configurations("frontendTitle");
        public static MessageKey GENERATED_USERNAME = new Configurations("generatedUsername");
        public static MessageKey GENERATED_USERNAME_LENGTH = new Configurations("generatedUsernameLength");
        public static MessageKey GIVEN_VERY_BAD_REFS = new Configurations("givenVeryBadRefs");
        public static MessageKey GROUPS_FOR_USER_DIRECTORY = new Configurations("groupsForUserDirectory");
        public static MessageKey GROUPS_FOR_USER_SEARCH = new Configurations("groupsForUserSearch");
        public static MessageKey GROUPS_FOR_USER_SEARCH_IN_MENU = new Configurations("groupsForUserSearchInMenu");
        public static MessageKey GROUPS_FOR_VIEW_PROFILE = new Configurations("groupsForViewProfile");
        public static MessageKey GUESTS_MENU_TYPE = new Configurations("guestsMenuType");
        public static MessageKey GUESTS_THEME = new Configurations("guestsTheme");
        public static MessageKey GUEST_PROFILE_FIELDS = new Configurations("guestProfileFields");
        public static MessageKey HEADING_ACTIVE = new Configurations("heading.active");
        public static MessageKey HEADING_DETAILS = new Configurations("heading.details");
        public static MessageKey HEADING_LIST = new Configurations("heading.list");
        public static MessageKey HEADING_NEW = new Configurations("heading.new");
        public static MessageKey HEADING_SELECT = new Configurations("heading.select");
        public static MessageKey HIDE_AD_OWNER_TO_GUESTS = new Configurations("hideAdOwnerToGuests");
        public static MessageKey HIDE_AD_PRICE_TO_GUESTS = new Configurations("hideAdPriceToGuests");
        public static MessageKey IMAGE_TYPE = new Configurations("image.type");
        public static MessageKey IMAGE_TYPE_APP_LOGO = new Configurations("image.type.APP_LOGO");
        public static MessageKey IMAGE_TYPE_MASKABLE_LOGO = new Configurations("image.type.MASKABLE_LOGO");
        public static MessageKey IMAGE_TYPE_MASKABLE_LOGO_LINK = new Configurations("image.type.MASKABLE_LOGO.link");
        public static MessageKey IMAGE_TYPE_MOBILE_LOGO = new Configurations("image.type.MOBILE_LOGO");
        public static MessageKey IMAGE_TYPE_PAY_LOGO = new Configurations("image.type.PAY_LOGO");
        public static MessageKey IMAGE_TYPE_REPORTS_LOGO = new Configurations("image.type.REPORTS_LOGO");
        public static MessageKey IMAGE_TYPE_SHORTCUT_ICON = new Configurations("image.type.SHORTCUT_ICON");
        public static MessageKey IMAGE_TYPE_SYSTEM_LOGO = new Configurations("image.type.SYSTEM_LOGO");
        public static MessageKey INCLUDE_IN_SITEMAP = new Configurations("includeInSitemap");
        public static MessageKey INDIVIDUAL_DOCUMENT_DIRECTORY = new Configurations("individualDocumentDirectory");
        public static MessageKey INHERITED_VALUE = new Configurations("inheritedValue");
        public static MessageKey INVALID_AD_MAP_RESULT_TYPE = new Configurations("invalidAdMapResultType");
        public static MessageKey INVALID_POS_PAYER_ATTEMPTS = new Configurations("invalidPosPayerAttempts");
        public static MessageKey INVALID_TOTP_ATTEMPTS = new Configurations("invalidTotpAttempts");
        public static MessageKey INVALID_USERNAME_ATTEMPTS = new Configurations("invalidUsernameAttempts");
        public static MessageKey INVALID_USER_MAP_RESULT_TYPE = new Configurations("invalidUserMapResultType");
        public static MessageKey IP_GEOLOCATION = new Configurations("ipGeolocation");
        public static MessageKey IP_GEOLOCATION_EXPIRATION = new Configurations("ipGeolocation.expiration");
        public static MessageKey IP_GEOLOCATION_SCRIPT = new Configurations("ipGeolocation.script");
        public static MessageKey IP_GEOLOCATION_SCRIPT_PARAMETERS = new Configurations("ipGeolocation.scriptParameters");
        public static MessageKey JPEG_QUALITY = new Configurations("jpegQuality");
        public static MessageKey LAND_LINE_ENABLE_EXTENSION = new Configurations("landLineEnableExtension");
        public static MessageKey LAND_LINE_REQUIRED = new Configurations("landLineRequired");
        public static MessageKey LARGE_SCREEN_REGISTRATION_WIZARD = new Configurations("largeScreenRegistrationWizard");
        public static MessageKey LINK_GENERATION = new Configurations("linkGeneration");
        public static MessageKey LINK_GENERATION_SCRIPT = new Configurations("linkGenerationScript");
        public static MessageKey LINK_GENERATION_SCRIPT_PARAMETERS = new Configurations("linkGenerationScriptParameters");
        public static MessageKey LIST_SEPARATOR = new Configurations("listSeparator");
        public static MessageKey LOGIN_URL = new Configurations("loginUrl");
        public static MessageKey LOGOUT_URL = new Configurations("logoutUrl");
        public static MessageKey LOG_SERVICES_FOR_GUESTS = new Configurations("logServicesForGuests");
        public static MessageKey LOG_SERVICES_PARAMETERS = new Configurations("logServicesParameters");
        public static MessageKey LOG_SERVICES_RESULTS = new Configurations("logServicesResults");
        public static MessageKey LOG_SERVICES_WRITES_ONLY = new Configurations("logServicesWritesOnly");
        public static MessageKey MAP_BROWSER_API_KEY = new Configurations("mapBrowserApiKey");
        public static MessageKey MAP_DIRECTORY_FIELD = new Configurations("mapDirectoryField");
        public static MessageKey MAP_DIRECTORY_FIELD_EMPTY = new Configurations("mapDirectoryField.empty");
        public static MessageKey MAP_PREFERENCE_MOBILE = new Configurations("mapPreferenceMobile");
        public static MessageKey MAP_PREFERENCE_MOBILE_DEFAULT_MAP = new Configurations("mapPreferenceMobile.DEFAULT_MAP");
        public static MessageKey MAP_PREFERENCE_MOBILE_FILTERS = new Configurations("mapPreferenceMobile.FILTERS");
        public static MessageKey MAP_PREFERENCE_MOBILE_LOCAL_MAP = new Configurations("mapPreferenceMobile.LOCAL_MAP");
        public static MessageKey MAP_SERVER_API_KEY = new Configurations("mapServerApiKey");
        public static MessageKey MARKETPLACE_MENU_LABEL = new Configurations("marketplaceMenuLabel");
        public static MessageKey MAX_BLOCKED_USERS = new Configurations("maxBlockedUsers");
        public static MessageKey MAX_GUEST_TEMP_IMAGES = new Configurations("maxGuestTempImages");
        public static MessageKey MAX_IMAGE_DIMENSIONS = new Configurations("maxImageDimensions");
        public static MessageKey MAX_LEFT_BANNERS = new Configurations("maxLeftBanners");
        public static MessageKey MAX_LOG_ENTRIES = new Configurations("maxLogEntries");
        public static MessageKey MAX_MEDIUM_THUMB_DIMENSIONS = new Configurations("maxMediumThumbDimensions");
        public static MessageKey MAX_PNG_SIZE = new Configurations("maxPngSize");
        public static MessageKey MAX_RESULTS = new Configurations("maxResults");
        public static MessageKey MAX_RESULTS_ON_MAP = new Configurations("maxResultsOnMap");
        public static MessageKey MAX_RIGHT_BANNERS = new Configurations("maxRightBanners");
        public static MessageKey MAX_SMALL_THUMB_DIMENSIONS = new Configurations("maxSmallThumbDimensions");
        public static MessageKey MAX_TINY_THUMB_DIMENSIONS = new Configurations("maxTinyThumbDimensions");
        public static MessageKey MAX_UPLOAD_SIZE = new Configurations("maxUploadSize");
        public static MessageKey MAX_USER_TEMP_IMAGES = new Configurations("maxUserTempImages");
        public static MessageKey MEDIUM_SCREEN_REGISTRATION_WIZARD = new Configurations("mediumScreenRegistrationWizard");
        public static MessageKey MENU_TYPE_TOP = new Configurations("menuType.TOP");
        public static MessageKey MENU_TYPE_TOP_AND_LEFT = new Configurations("menuType.TOP_AND_LEFT");
        public static MessageKey MOBILE_REQUIRED = new Configurations("mobileRequired");
        public static MessageKey MOBILE_THEME = new Configurations("mobileTheme");
        public static MessageKey MOBILE_UNIQUE = new Configurations("mobileUnique");
        public static MessageKey MOBILE_UNIQUE_WARNING = new Configurations("mobileUnique.warning");
        public static MessageKey NAME_LABEL = new Configurations("nameLabel");
        public static MessageKey NEW_EXTENDING = new Configurations("newExtending");
        public static MessageKey NOTIFICATION = new Configurations("notification");
        public static MessageKey NOTIFICATION_SCRIPT = new Configurations("notificationScript");
        public static MessageKey NOTIFICATION_SCRIPT_PARAMETERS = new Configurations("notificationScriptParameters");
        public static MessageKey NOTIFY_LOGINS_ON_NEW_DEVICES = new Configurations("notifyLoginsOnNewDevices");
        public static MessageKey NO_WIZARD = new Configurations("noWizard");
        public static MessageKey NUMBER_FORMAT = new Configurations("numberFormat");
        public static MessageKey OUTBOUND_SMS = new Configurations("outboundSms");
        public static MessageKey PARENT = new Configurations("parent");
        public static MessageKey PASSWORDS = new Configurations("passwords");
        public static MessageKey PASSWORD_DEFINED = new Configurations("passwordDefined");
        public static MessageKey PATH = new Configurations("path");
        public static MessageKey PAY_THEME = new Configurations("payTheme");
        public static MessageKey PHONE_NUMBER_HANDLING = new Configurations("phoneNumberHandling");
        public static MessageKey PHONE_NUMBER_HANDLING_SCRIPT = new Configurations("phoneNumberHandlingScript");
        public static MessageKey PHONE_NUMBER_HANDLING_SCRIPT_PARAMETERS = new Configurations("phoneNumberHandlingScriptParameters");
        public static MessageKey PLAY_STORE_URL_MOBILE = new Configurations("playStoreUrlMobile");
        public static MessageKey POSSIBLE_INITIAL_GROUPS = new Configurations("possibleInitialGroups");
        public static MessageKey PRIVACY_CONTROLLED_PROFILE_FIELDS = new Configurations("privacyControlledProfileFields");
        public static MessageKey PROFILE_FIELDS_ACCOUNT_TITLE = new Configurations("profileFieldsAccountTitle");
        public static MessageKey PROFILE_FIELDS_ACCOUNT_TITLE_DEFAULT = new Configurations("profileFieldsAccountTitle.default");
        public static MessageKey PROFILE_FIELDS_IN_ACCOUNT = new Configurations("profileFieldsInAccount");
        public static MessageKey PROFILE_IMAGE_REQUIRED = new Configurations("profileImageRequired");
        public static MessageKey PROPERTY_LOCKED = new Configurations("property.locked");
        public static MessageKey PROPERTY_NOT_DEFINED = new Configurations("property.notDefined");
        public static MessageKey PROPERTY_UNLOCKED = new Configurations("property.unlocked");
        public static MessageKey RECEIVED_VERY_BAD_REFS = new Configurations("receivedVeryBadRefs");
        public static MessageKey REGEX_FOR_USERNAME = new Configurations("regexForUsername");
        public static MessageKey REMOTE_ADDRESS_BLOCK_TIME = new Configurations("remoteAddressBlockTime");
        public static MessageKey REMOTE_ADDRESS_BLOCK_TIME_BY_BLOCKED_USERS = new Configurations("remoteAddressBlockTimeByBlockedUsers");
        public static MessageKey REQUIRED_ADDRESS = new Configurations("requiredAddress");
        public static MessageKey REQUIRED_ADDRESS_FIELDS = new Configurations("requiredAddressFields");
        public static MessageKey REQUIRE_SECURITY_QUESTION_ON_REGISTRATION = new Configurations("requireSecurityQuestionOnRegistration");
        public static MessageKey ROOT_URL = new Configurations("rootUrl");
        public static MessageKey SECTION_ACCOUNT_NUMBER = new Configurations("section.accountNumber");
        public static MessageKey SECTION_ADDRESSES = new Configurations("section.addresses");
        public static MessageKey SECTION_ALERTS = new Configurations("section.alerts");
        public static MessageKey SECTION_CAPTCHA = new Configurations("section.captcha");
        public static MessageKey SECTION_CUSTOM_SESSION = new Configurations("section.customSession");
        public static MessageKey SECTION_DISPLAY = new Configurations("section.display");
        public static MessageKey SECTION_DYNA_OIDC = new Configurations("section.dynaOidc");
        public static MessageKey SECTION_EMAILS = new Configurations("section.emails");
        public static MessageKey SECTION_FRONTEND = new Configurations("section.frontend");
        public static MessageKey SECTION_GUESTS = new Configurations("section.guests");
        public static MessageKey SECTION_LOCALIZATION = new Configurations("section.localization");
        public static MessageKey SECTION_LOGGING = new Configurations("section.logging");
        public static MessageKey SECTION_MAPS_DIRECTORY = new Configurations("section.mapsDirectory");
        public static MessageKey SECTION_MOBILE_APPLICATION = new Configurations("section.mobileApplication");
        public static MessageKey SECTION_NOTIFICATIONS = new Configurations("section.notifications");
        public static MessageKey SECTION_OUTBOUND_SMS = new Configurations("section.outboundSms");
        public static MessageKey SECTION_PHONES = new Configurations("section.phones");
        public static MessageKey SECTION_RESTRICTIONS = new Configurations("section.restrictions");
        public static MessageKey SECTION_USER_DATA = new Configurations("section.userData");
        public static MessageKey SET = new Configurations("set");
        public static MessageKey SKIP_PRODUCTS_VIEW = new Configurations("skipProductsView");
        public static MessageKey SKIP_TOTAL_COUNT = new Configurations("skipTotalCount");
        public static MessageKey SMALL_SCREEN_REGISTRATION_WIZARD = new Configurations("smallScreenRegistrationWizard");
        public static MessageKey SMS_ASCII_ONLY = new Configurations("smsAsciiOnly");
        public static MessageKey SMS_ENABLED = new Configurations("smsEnabled");
        public static MessageKey SMS_ENCODING = new Configurations("smsEncoding");
        public static MessageKey SMS_GATEWAY_URL = new Configurations("smsGatewayUrl");
        public static MessageKey SMS_HEADERS = new Configurations("smsHeaders");
        public static MessageKey SMS_MAX_MESSAGES_PER_MONTH = new Configurations("smsMaxMessagesPerMonth");
        public static MessageKey SMS_MAX_MESSAGES_TO_UNREGISTERED = new Configurations("smsMaxMessagesToUnregistered");
        public static MessageKey SMS_PASSWORD = new Configurations("smsPassword");
        public static MessageKey SMS_POST_BODY = new Configurations("smsPostBody");
        public static MessageKey SMS_REQUEST_TYPE = new Configurations("smsRequestType");
        public static MessageKey SMS_SCRIPT = new Configurations("smsScript");
        public static MessageKey SMS_SCRIPT_PARAMETERS = new Configurations("smsScriptParameters");
        public static MessageKey SMS_USERNAME = new Configurations("smsUsername");
        public static MessageKey SMTP_CONFIGURATION = new Configurations("smtpConfiguration");
        public static MessageKey SMTP_FROM_ADDRESS = new Configurations("smtpFromAddress");
        public static MessageKey SMTP_HOST = new Configurations("smtpHost");
        public static MessageKey SMTP_MAX_RECIPIENTS = new Configurations("smtpMaxRecipients");
        public static MessageKey SMTP_PASSWORD = new Configurations("smtpPassword");
        public static MessageKey SMTP_PORT = new Configurations("smtpPort");
        public static MessageKey SMTP_SECURITY = new Configurations("smtpSecurity");
        public static MessageKey SMTP_SECURITY_NONE = new Configurations("smtpSecurity.NONE");
        public static MessageKey SMTP_SECURITY_SSL = new Configurations("smtpSecurity.SSL");
        public static MessageKey SMTP_SECURITY_STARTTLS = new Configurations("smtpSecurity.STARTTLS");
        public static MessageKey SMTP_USER = new Configurations("smtpUser");
        public static MessageKey TAB_CHANNELS = new Configurations("tab.channels");
        public static MessageKey TASKS_LOGGING = new Configurations("tasksLogging");
        public static MessageKey TASK_LOGGING_MODE_OFF = new Configurations("taskLoggingMode.OFF");
        public static MessageKey TASK_LOGGING_MODE_REGULAR = new Configurations("taskLoggingMode.REGULAR");
        public static MessageKey TASK_LOGGING_MODE_VERBOSE = new Configurations("taskLoggingMode.VERBOSE");
        public static MessageKey THEMES_APPLIED = new Configurations("themesApplied");
        public static MessageKey TIME_FORMAT = new Configurations("timeFormat");
        public static MessageKey TIME_ZONE_ID = new Configurations("timeZoneId");
        public static MessageKey TOOLTIP_EDIT = new Configurations("tooltip.edit");
        public static MessageKey TOOLTIP_LOCK = new Configurations("tooltip.lock");
        public static MessageKey TOOLTIP_LOCKED = new Configurations("tooltip.locked");
        public static MessageKey TOOLTIP_RESET = new Configurations("tooltip.reset");
        public static MessageKey TOOLTIP_UNLOCK = new Configurations("tooltip.unlock");
        public static MessageKey URL = new Configurations("url");
        public static MessageKey USED_BY_GROUPS = new Configurations("usedByGroups");
        public static MessageKey USERNAME_LENGTH = new Configurations("usernameLength");
        public static MessageKey USERS_MENU_TYPE = new Configurations("usersMenuType");
        public static MessageKey USERS_RESULT_TYPE = new Configurations("usersResultType");
        public static MessageKey USERS_SORT_ORDER = new Configurations("usersSortOrder");
        public static MessageKey USERS_THEME = new Configurations("usersTheme");
        public static MessageKey USER_DATA_PRIVACY_ADDRESS = new Configurations("userDataPrivacy.address");
        public static MessageKey USER_DATA_PRIVACY_EMAIL = new Configurations("userDataPrivacy.email");
        public static MessageKey USER_DATA_PRIVACY_PHONE = new Configurations("userDataPrivacy.phone");
        public static MessageKey USER_FORMAT_ADD_FIELD = new Configurations("userFormat.addField");
        public static MessageKey USER_FORMAT_FIELDS = new Configurations("userFormat.fields");
        public static MessageKey USER_FORMAT_FOR_MANAGERS = new Configurations("userFormatForManagers");
        public static MessageKey USER_FORMAT_FOR_OTHERS = new Configurations("userFormatForOthers");
        public static MessageKey USER_FORMAT_SEPARATOR = new Configurations("userFormat.separator");
        public static MessageKey USER_FORMAT_WARNING = new Configurations("userFormat.warning");
        public static MessageKey USER_SEARCH_IN_MENU_MODE = new Configurations("userSearchInMenuMode");
        public static MessageKey USER_SEARCH_IN_MENU_MODE_ALL_IN_USER_SEARCH = new Configurations("userSearchInMenuMode.ALL_IN_USER_SEARCH");
        public static MessageKey USER_SEARCH_IN_MENU_MODE_NONE = new Configurations("userSearchInMenuMode.NONE");
        public static MessageKey USER_SEARCH_IN_MENU_MODE_SPECIFIC_GROUPS = new Configurations("userSearchInMenuMode.SPECIFIC_GROUPS");
        public static MessageKey USE_LEFT_SPACE_FOR_GUESTS = new Configurations("useLeftSpaceForGuests");
        public static MessageKey USE_MAP = new Configurations("useMap");
        public static MessageKey VISIBLE_AD_CATEGORIES = new Configurations("visibleAdCategories");
        public static MessageKey VISIBLE_AD_CURRENCIES = new Configurations("visibleAdCurrencies");
        public static MessageKey VISIBLE_AD_GROUPS = new Configurations("visibleAdGroups");
        public static MessageKey VOUCHER_BUYING_MENU = new Configurations("voucher.buyingMenu");

        private Configurations(String string) {
            super((Submodule)SystemSubmodule.CONFIGURATIONS, string);
        }
    }
}

