/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.imports;

import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.utils.MessageKey;

public enum AdImportField implements ImportField
{
    USER("user"),
    TITLE("title"),
    DESCRIPTION("description"),
    CATEGORIES("categories"),
    CREATION_DATE("creationdate"),
    PUBLICATION_BEGIN("publicationbegin"),
    PUBLICATION_END("publicationend"),
    PRICE("price"),
    PROMOTIONAL_PRICE("promotionalprice"),
    PROMOTIONAL_PERIOD_BEGIN("promotionalperiodbegin"),
    PROMOTIONAL_PERIOD_END("promotionalperiodend"),
    STATUS("status"),
    IMAGES("images");

    public static final String PREFIX = "AD";
    private String name = null;

    private AdImportField(String string2) {
        this.name = string2;
    }

    @Override
    public ImportType getImportType() {
        return ImportType.ADS_IMPORT;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 3: {
                return MarketplaceKeys.Advertisements.CATEGORIES;
            }
            case 7: {
                return MarketplaceKeys.Advertisements.PRICE;
            }
            case 1: {
                return MarketplaceKeys.Advertisements.NAME;
            }
            case 0: {
                return MarketplaceKeys.Advertisements.OWNER;
            }
            case 4: {
                return MarketplaceKeys.Advertisements.CREATION_DATE;
            }
            case 2: {
                return GeneralKeys.Ui.DESCRIPTION;
            }
            case 12: {
                return MarketplaceKeys.Advertisements.IMAGES;
            }
            case 9: {
                return MarketplaceKeys.Advertisements.PROMOTIONAL_PERIOD;
            }
            case 10: {
                return MarketplaceKeys.Advertisements.PROMOTIONAL_PERIOD;
            }
            case 8: {
                return MarketplaceKeys.Advertisements.PROMOTIONAL_PRICE;
            }
            case 5: {
                return MarketplaceKeys.Advertisements.PUBLICATION_PERIOD;
            }
            case 6: {
                return MarketplaceKeys.Advertisements.PUBLICATION_PERIOD;
            }
            case 11: {
                return MarketplaceKeys.Advertisements.STATUS;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String prefix() {
        return PREFIX;
    }
}

