/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.imports;

import java.util.ArrayList;
import java.util.List;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.utils.MessageKey;

public enum UserImportField implements ImportField
{
    NAME(BasicProfileField.FULL_NAME, "name", true),
    USERNAME(BasicProfileField.LOGIN_NAME, "username", true),
    EMAIL(BasicProfileField.EMAIL, "email", true),
    CREATION_DATE(null, "creationdate", true),
    PASSWORD_DEFAULT(null, null, "password", false),
    PASSWORD_VALUE(null, UserImportField.getPasswordPrefix(), "value", false),
    PASSWORD_FORCE_CHANGE(null, UserImportField.getPasswordPrefix(), "forcechange", false),
    ADDRESS_NAME(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "name", true),
    ADDRESS_LINE1(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "line1", true),
    ADDRESS_LINE2(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "line2", true),
    ADDRESS_POBOX(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "pobox", true),
    ADDRESS_NEIGHBORHOOD(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "neighborhood", true),
    ADDRESS_ZIP(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "zip", true),
    ADDRESS_CITY(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "city", true),
    ADDRESS_COUNTRY(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "country", true),
    ADDRESS_REGION(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "region", true),
    ADDRESS_PRIVATE(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "private", false),
    ADDRESS_STREET(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "street", true),
    ADDRESS_BUILDING_NUMBER(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "buildingnumber", true),
    ADDRESS_COMPLEMENT(BasicProfileField.ADDRESS, UserImportField.getAddressPrefix(), "complement", true),
    MOBILE_NAME(BasicProfileField.PHONE, UserImportField.getMobilePrefix(), "name", true),
    MOBILE_NUMBER(BasicProfileField.PHONE, UserImportField.getMobilePrefix(), "number", true),
    MOBILE_PRIVATE(BasicProfileField.PHONE, UserImportField.getMobilePrefix(), "private", false),
    LANDLINE_NAME(BasicProfileField.PHONE, UserImportField.getLandlinePrefix(), "name", true),
    LANDLINE_NUMBER(BasicProfileField.PHONE, UserImportField.getLandlinePrefix(), "number", true),
    LANDLINE_PRIVATE(BasicProfileField.PHONE, UserImportField.getLandlinePrefix(), "private", false),
    ACCOUNT_NUMBER(null, UserImportField.getAccountPrefix(), "number", false),
    ACCOUNT_CREDIT_LIMIT(null, UserImportField.getAccountPrefix(), "negativelimit", false),
    ACCOUNT_UPPER_CREDIT_LIMIT(null, UserImportField.getAccountPrefix(), "positivelimit", false),
    BROKER(null, "broker", true),
    IMAGES(BasicProfileField.IMAGE, "images", false),
    GROUP(null, "group", false);

    public static final String PREFIX = "USER";
    private final BasicProfileField profileField;
    private final String name;
    private final boolean exported;
    private String fieldPrefix;

    public static String getAccountPrefix() {
        return "account";
    }

    public static String getAddressPrefix() {
        return "address";
    }

    public static UserImportField getByName(String string) {
        UserImportField userImportField = null;
        for (UserImportField userImportField2 : UserImportField.values()) {
            if (!userImportField2.getName().equals(string)) continue;
            return userImportField2;
        }
        return userImportField;
    }

    public static List<UserImportField> getFieldsByPrefix(String string) {
        ArrayList<UserImportField> arrayList = new ArrayList<UserImportField>();
        for (UserImportField userImportField : UserImportField.values()) {
            if (!userImportField.getName().startsWith(string) || userImportField.getName().length() <= string.length()) continue;
            arrayList.add(userImportField);
        }
        return arrayList;
    }

    public static String getLandlinePrefix() {
        return "landline";
    }

    public static String getMobilePrefix() {
        return "mobile";
    }

    public static String getPasswordPrefix() {
        return "password";
    }

    private UserImportField(BasicProfileField basicProfileField, String string2, boolean bl) {
        this.profileField = basicProfileField;
        this.name = string2;
        this.exported = bl;
    }

    private UserImportField(BasicProfileField basicProfileField, String string2, String string3, boolean bl) {
        this(basicProfileField, string3, bl);
        this.fieldPrefix = string2;
    }

    public AddressFields getAddressField() {
        switch (this.ordinal()) {
            case 18: {
                return AddressFields.BUILDING_NUMBER;
            }
            case 13: {
                return AddressFields.CITY;
            }
            case 19: {
                return AddressFields.COMPLEMENT;
            }
            case 14: {
                return AddressFields.COUNTRY;
            }
            case 8: {
                return AddressFields.ADDRESS_LINE_1;
            }
            case 9: {
                return AddressFields.ADDRESS_LINE_2;
            }
            case 11: {
                return AddressFields.NEIGHBORHOOD;
            }
            case 10: {
                return AddressFields.PO_BOX;
            }
            case 15: {
                return AddressFields.REGION;
            }
            case 17: {
                return AddressFields.STREET;
            }
            case 12: {
                return AddressFields.ZIP;
            }
        }
        return null;
    }

    @Override
    public ImportType getImportType() {
        return ImportType.USERS_IMPORT;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return UsersKeys.Users.NAME;
            }
            case 1: {
                return UsersKeys.Users.USERNAME;
            }
            case 31: {
                return UsersKeys.Users.GROUP;
            }
            case 27: {
                return BankingKeys.Accounts.CREDIT_LIMIT;
            }
            case 26: {
                return BankingKeys.Accounts.ACCOUNT_NUMBER;
            }
            case 28: {
                return BankingKeys.Accounts.UPPER_CREDIT_LIMIT;
            }
            case 18: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_BUILDING_NUMBER;
            }
            case 13: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_CITY;
            }
            case 19: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_COMPLEMENT;
            }
            case 14: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_COUNTRY;
            }
            case 8: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_ADDRESS_LINE_1;
            }
            case 9: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_ADDRESS_LINE_2;
            }
            case 7: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_ADDRESS_NAME;
            }
            case 11: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_NEIGHBORHOOD;
            }
            case 10: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_PO_BOX;
            }
            case 16: {
                return GeneralKeys.Ui.FIELD_VISIBILITY;
            }
            case 15: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_REGION;
            }
            case 17: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_STREET;
            }
            case 12: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_ZIP;
            }
            case 29: {
                return UsersKeys.Users.BROKER;
            }
            case 3: {
                return UsersKeys.Users.CREATION_DATE;
            }
            case 2: {
                return UsersKeys.Users.EMAIL;
            }
            case 30: {
                return UsersKeys.Users.IMAGES;
            }
            case 23: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_LANDLINE_NAME;
            }
            case 24: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_LANDLINE_NUMBER;
            }
            case 25: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_LANDLINE_PRIVATE;
            }
            case 20: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_MOBILE_NAME;
            }
            case 21: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_MOBILE_NUMBER;
            }
            case 22: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_MOBILE_PRIVATE;
            }
            case 4: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_PASSWORD;
            }
            case 6: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_PASSWORD_FORCE_CHANGE;
            }
            case 5: {
                return SystemKeys.Imports.USER_IMPORT_FIELDS_PASSWORD_VALUE;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.fieldPrefix == null ? this.name : this.fieldPrefix + "." + this.name;
    }

    public PhoneNature getPhoneNature() {
        switch (this.ordinal()) {
            case 20: 
            case 21: 
            case 22: {
                return PhoneNature.MOBILE;
            }
            case 23: 
            case 24: 
            case 25: {
                return PhoneNature.LANDLINE;
            }
        }
        return null;
    }

    public String getPrefix() {
        return this.fieldPrefix;
    }

    public BasicProfileField getProfileField() {
        return this.profileField;
    }

    public String getSimpleName() {
        return this.name;
    }

    public boolean isExported() {
        return this.exported;
    }

    public String prefix() {
        return PREFIX;
    }
}

