/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.languages;

public enum BuiltinLanguage {
    AF("Afrikaans", "af", null, null),
    AR("\u0627\u0644\u0639\u0631\u0628\u064a\u0629 (Arabic)", "ar", null, "arabic"),
    EU("Basque (Basque)", "eu", null, "basque"),
    CA("Catal\u00e0 (Catalan)", "ca", null, "catalan"),
    ZH("\u4e2d\u56fd\u7684 (Chinese)", "zh", null, "cjk"),
    CS("\u010de\u0161tina (Czech)", "cs", null, null),
    ET("Eesti (Estonian)", "et", null, null),
    DE("Deutsch (German)", "de", null, "german"),
    DE_CH("Deutsch (German-Swiss)", "de", "CH", "german"),
    EL("\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac (Greek)", "el", null, "greek"),
    IW("\u05e2\u05d1\u05e8\u05d9\u05ea (Hebrew)", "iw", null, null),
    HU("Magyar (Hungarian)", "hu", null, "hungarian"),
    IN("Bahasa Indonesia (Indonesian)", "in", null, "indonesian"),
    IT("Italiano (Italian)", "it", null, "italian"),
    JA("\u65e5\u672c\u4eba (Japanese)", "ja", null, "cjk"),
    LT("Lietuvi\u0173 (Lithuanian)", "lt", null, "lithuanian"),
    MS("Bahasa Melayu (Malay)", "ms", null, null),
    NO("Norsk (Norwegian)", "no", null, "norwegian"),
    PL("Polski (Polish)", "pl", null, null),
    PT("Portugu\u00eas (Portuguese)", "pt", null, "portuguese"),
    RO("rom\u00e2n\u0103 (Romanian)", "ro", null, "romanian"),
    RU("P\u0443\u0441\u0441\u043a\u0438\u0439 (Russian)", "ru", null, "russian"),
    SK("Sloven\u010dina (Slovak)", "sk", null, null),
    SR("\u0441\u0440\u043f\u0441\u043a\u0438 (Serbian)", "sr", null, null),
    SL("Sloven\u0161\u010dina (Slovenian)", "sl", null, null),
    FR("Fran\u00e7ais (French)", "fr", null, "french"),
    NL("Nederlands (Dutch)", "nl", null, "dutch"),
    PT_BR("Portugu\u00eas do Brasil (Brazilian Portuguese)", "pt", "BR", "brazilian"),
    ES("Espa\u00f1ol (Spanish)", "es", null, "spanish"),
    SW("Swahili (Swahili)", "sw", null, "swahili"),
    TH("\u0e44\u0e17\u0e22 (Thai)", "th", null, "thai"),
    UK("\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430 (Ukrainian)", "uk", null, null),
    TR("T\u00fcrk\u00e7e (Turkish)", "tr", null, "turkish"),
    VI("Ti\u1ebfng Vi\u1ec7t (Vietnamese)", "vi", null, null),
    EN("English", "en", null, "english");

    private final String displayName;
    private final String isoLanguage;
    private final String isoCountry;
    private final String openSearchAnalyzer;

    private BuiltinLanguage(String string2, String string3, String string4, String string5) {
        this.displayName = string2;
        this.isoLanguage = string3;
        this.isoCountry = string4;
        this.openSearchAnalyzer = string5;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIsoCountry() {
        return this.isoCountry;
    }

    public String getIsoLanguage() {
        return this.isoLanguage;
    }

    public String getLocale() {
        return this.getLocale('_');
    }

    public String getLocale(char c) {
        return this.isoCountry == null ? this.isoLanguage : this.isoLanguage + c + this.isoCountry;
    }

    public String getOpenSearchAnalyzer() {
        return this.openSearchAnalyzer;
    }

    public boolean isCjk() {
        return this == ZH || this == JA;
    }

    public String toString() {
        return this.name() + " " + this.displayName;
    }
}

