/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.languages;

import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;

public enum TimeFormat implements HasMessageKey
{
    H24("HH:mm"),
    H12("hh:mm a");

    private final String pattern;

    public static String format(DateTime dateTime, String string) {
        int n = dateTime.getHours();
        boolean bl = string.contains("hh");
        if (bl) {
            String string2;
            String string3 = string2 = n >= 12 ? "PM" : "AM";
            if (n == 0) {
                n = 12;
            } else if (n > 12) {
                n -= 12;
            }
            string = string.replace("hh", StringHelper.leftPad((String)String.valueOf(n), (int)2, (char)'0'));
            string = string.replace("a", string2);
        } else {
            string = string.replace("HH", StringHelper.leftPad((String)String.valueOf(n), (int)2, (char)'0'));
        }
        string = string.replace("mm", StringHelper.leftPad((String)String.valueOf(dateTime.getMinutes()), (int)2, (char)'0'));
        string = string.replace("ss", StringHelper.leftPad((String)String.valueOf(dateTime.getSeconds()), (int)2, (char)'0'));
        string = string.replace("SSS", StringHelper.leftPad((String)String.valueOf(dateTime.getMilliseconds()), (int)3, (char)'0'));
        return string;
    }

    private TimeFormat(String string2) {
        this.pattern = string2;
    }

    public String format(DateTime dateTime) {
        return TimeFormat.format(dateTime, this.getPattern());
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.Languages.TIME_FORMAT_H_24;
            }
            case 1: {
                return SystemKeys.Languages.TIME_FORMAT_H_12;
            }
        }
        return null;
    }

    public String getPattern() {
        return this.pattern;
    }
}

