/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.cyclos.model.system.monitor.ApplicationProperty;
import org.cyclos.model.system.monitor.ServerData;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;

public class ServerDataPropertiesDiff {
    private Map<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();
    private Map<String, SortedSet<ApplicationProperty>> modifiedPropertiesByServer = new HashMap<String, SortedSet<ApplicationProperty>>();
    private List<String> modifiedPropertyNames = new ArrayList<String>();
    private List<ApplicationProperty> commonProperties;
    private List<ServerData> servers;
    private boolean isSameClusterConfigurationForAllMembers;

    public ServerDataPropertiesDiff(List<ServerData> list) {
        if (CollectionHelper.isEmpty(list)) {
            this.servers = Collections.emptyList();
            this.commonProperties = Collections.emptyList();
            return;
        }
        this.servers = list.stream().filter(serverData -> StringHelper.isBlank((Object)serverData.getErrorMessage())).collect(Collectors.toList());
        this.addProperties();
        this.calcDifferences();
        this.isSameClusterConfigurationForAllMembers = this.calcClusterConfigurationForAllMembers();
    }

    public boolean areAllPropertiesCommon() {
        return this.modifiedPropertiesByServer.isEmpty();
    }

    public List<ApplicationProperty> getCommonProperties() {
        return this.commonProperties;
    }

    public ServerData getFirstMember() {
        return this.servers.isEmpty() ? null : this.servers.get(0);
    }

    public Collection<ApplicationProperty> getModifiedProperties(String string) {
        return this.modifiedPropertiesByServer.containsKey(string) ? (Collection)this.modifiedPropertiesByServer.get(string) : Collections.emptyList();
    }

    public boolean isSameClusterConfigurationForAllMembers() {
        return this.isSameClusterConfigurationForAllMembers;
    }

    public String toString() {
        return "modified = " + this.modifiedPropertiesByServer.toString() + ", common = " + String.valueOf(this.commonProperties);
    }

    private void addModifiedProperty(Pair<String, String> pair, PropertyInfo propertyInfo) {
        this.modifiedPropertyNames.add(propertyInfo.getPropertyName());
        SortedSet<ApplicationProperty> sortedSet = this.modifiedPropertiesByServer.get(pair.getFirst());
        if (sortedSet == null) {
            sortedSet = new TreeSet<ApplicationProperty>(Comparator.comparing(ApplicationProperty::getName));
            this.modifiedPropertiesByServer.put((String)pair.getFirst(), sortedSet);
        }
        sortedSet.add(this.toApplicationProperty(propertyInfo.getPropertyName(), (String)pair.getSecond()));
    }

    private void addProperties() {
        this.servers.stream().forEach(serverData -> serverData.getApplicationProperties().forEach(applicationProperty -> this.addProperty((ApplicationProperty)((Object)((Object)applicationProperty)), serverData.getMemberName())));
    }

    private int addProperty(ApplicationProperty applicationProperty, String string) {
        PropertyInfo propertyInfo = this.properties.get(applicationProperty.getName());
        if (propertyInfo == null) {
            propertyInfo = new PropertyInfo(string, applicationProperty.getName(), applicationProperty.getValue());
            this.properties.put(applicationProperty.getName(), propertyInfo);
        }
        return propertyInfo.addServer(string, applicationProperty.getValue());
    }

    private boolean calcClusterConfigurationForAllMembers() {
        return this.servers.stream().map(ServerData::getClusterConfiguration).collect(Collectors.toSet()).size() == 1;
    }

    private void calcDifferences() {
        this.properties.values().stream().filter(propertyInfo -> !propertyInfo.isCommon() || propertyInfo.getNumberOfServers() != this.servers.size()).forEach(propertyInfo -> propertyInfo.getServers().forEach(pair -> this.addModifiedProperty((Pair<String, String>)pair, (PropertyInfo)propertyInfo)));
        this.commonProperties = this.modifiedPropertyNames.isEmpty() ? (this.servers.isEmpty() ? Collections.emptyList() : this.servers.get(0).getApplicationProperties()) : this.properties.values().stream().filter(propertyInfo -> !this.modifiedPropertyNames.contains(propertyInfo.getPropertyName())).sorted(Comparator.comparing(PropertyInfo::getPropertyName)).map(this::toApplicationProperty).collect(Collectors.toList());
    }

    private ApplicationProperty toApplicationProperty(PropertyInfo propertyInfo) {
        return this.toApplicationProperty(propertyInfo.getPropertyName(), propertyInfo.findAnyPropertyValue());
    }

    private ApplicationProperty toApplicationProperty(String string, String string2) {
        ApplicationProperty applicationProperty = new ApplicationProperty();
        applicationProperty.setName(string);
        applicationProperty.setValue(string2);
        return applicationProperty;
    }

    private static class PropertyInfo {
        private String propertyName;
        private Set<Pair<String, String>> servers = new HashSet<Pair<String, String>>();
        private boolean isCommon = true;

        public PropertyInfo(String string, String string2, String string3) {
            this.propertyName = string2;
            this.addServer(string, string3);
        }

        public int addServer(String string, String string2) {
            this.servers.add((Pair<String, String>)Pair.create((Object)string, (Object)string2));
            this.isCommon = this.isCommon && !this.servers.stream().filter(pair -> !((String)pair.getFirst()).equals(string)).anyMatch(pair -> !((String)pair.getSecond()).equals(string2));
            return this.servers.size();
        }

        public String findAnyPropertyValue() {
            return this.servers.isEmpty() ? null : (String)this.servers.iterator().next().getSecond();
        }

        public int getNumberOfServers() {
            return this.servers.size();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Set<Pair<String, String>> getServers() {
            return this.servers;
        }

        public boolean isCommon() {
            return this.isCommon;
        }
    }
}

