/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.operations;

import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum CustomOperationResultType implements HasMessageKey
{
    NOTIFICATION,
    PLAIN_TEXT,
    RICH_TEXT,
    FILE_DOWNLOAD,
    EXTERNAL_REDIRECT,
    URL,
    RESULT_PAGE,
    BULK_ACTION;


    public boolean allowSubmitWithQrCodeScan() {
        return this.isString() || this == FILE_DOWNLOAD;
    }

    public boolean canRunOnEntityPage() {
        switch (this.ordinal()) {
            case 0: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.Operations.RESULT_TYPE_NOTIFICATION;
            }
            case 1: {
                return SystemKeys.Operations.RESULT_TYPE_PLAIN_TEXT;
            }
            case 2: {
                return SystemKeys.Operations.RESULT_TYPE_RICH_TEXT;
            }
            case 3: {
                return SystemKeys.Operations.RESULT_TYPE_FILE_DOWNLOAD;
            }
            case 4: {
                return SystemKeys.Operations.RESULT_TYPE_EXTERNAL_REDIRECT;
            }
            case 5: {
                return SystemKeys.Operations.RESULT_TYPE_URL;
            }
            case 6: {
                return SystemKeys.Operations.RESULT_TYPE_RESULT_PAGE;
            }
            case 7: {
                return SystemKeys.Operations.RESULT_TYPE_BULK_ACTION;
            }
        }
        return null;
    }

    public boolean isContent() {
        return this == PLAIN_TEXT || this == RICH_TEXT;
    }

    public boolean isPage() {
        return this == RESULT_PAGE;
    }

    public boolean isString() {
        return this == NOTIFICATION || this == PLAIN_TEXT || this == RICH_TEXT || this == EXTERNAL_REDIRECT || this == URL;
    }

    public boolean isUrl() {
        return this == URL || this == EXTERNAL_REDIRECT;
    }

    public boolean supportActions() {
        return this == PLAIN_TEXT || this == RICH_TEXT || this == RESULT_PAGE;
    }
}

