/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.users.products;

import org.cyclos.model.access.Role;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum ProductNature implements HasMessageKey
{
    ADMIN(Role.ADMIN),
    MEMBER(Role.MEMBER),
    BROKER(Role.BROKER);

    private final Role role;

    public static ProductNature fromRole(Role role) {
        for (ProductNature productNature : ProductNature.values()) {
            if (productNature.role != role) continue;
            return productNature;
        }
        return null;
    }

    private ProductNature(Role role) {
        this.role = role;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return UsersKeys.Products.NATURE_ADMIN;
            }
            case 1: {
                return UsersKeys.Products.NATURE_MEMBER;
            }
            case 2: {
                return UsersKeys.Products.NATURE_BROKER;
            }
        }
        return null;
    }

    public Role getRole() {
        return this.role;
    }
}

