/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.users.references;

import org.cyclos.model.users.UsersKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum ReferenceLevel implements HasMessageKey
{
    VERY_GOOD(5),
    GOOD(4),
    NEUTRAL(3),
    BAD(2),
    VERY_BAD(1),
    NA(0);

    private final int points;

    public static ReferenceLevel getByScore(float f) {
        if (f == 0.0f) {
            return NA;
        }
        if (f <= 1.0f) {
            return VERY_BAD;
        }
        if (f <= 2.0f) {
            return BAD;
        }
        if (f <= 3.0f) {
            return NEUTRAL;
        }
        if (f <= 4.0f) {
            return GOOD;
        }
        return VERY_GOOD;
    }

    private ReferenceLevel(int n2) {
        this.points = n2;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return UsersKeys.References.LEVEL_VERY_GOOD;
            }
            case 1: {
                return UsersKeys.References.LEVEL_GOOD;
            }
            case 2: {
                return UsersKeys.References.LEVEL_NEUTRAL;
            }
            case 3: {
                return UsersKeys.References.LEVEL_BAD;
            }
            case 4: {
                return UsersKeys.References.LEVEL_VERY_BAD;
            }
            case 5: {
                return UsersKeys.References.LEVEL_NA;
            }
        }
        return null;
    }

    public int getPoints() {
        return this.points;
    }

    public boolean isNegative() {
        return this == VERY_BAD || this == BAD;
    }

    public boolean isPositive() {
        return this == VERY_GOOD || this == GOOD;
    }
}

