/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.users.users;

import org.cyclos.model.users.UsersKeys;
import org.cyclos.utils.EnumMessageKeyResolver;

public enum RegistrationStatus {
    ACTIVE,
    INACTIVE,
    EMAIL_VALIDATION;

    private static EnumMessageKeyResolver<RegistrationStatus> resolverForOperator;
    private static EnumMessageKeyResolver<RegistrationStatus> resolverForInternalRegistration;
    private static EnumMessageKeyResolver<RegistrationStatus> resolverForPublicRegistration;

    public static EnumMessageKeyResolver<RegistrationStatus> resolverForInternalRegistration() {
        if (resolverForInternalRegistration == null) {
            resolverForInternalRegistration = registrationStatus -> {
                switch (registrationStatus.ordinal()) {
                    case 0: {
                        return UsersKeys.Users.USER_REGISTRATION_CREATED_ACTIVE;
                    }
                    case 2: {
                        return UsersKeys.Users.USER_REGISTRATION_CREATED_EMAIL_VALIDATION;
                    }
                    case 1: {
                        return UsersKeys.Users.USER_REGISTRATION_CREATED_INACTIVE;
                    }
                }
                return null;
            };
        }
        return resolverForInternalRegistration;
    }

    public static EnumMessageKeyResolver<RegistrationStatus> resolverForOperator() {
        if (resolverForOperator == null) {
            resolverForOperator = registrationStatus -> {
                switch (registrationStatus.ordinal()) {
                    case 0: {
                        return UsersKeys.Operators.REGISTERED_ACTIVE;
                    }
                    case 2: {
                        return UsersKeys.Operators.REGISTERED_EMAIL_VALIDATION;
                    }
                    case 1: {
                        return null;
                    }
                }
                return null;
            };
        }
        return resolverForOperator;
    }

    public static EnumMessageKeyResolver<RegistrationStatus> resolverForPublicRegistration() {
        if (resolverForPublicRegistration == null) {
            resolverForPublicRegistration = registrationStatus -> {
                switch (registrationStatus.ordinal()) {
                    case 2: {
                        return UsersKeys.Users.PUBLIC_REGISTRATION_CREATED_EMAIL_VALIDATION;
                    }
                    case 1: {
                        return UsersKeys.Users.PUBLIC_REGISTRATION_CREATED_INACTIVE;
                    }
                    case 0: {
                        return null;
                    }
                }
                return null;
            };
        }
        return resolverForPublicRegistration;
    }
}

