/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.access.LoginException;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.StringHelper;

public class AuthorizationData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String scheme;
    private String value;
    private String principal;
    private String password;

    @GwtIncompatible
    public static AuthorizationData of(Function<String, String> function) {
        String string = function.apply("Authorization");
        if (StringHelper.isBlank((Object)string)) {
            string = function.apply("X-Authorization");
        }
        return AuthorizationData.of(string);
    }

    @GwtIncompatible
    public static AuthorizationData of(String string) {
        String string2;
        if ((string = StringHelper.trimToNull((Object)string)) == null) {
            return null;
        }
        String[] stringArray = StringUtils.split((String)string, (String)" ", (int)2);
        String string3 = stringArray[0].toLowerCase();
        String string4 = string2 = stringArray.length == 1 ? null : StringHelper.trimToNull((Object)stringArray[1]);
        if (string2 == null) {
            throw new LoginException("No Authorization value provided");
        }
        switch (string3) {
            case "basic": {
                String string5;
                try {
                    byte[] byArray = Base64.getDecoder().decode(string2.getBytes(StandardCharsets.UTF_8));
                    string5 = new String(byArray, StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new LoginException("Invalid Authorization Basic value");
                }
                string5 = StringHelper.removeStart((String)string5, (String)"username:");
                int n = string5.indexOf(58);
                String string6 = StringHelper.trimToNull((Object)(n < 0 ? string5 : string5.substring(0, n)));
                String string7 = StringHelper.trimToNull(n < 0 ? null : string5.substring(n + 1));
                return new AuthorizationData(string3, string2, string6, string7);
            }
        }
        return new AuthorizationData(string3, string2);
    }

    public AuthorizationData(String string, String string2) {
        this.scheme = string;
        this.value = string2;
    }

    public AuthorizationData(String string, String string2, String string3, String string4) {
        this(string, string2);
        this.principal = string3;
        this.password = string4;
    }

    protected AuthorizationData() {
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isBasic() {
        return "basic".equals(this.scheme);
    }

    public boolean isBearer() {
        return "bearer".equals(this.scheme);
    }

    public boolean isValid() {
        return this.isBasic() && StringHelper.isNotBlank((Object)this.principal) && StringHelper.isNotBlank((Object)this.password) || this.isBearer() && StringHelper.isNotBlank((Object)this.value);
    }
}

