/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import org.cyclos.model.EntityVO;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.devices.DeviceConfirmationField;
import org.cyclos.model.access.devices.DeviceConfirmationType;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.utils.ModelHelper;

public class DeviceConfirmationParamsBuilder {
    private CreateDeviceConfirmationParams params;

    public static DeviceConfirmationParamsBuilder builder(DeviceConfirmationType deviceConfirmationType) {
        return new DeviceConfirmationParamsBuilder(deviceConfirmationType);
    }

    private DeviceConfirmationParamsBuilder(DeviceConfirmationType deviceConfirmationType) {
        this.params = new CreateDeviceConfirmationParams(CreateDeviceConfirmationParams.TYPE, deviceConfirmationType);
        this.params.setFields(new HashMap<String, String>());
    }

    public CreateDeviceConfirmationParams build() {
        return this.params;
    }

    public DeviceConfirmationParamsBuilder field(DeviceConfirmationField deviceConfirmationField, BigDecimal bigDecimal) {
        this.params.getFields().put(deviceConfirmationField.inputFieldName(), bigDecimal == null ? "" : bigDecimal.toPlainString());
        return this;
    }

    public DeviceConfirmationParamsBuilder field(DeviceConfirmationField deviceConfirmationField, EntityVO entityVO) {
        this.params.getFields().put(deviceConfirmationField.inputFieldName(), entityVO == null ? "" : ModelHelper.stringOrIdFromVO(entityVO, true));
        return this;
    }

    public DeviceConfirmationParamsBuilder field(DeviceConfirmationField deviceConfirmationField, Enum<?> enum_) {
        this.params.getFields().put(deviceConfirmationField.inputFieldName(), enum_ == null ? "" : enum_.name());
        return this;
    }

    public DeviceConfirmationParamsBuilder field(DeviceConfirmationField deviceConfirmationField, Integer n) {
        this.params.getFields().put(deviceConfirmationField.inputFieldName(), n == null ? "" : n.toString());
        return this;
    }

    public DeviceConfirmationParamsBuilder field(DeviceConfirmationField deviceConfirmationField, InternalAccountOwner internalAccountOwner) {
        this.params.getFields().put(deviceConfirmationField.inputFieldName(), internalAccountOwner == null ? "" : ModelHelper.identifier((AccountOwner)internalAccountOwner, true));
        return this;
    }

    public DeviceConfirmationParamsBuilder field(DeviceConfirmationField deviceConfirmationField, String string) {
        this.params.getFields().put(deviceConfirmationField.inputFieldName(), string == null ? "" : string);
        return this;
    }
}

