/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum FileMimeType implements HasMessageKey
{
    TEXT("text/plain"),
    HTML("text/html"),
    PDF("application/pdf"),
    RTF("application/rtf", "text/richtext"),
    MS_WORD("application/msword", "application/mswrite", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
    MS_EXCEL("application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
    MS_POWERPOINT("application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow"),
    OD_TEXT("application/vnd.oasis.opendocument.text"),
    OD_SPREADSHEET("application/vnd.oasis.opendocument.spreadsheet"),
    OD_PRESENTATION("application/vnd.oasis.opendocument.presentation"),
    IMAGE("image/gif", "image/jpeg", "image/pjpeg", "image/png", "image/x-png", "image/bmp", "image/webp", "image/svg+xml"),
    AUDIO("audio/mpeg", "audio/mpeg3", "audio/mp3", "audio/x-mpeg-3", "audio/x-wav", "audio/wav", "audio/x-aiff", "audio/aiff", "audio/x-midi", "audio/midi", "audio/ogg", "audio/flac", "audio/webm"),
    VIDEO("video/mpeg", "video/quicktime", "video/x-msvideo", "video/msvideo", "video/ogg", "video/webm"),
    OTHERS(new String[0]);

    private final List<String> mimeTypes;

    public static FileMimeType of(String string) {
        for (FileMimeType fileMimeType : FileMimeType.values()) {
            if (!fileMimeType.getMimeTypes().contains(string)) continue;
            return fileMimeType;
        }
        return null;
    }

    private FileMimeType(String ... stringArray) {
        this.mimeTypes = Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return GeneralKeys.Ui.MIME_TYPE_TEXT;
            }
            case 1: {
                return GeneralKeys.Ui.MIME_TYPE_HTML;
            }
            case 2: {
                return GeneralKeys.Ui.MIME_TYPE_PDF;
            }
            case 3: {
                return GeneralKeys.Ui.MIME_TYPE_RTF;
            }
            case 4: {
                return GeneralKeys.Ui.MIME_TYPE_MS_WORD;
            }
            case 5: {
                return GeneralKeys.Ui.MIME_TYPE_MS_EXCEL;
            }
            case 6: {
                return GeneralKeys.Ui.MIME_TYPE_MS_POWERPOINT;
            }
            case 7: {
                return GeneralKeys.Ui.MIME_TYPE_OD_TEXT;
            }
            case 8: {
                return GeneralKeys.Ui.MIME_TYPE_OD_SPREADSHEET;
            }
            case 9: {
                return GeneralKeys.Ui.MIME_TYPE_OD_PRESENTATION;
            }
            case 10: {
                return GeneralKeys.Ui.MIME_TYPE_IMAGE;
            }
            case 11: {
                return GeneralKeys.Ui.MIME_TYPE_AUDIO;
            }
            case 12: {
                return GeneralKeys.Ui.MIME_TYPE_VIDEO;
            }
            case 13: {
                return GeneralKeys.Ui.MIME_TYPE_OTHER;
            }
        }
        return null;
    }

    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }
}

