/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.math.BigDecimal;
import java.util.Arrays;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.utils.FileSizeDTO;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Pair;

public enum FileSizeUnit implements HasMessageKey
{
    B,
    K,
    M,
    G;


    public static FileSizeDTO nearestFileSize(long l) {
        Pair<Number, FileSizeUnit> pair = FileSizeUnit.nearestFileSize(l, true);
        if (pair == null) {
            return null;
        }
        FileSizeDTO fileSizeDTO = new FileSizeDTO();
        fileSizeDTO.setSize((Integer)pair.getFirst());
        fileSizeDTO.setUnit((FileSizeUnit)pair.getSecond());
        return fileSizeDTO;
    }

    public static Pair<Number, FileSizeUnit> nearestFileSize(long l, boolean bl) {
        if (l == 0L) {
            return Pair.create((Object)0, (Object)B);
        }
        for (FileSizeUnit fileSizeUnit : Arrays.asList(G, M, K, B)) {
            int n = fileSizeUnit.getBytes();
            if (l > (long)n) {
                FileSizeDTO fileSizeDTO = new FileSizeDTO();
                fileSizeDTO.setSize((int)(l / (long)n));
                fileSizeDTO.setUnit(fileSizeUnit);
                return Pair.create((Object)(bl ? Integer.valueOf((int)(l / (long)n)) : BigDecimalHelper.round((BigDecimal)new BigDecimal(l).setScale(BigDecimalHelper.MAX_SCALE).divide(new BigDecimal(n)), (int)2)), (Object)fileSizeUnit);
            }
            if (l != (long)n) continue;
            return Pair.create((Object)1, (Object)fileSizeUnit);
        }
        return null;
    }

    public int getBytes() {
        switch (this.ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1024;
            }
            case 2: {
                return 0x100000;
            }
            case 3: {
                return 0x40000000;
            }
        }
        return 0;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return GeneralKeys.Ui.FILE_SIZE_B;
            }
            case 1: {
                return GeneralKeys.Ui.FILE_SIZE_K;
            }
            case 2: {
                return GeneralKeys.Ui.FILE_SIZE_M;
            }
            case 3: {
                return GeneralKeys.Ui.FILE_SIZE_G;
            }
        }
        return null;
    }
}

