/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.math.BigDecimal;
import org.cyclos.model.utils.TimeField;

public interface ITimeInterval
extends Comparable<ITimeInterval> {
    public static boolean isValid(ITimeInterval iTimeInterval) {
        return iTimeInterval != null && iTimeInterval.isValid();
    }

    @Override
    default public int compareTo(ITimeInterval iTimeInterval) {
        if (!this.isValid()) {
            return iTimeInterval == null || !iTimeInterval.isValid() ? 0 : 1;
        }
        if (iTimeInterval == null || !iTimeInterval.isValid()) {
            return -1;
        }
        return Long.compare(this.getMilliseconds(), iTimeInterval.getMilliseconds());
    }

    public Integer getAmount();

    public TimeField getField();

    default public long getMilliseconds() {
        if (!this.isValid()) {
            return 0L;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getAmount());
        BigDecimal bigDecimal2 = new BigDecimal(this.getField().getMilliseconds());
        try {
            return bigDecimal.multiply(bigDecimal2).longValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            return Long.MAX_VALUE;
        }
    }

    default public boolean isValid() {
        Integer n = this.getAmount();
        return n != null && this.getField() != null;
    }
}

