/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.Bean;
import org.cyclos.model.ConfigurationEntityVO;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.Property;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.clients.AccessClientLocatorVO;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.InstallmentLocatorVO;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.marketplace.advertisements.AdWebShopVO;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.webshoporders.OrderVO;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.operators.OperatorWithFieldsVO;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.users.users.BaseUserRegistrationResult;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.RegistrationStatus;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserPrincipalData;
import org.cyclos.model.users.users.UserRegistrationResult;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserValidationResult;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.utils.AmountSummaryVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.CurrencyAmountRangeDTO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.DimensionsDTO;
import org.cyclos.model.utils.DistanceDTO;
import org.cyclos.model.utils.FileMimeType;
import org.cyclos.model.utils.FileSizeDTO;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.LatLongDTO;
import org.cyclos.model.utils.Range;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.MessageProducer;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;

public class ModelHelper {
    public static final int MAX_NAME_LENGTH = 100;
    public static final int MAX_INTERNAL_NAME_LENGTH = 50;
    public static final int MAX_STRING_LENGTH = 250;
    public static final int MAX_REGEX_LENGTH = 500;
    private static final BigDecimal MIN_LATITUDE = new BigDecimal(-90);
    private static final BigDecimal MAX_LATITUDE = new BigDecimal(90);
    private static final BigDecimal MIN_LONGITUDE = new BigDecimal(-180);
    private static final BigDecimal MAX_LONGITUDE = new BigDecimal(180);
    private static final Comparator<UserLocatorVO> USER_LOCATOR_COMPARATOR = (userLocatorVO, userLocatorVO2) -> {
        Long l;
        if (userLocatorVO != null && userLocatorVO2 == null) {
            return -1;
        }
        if (userLocatorVO == null && userLocatorVO2 != null) {
            return 1;
        }
        if (userLocatorVO == null && userLocatorVO2 == null) {
            return 0;
        }
        Long l2 = userLocatorVO == null ? null : userLocatorVO.getId();
        Long l3 = l = userLocatorVO2 == null ? null : userLocatorVO2.getId();
        if (l2 != null && l == null) {
            return -1;
        }
        if (l != null && l2 == null) {
            return 1;
        }
        if (l != null && l2 != null) {
            return l2.compareTo(l);
        }
        String string = StringHelper.isNotBlank((Object)userLocatorVO.getUsername()) ? ExistingBuiltInPrincipalType.USERNAME.getInternalName() : userLocatorVO.getPrincipalType();
        String string2 = StringHelper.isNotBlank((Object)userLocatorVO2.getUsername()) ? ExistingBuiltInPrincipalType.USERNAME.getInternalName() : userLocatorVO2.getPrincipalType();
        String string3 = string + "\n" + (String)ObjectHelper.defaultValue((Object)userLocatorVO.getUsername(), (Object)userLocatorVO.getPrincipal());
        String string4 = string2 + "\n" + (String)ObjectHelper.defaultValue((Object)userLocatorVO2.getUsername(), (Object)userLocatorVO2.getPrincipal());
        return string3.compareTo(string4);
    };
    public static final String LOCATOR_QUOTE = "'";
    public static final String STRING_FROM_VO_ATTR = "stringFromVO";

    @GwtIncompatible
    public static InternalAccountOwner accountOwner(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        if ("SYSTEM".equalsIgnoreCase(string)) {
            return SystemAccountOwner.instance();
        }
        return (InternalAccountOwner)ModelHelper.voFromString(UserLocatorVO.class, string);
    }

    public static AmountSummaryVO amountSummary(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, CurrencyVO currencyVO) {
        AmountSummaryVO amountSummaryVO = new AmountSummaryVO();
        amountSummaryVO.setSum(BigDecimalHelper.round((BigDecimal)bigDecimal, (int)currencyVO.getPrecision()));
        amountSummaryVO.setAverage(BigDecimalHelper.round((BigDecimal)bigDecimal2, (int)currencyVO.getPrecision()));
        amountSummaryVO.setCount(n);
        amountSummaryVO.setCurrency(currencyVO);
        return amountSummaryVO;
    }

    public static ChannelVO channel(String string) {
        if ((string = StringHelper.trimToNull((Object)string)) == null) {
            return null;
        }
        ChannelVO channelVO = new ChannelVO();
        channelVO.setInternalName(string);
        return channelVO;
    }

    public static void clearIds(Iterable<? extends EntityModel> iterable) {
        if (iterable != null) {
            for (EntityModel entityModel : iterable) {
                entityModel.setId(null);
            }
        }
    }

    public static <S extends Bean, T extends Bean> void copyProperties(S s, T t) {
        if (s == null || t == null) {
            throw new IllegalArgumentException("Can't copy from source to target. Both observables must be not null");
        }
        for (Map.Entry entry : s.propertyMap().entrySet()) {
            String string = (String)entry.getKey();
            Property property = (Property)entry.getValue();
            Property property2 = (Property)t.propertyMap().get(string);
            if (property2 == null || !property2.getType().equals(property.getType())) continue;
            Object object = s.get(property);
            t.set(property2, object);
        }
    }

    public static CurrencyAmountDTO currencyAmount(CurrencyVO currencyVO, BigDecimal bigDecimal) {
        if (currencyVO != null && bigDecimal != null) {
            bigDecimal = BigDecimalHelper.round((BigDecimal)bigDecimal, (int)currencyVO.getPrecision());
        }
        CurrencyAmountDTO currencyAmountDTO = new CurrencyAmountDTO();
        currencyAmountDTO.setCurrency(currencyVO);
        currencyAmountDTO.setAmount(bigDecimal);
        return currencyAmountDTO;
    }

    public static CurrencyAmountRangeDTO currencyRange(CurrencyVO currencyVO, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        CurrencyAmountRangeDTO currencyAmountRangeDTO = new CurrencyAmountRangeDTO();
        currencyAmountRangeDTO.setCurrency(currencyVO);
        currencyAmountRangeDTO.setMin(bigDecimal);
        currencyAmountRangeDTO.setMax(bigDecimal2);
        return currencyAmountRangeDTO;
    }

    public static DatePeriodDTO datePeriod(DateTime dateTime, DateTime dateTime2) {
        DatePeriodDTO datePeriodDTO = new DatePeriodDTO();
        datePeriodDTO.setBegin(dateTime);
        datePeriodDTO.setEnd(dateTime2);
        return datePeriodDTO;
    }

    public static DecimalRangeDTO decimalRange(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        DecimalRangeDTO decimalRangeDTO = new DecimalRangeDTO();
        decimalRangeDTO.setMin(bigDecimal);
        decimalRangeDTO.setMax(bigDecimal2);
        return decimalRangeDTO;
    }

    public static DimensionsDTO dimensions(int n, int n2) {
        DimensionsDTO dimensionsDTO = new DimensionsDTO();
        dimensionsDTO.setWidth(n);
        dimensionsDTO.setHeight(n2);
        return dimensionsDTO;
    }

    public static AmountSummaryVO emptyAmountSummary(CurrencyVO currencyVO) {
        return ModelHelper.amountSummary(BigDecimal.ZERO, BigDecimal.ZERO, 0, currencyVO);
    }

    public static boolean equals(LatLongDTO latLongDTO, LatLongDTO latLongDTO2) {
        return latLongDTO != null && latLongDTO2 != null && BigDecimalHelper.areEquals((BigDecimal)latLongDTO.getLatitude(), (BigDecimal)latLongDTO2.getLatitude()) && BigDecimalHelper.areEquals((BigDecimal)latLongDTO.getLongitude(), (BigDecimal)latLongDTO2.getLongitude());
    }

    public static String escapeIdentifierIfNeeded(String string) {
        try {
            Long.parseLong(string);
            return LOCATOR_QUOTE + string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getActualInternalNameOrId(EntityVO entityVO) {
        String string;
        if (entityVO == null) {
            return null;
        }
        if (entityVO instanceof IInternalNamedEntity && StringHelper.isNotBlank((Object)(string = ((IInternalNamedEntity)entityVO).getInternalName()))) {
            return string;
        }
        return StringHelper.trimToNull((Object)entityVO.getId());
    }

    public static Set<String> getAllowedMimeTypes(Collection<FileMimeType> collection, Collection<String> collection2) {
        collection = CollectionHelper.orEmpty(collection);
        TreeSet<String> treeSet = new TreeSet<String>();
        collection.stream().flatMap(fileMimeType -> fileMimeType.getMimeTypes().stream()).forEach(treeSet::add);
        if (collection.contains(FileMimeType.OTHERS) && collection2 != null) {
            treeSet.addAll(collection2);
        }
        return treeSet;
    }

    public static String getEmailValidationMesssage(UserValidationResult userValidationResult, MessageProducer messageProducer) {
        if (userValidationResult.isActive()) {
            return ModelHelper.getActiveRegistrationMesssage(userValidationResult, messageProducer);
        }
        return messageProducer.message(UsersKeys.Users.ACTIVE_BY_ADMIN, new Object[0]);
    }

    public static Object getFirstNonEmpty(Bean bean, Collection<? extends Property<?, ?>> collection) {
        for (Property<?, ?> property : collection) {
            Object object = bean.get(property);
            if (!ObjectHelper.isNotEmpty((Object)object)) continue;
            return object;
        }
        return null;
    }

    public static List<String> getFriendlyMimeTypes(Collection<FileMimeType> collection, Collection<String> collection2, MessageProducer messageProducer) {
        ArrayList<String> arrayList = new ArrayList<String>(CollectionHelper.size(collection) + CollectionHelper.size(collection2));
        CollectionHelper.orEmpty(collection).stream().filter(fileMimeType -> fileMimeType != FileMimeType.OTHERS).map(FileMimeType::getMessageKey).map(messageKey -> messageProducer.message((MessageKey)messageKey, new Object[0])).forEach(arrayList::add);
        CollectionHelper.orEmpty(collection2).stream().forEach(arrayList::add);
        return arrayList;
    }

    public static List<String> getFriendlyMimeTypes(Collection<String> collection, MessageProducer messageProducer) {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptyList();
        }
        EnumSet<FileMimeType> enumSet = EnumSet.noneOf(FileMimeType.class);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : collection) {
            FileMimeType fileMimeType = FileMimeType.of(string);
            if (fileMimeType != null) {
                enumSet.add(fileMimeType);
                continue;
            }
            treeSet.add(string);
        }
        return ModelHelper.getFriendlyMimeTypes(enumSet, treeSet, messageProducer);
    }

    public static <T extends Bean> List<T> getHierarchyPath(T object, Property<T, T> property) {
        LinkedList<T> linkedList = new LinkedList<T>();
        while (object != null) {
            linkedList.addFirst((T)object);
            object = (Bean)object.get(property);
        }
        return linkedList;
    }

    public static <T extends Bean> int getLevel(T object, Property<T, T> property) {
        if (object == null) {
            return 0;
        }
        int n = -1;
        while (object != null) {
            object = (Bean)object.get(property);
            ++n;
        }
        return n;
    }

    public static LatLongDTO getLocation(IAddress iAddress) {
        LatLongDTO latLongDTO;
        if (iAddress instanceof Bean && ModelHelper.isValid(latLongDTO = (LatLongDTO)((Bean)iAddress).get((Property)UserAddressDTO.LOCATION))) {
            return latLongDTO;
        }
        return null;
    }

    public static String getPublicRegistrationMesssage(UserRegistrationResult userRegistrationResult, MessageProducer messageProducer) {
        String string = messageProducer.message(UsersKeys.Users.PUBLIC_REGISTRATION_CREATED_PREFIX, new Object[0]) + "<br><br>";
        RegistrationStatus registrationStatus = userRegistrationResult.getStatus();
        switch (registrationStatus) {
            case ACTIVE: {
                return string + ModelHelper.getActiveRegistrationMesssage(userRegistrationResult, messageProducer);
            }
            case EMAIL_VALIDATION: 
            case INACTIVE: {
                return string + messageProducer.message(RegistrationStatus.resolverForPublicRegistration().resolveKey(registrationStatus), new Object[0]);
            }
        }
        throw new IllegalArgumentException("Unknown registration status: " + String.valueOf((Object)registrationStatus));
    }

    public static Comparator<UserLocatorVO> getUserLocatorComparator() {
        return USER_LOCATOR_COMPARATOR;
    }

    public static String identifier(AccountOwner accountOwner, boolean bl) {
        if (accountOwner instanceof SystemAccountOwner) {
            return "SYSTEM";
        }
        if (accountOwner instanceof ExternalAccountOwner) {
            return "EXTERNAL";
        }
        if (accountOwner instanceof BasicUserVO) {
            String string;
            BasicUserVO basicUserVO = (BasicUserVO)accountOwner;
            Long l = basicUserVO.getId();
            if (l != null) {
                return l.toString();
            }
            UserLocatorVO userLocatorVO = basicUserVO.getLocator();
            String string2 = string = userLocatorVO == null ? null : StringHelper.trimToNull((Object)userLocatorVO.getPrincipal());
            if (string != null) {
                String string3 = StringHelper.trimToNull((Object)userLocatorVO.getPrincipalType());
                return string3 == null ? string : string3 + ":" + string;
            }
        }
        if (accountOwner instanceof EntityVO) {
            return ModelHelper.stringOrIdFromVO((EntityVO)accountOwner, bl);
        }
        if (accountOwner instanceof IEntity) {
            return ModelHelper.internalNameOrId((IEntity)accountOwner);
        }
        return null;
    }

    public static IntegerRangeDTO integerRange(Integer n, Integer n2) {
        IntegerRangeDTO integerRangeDTO = new IntegerRangeDTO();
        integerRangeDTO.setMin(n);
        integerRangeDTO.setMax(n2);
        return integerRangeDTO;
    }

    public static String internalNameOrId(IEntity iEntity) {
        return ModelHelper.doInternalNameOrId(iEntity, false);
    }

    public static boolean isEmpty(DatePeriodDTO datePeriodDTO) {
        return datePeriodDTO == null || datePeriodDTO.getBegin() == null && datePeriodDTO.getEnd() == null;
    }

    public static boolean isEmpty(Range<?> range) {
        return range == null || range.getMin() == null || range.getMax() == null;
    }

    @SafeVarargs
    public static <T extends Bean> boolean isEmpty(T t, Property<?, ? super T> ... propertyArray) {
        if (t == null) {
            return true;
        }
        if (propertyArray == null || propertyArray.length == 0) {
            return false;
        }
        for (Property<?, ? super T> property : Arrays.asList(propertyArray)) {
            if (!ObjectHelper.isNotEmpty((Object)t.get(property))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(DistanceDTO distanceDTO) {
        return distanceDTO != null && distanceDTO.getDistance() != null && ModelHelper.isValid(distanceDTO.getLocation());
    }

    public static boolean isValid(FileSizeDTO fileSizeDTO) {
        return fileSizeDTO != null && fileSizeDTO.getSize() != null && fileSizeDTO.getUnit() != null;
    }

    public static boolean isValid(IInternalNamedEntity iInternalNamedEntity) {
        return iInternalNamedEntity != null && (iInternalNamedEntity.getId() != null || StringHelper.isNotBlank((Object)iInternalNamedEntity.getInternalName()));
    }

    public static boolean isValid(LatLongDTO latLongDTO) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = latLongDTO == null ? null : latLongDTO.getLatitude();
        BigDecimal bigDecimal3 = bigDecimal = latLongDTO == null ? null : latLongDTO.getLongitude();
        if (bigDecimal2 == null || bigDecimal == null) {
            return false;
        }
        return bigDecimal2.compareTo(MIN_LATITUDE) >= 0 && bigDecimal2.compareTo(MAX_LATITUDE) <= 0 && bigDecimal.compareTo(MIN_LONGITUDE) >= 0 && bigDecimal.compareTo(MAX_LONGITUDE) <= 0;
    }

    public static boolean isValid(TimeIntervalDTO timeIntervalDTO) {
        return timeIntervalDTO != null && timeIntervalDTO.getAmount() != null && timeIntervalDTO.getField() != null;
    }

    public static boolean isValid(UserLocatorVO userLocatorVO) {
        if (userLocatorVO == null) {
            return false;
        }
        return userLocatorVO.getId() != null || StringHelper.isNotBlank((Object)userLocatorVO.getUsername()) || StringHelper.isNotBlank((Object)userLocatorVO.getPrincipal());
    }

    public static LatLongDTO latLong(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        LatLongDTO latLongDTO = new LatLongDTO();
        latLongDTO.setLatitude(bigDecimal);
        latLongDTO.setLongitude(bigDecimal2);
        return latLongDTO;
    }

    public static LatLongDTO latLong(double d, double d2) {
        return ModelHelper.latLong(new BigDecimal(d), new BigDecimal(d2));
    }

    public static String locatorText(String string) {
        return StringHelper.removeEnd((String)StringHelper.removeStart((String)string, (String)LOCATOR_QUOTE), (String)LOCATOR_QUOTE);
    }

    public static Property<?, ? super OperatorWithFieldsVO> operatorWithFieldsProperty(BasicProfileField basicProfileField) {
        switch (basicProfileField) {
            case EMAIL: {
                return OperatorWithFieldsVO.EMAIL;
            }
            case FULL_NAME: {
                return OperatorWithFieldsVO.NAME;
            }
            case LOGIN_NAME: {
                return OperatorWithFieldsVO.USERNAME;
            }
            case PHONE: {
                return OperatorWithFieldsVO.PHONE;
            }
            case IMAGE: 
            case ADDRESS: 
            case ACCOUNT_NUMBER: {
                return null;
            }
        }
        return null;
    }

    public static <E extends EntityModel> E removeId(E e) {
        if (e == null) {
            return null;
        }
        e.setId(null);
        return e;
    }

    public static ImageNature resolveImageNature(ImageVO imageVO) {
        return imageVO.getNature();
    }

    public static UserLocatorVO self() {
        return new UserLocatorVO(UserLocatorVO.PRINCIPAL, "self");
    }

    public static String stringFromVO(EntityVO entityVO) {
        return ModelHelper.stringFromVO(entityVO, false);
    }

    public static String stringFromVO(EntityVO entityVO, boolean bl) {
        if (entityVO == null) {
            return null;
        }
        String string = (String)entityVO.getAttribute(STRING_FROM_VO_ATTR);
        if (string == null) {
            string = ModelHelper.doStringFromVO(entityVO, bl);
            entityVO.setAttribute(STRING_FROM_VO_ATTR, (Object)string);
        }
        return string;
    }

    public static String stringOrIdFromAccountOwner(AccountOwner accountOwner) {
        if (SystemAccountOwner.instance().equals(accountOwner)) {
            return "system";
        }
        if (ExternalAccountOwner.instance().equals(accountOwner)) {
            return "external";
        }
        if (accountOwner instanceof BasicUserVO) {
            BasicUserVO basicUserVO = (BasicUserVO)accountOwner;
            if (basicUserVO.getLocator() != null) {
                return ModelHelper.stringOrIdFromVO(basicUserVO.getLocator());
            }
            return ModelHelper.stringOrIdFromVO(basicUserVO);
        }
        if (accountOwner instanceof EntityVO) {
            return ModelHelper.stringOrIdFromVO((EntityVO)accountOwner, false);
        }
        return null;
    }

    public static String stringOrIdFromVO(EntityVO entityVO) {
        return ModelHelper.stringOrIdFromVO(entityVO, false);
    }

    public static String stringOrIdFromVO(EntityVO entityVO, boolean bl) {
        return ModelHelper.stringOrIdFromVO(entityVO, bl, true);
    }

    public static String stringOrIdFromVO(EntityVO entityVO, boolean bl, boolean bl2) {
        String string = ModelHelper.stringFromVO(entityVO, bl);
        if (string == null && entityVO != null) {
            string = (String)CoercionHelper.coerce(String.class, (Object)entityVO.getId());
            if (bl2) {
                entityVO.setAttribute(STRING_FROM_VO_ATTR, (Object)string);
            }
        }
        return string;
    }

    public static TimeIntervalDTO timeInterval(int n, TimeField timeField) {
        TimeIntervalDTO timeIntervalDTO = new TimeIntervalDTO();
        timeIntervalDTO.setAmount(n);
        timeIntervalDTO.setField(timeField);
        return timeIntervalDTO;
    }

    @GwtIncompatible
    public static <VO extends EntityVO> Set<VO> toVOs(Class<VO> clazz, Collection<? extends IEntity> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptySet();
        }
        return collection.stream().map(iEntity -> {
            EntityVO entityVO = (EntityVO)ModelHelper.newInstance(clazz);
            entityVO.setId(iEntity.getId());
            return entityVO;
        }).collect(Collectors.toSet());
    }

    public static String unqualifiedInternalNameOrId(IEntity iEntity) {
        return ModelHelper.doInternalNameOrId(iEntity, true);
    }

    public static String unqualifyInternalName(IInternalNamedEntity iInternalNamedEntity) {
        return ModelHelper.unqualifyInternalName(iInternalNamedEntity == null ? null : iInternalNamedEntity.getInternalName());
    }

    public static String unqualifyInternalName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(n + 1);
    }

    public static UserLocatorVO userLocator(String string) {
        return ModelHelper.userLocator(string, true);
    }

    public static UserLocatorVO userLocator(String string, boolean bl) {
        if ((string = StringHelper.trimToNull((Object)string)) == null) {
            return null;
        }
        VoLocator voLocator = ModelHelper.parseLocator("User", string, bl);
        UserLocatorVO userLocatorVO = new UserLocatorVO();
        userLocatorVO.setId(voLocator.id);
        userLocatorVO.setPrincipalType(voLocator.qualifier);
        userLocatorVO.setPrincipal(voLocator.value);
        return userLocatorVO;
    }

    public static UserLocatorVO userLocator(UserVO userVO) {
        if (userVO instanceof UserLocatorVO) {
            return (UserLocatorVO)userVO;
        }
        if (userVO != null && userVO.getId() != null) {
            return new UserLocatorVO(userVO.getId());
        }
        return null;
    }

    public static Property<?, ? super UserWithFieldsVO> userWithFieldsProperty(BasicProfileField basicProfileField) {
        switch (basicProfileField) {
            case ACCOUNT_NUMBER: {
                return UserWithFieldsVO.ACCOUNT_NUMBER;
            }
            case EMAIL: {
                return UserWithFieldsVO.EMAIL;
            }
            case FULL_NAME: {
                return UserWithFieldsVO.NAME;
            }
            case LOGIN_NAME: {
                return UserWithFieldsVO.USERNAME;
            }
            case PHONE: {
                return UserWithFieldsVO.PHONE;
            }
            case ADDRESS: {
                return UserWithFieldsVO.ADDRESS;
            }
            case IMAGE: {
                return UserWithFieldsVO.IMAGE;
            }
        }
        return null;
    }

    @GwtIncompatible
    public static <VO extends EntityVO> VO voFromString(Class<VO> clazz, String string) {
        if ((string = StringHelper.trimToNull((Object)string)) == null) {
            return null;
        }
        VoLocator voLocator = ModelHelper.parseLocator(clazz.getSimpleName(), string, true);
        if (PinLocatorVO.class.isAssignableFrom(clazz)) {
            PinLocatorVO pinLocatorVO = new PinLocatorVO();
            pinLocatorVO.setId(voLocator.id);
            pinLocatorVO.setPrincipal(voLocator.value);
            return (VO)((Object)pinLocatorVO);
        }
        if (BasicUserVO.class.isAssignableFrom(clazz)) {
            UserLocatorVO userLocatorVO = new UserLocatorVO();
            userLocatorVO.setId(voLocator.id);
            userLocatorVO.setPrincipalType(voLocator.qualifier);
            userLocatorVO.setPrincipal(voLocator.value);
            return (VO)userLocatorVO;
        }
        if (AccountVO.class.isAssignableFrom(clazz)) {
            AccountVO accountVO = new AccountVO();
            accountVO.setId(voLocator.id);
            if (voLocator.value != null) {
                if ("acc".equals(voLocator.qualifier) || voLocator.value.contains("@")) {
                    String string2;
                    List list = StringHelper.splitTrimming((String)string, (String)"@");
                    accountVO.setType(ModelHelper.voFromString(AccountTypeVO.class, (String)list.get(0)));
                    Object object = list.size() == 1 ? ModelHelper.self() : ("system".equals(string2 = ((String)list.get(1)).trim()) ? SystemAccountOwner.instance() : (InternalAccountOwner)ModelHelper.voFromString(UserLocatorVO.class, string2));
                    accountVO.setOwner((InternalAccountOwner)object);
                } else if (voLocator.qualifier == null || voLocator.qualifier.equals(AccountVO.NUMBER.getName())) {
                    accountVO.setNumber(voLocator.value);
                }
            }
            return (VO)((Object)accountVO);
        }
        if (TransferVO.class.isAssignableFrom(clazz)) {
            TransferVO transferVO = (TransferVO)ModelHelper.newInstance(clazz.asSubclass(TransferVO.class));
            transferVO.setId(voLocator.id);
            if (voLocator.qualifier == null || voLocator.qualifier.equals(TransferVO.TRANSACTION_NUMBER.getName())) {
                transferVO.setTransactionNumber(voLocator.value);
            }
            return (VO)transferVO;
        }
        if (TransactionVO.class.isAssignableFrom(clazz)) {
            TransactionVO transactionVO = (TransactionVO)ModelHelper.newInstance(clazz.asSubclass(TransactionVO.class));
            transactionVO.setId(voLocator.id);
            boolean bl = TicketVO.class.isAssignableFrom(clazz);
            if (voLocator.qualifier == null) {
                if (bl) {
                    ((TicketVO)transactionVO).setTicketNumber(voLocator.value);
                } else {
                    transactionVO.setTransactionNumber(voLocator.value);
                }
            } else if (voLocator.qualifier.equals(TransactionVO.TRANSACTION_NUMBER.getName())) {
                transactionVO.setTransactionNumber(voLocator.value);
            } else if (bl && voLocator.qualifier.equals(TicketVO.TICKET_NUMBER.getName())) {
                ((TicketVO)transactionVO).setTicketNumber(voLocator.value);
            }
            return (VO)transactionVO;
        }
        if (InstallmentLocatorVO.class.isAssignableFrom(clazz)) {
            InstallmentLocatorVO installmentLocatorVO = (InstallmentLocatorVO)((Object)ModelHelper.newInstance(clazz.asSubclass(InstallmentLocatorVO.class)));
            installmentLocatorVO.setId(voLocator.id);
            if (voLocator.value != null && voLocator.value.contains("@")) {
                int n;
                try {
                    n = Integer.parseInt(StringUtils.substringBefore((String)voLocator.value, (String)"@"));
                }
                catch (Exception exception) {
                    n = 0;
                }
                installmentLocatorVO.setNumber(n);
                installmentLocatorVO.setTransaction(ModelHelper.voFromString(TransactionVO.class, StringUtils.substringAfter((String)voLocator.value, (String)"@")));
            }
            return (VO)((Object)installmentLocatorVO);
        }
        if (VoucherVO.class.isAssignableFrom(clazz)) {
            VoucherVO voucherVO = new VoucherVO();
            voucherVO.setId(voLocator.id);
            if (voLocator.qualifier == null || voLocator.qualifier.equals(VoucherVO.TOKEN.getName())) {
                voucherVO.setToken(voLocator.value);
            }
            return (VO)((Object)voucherVO);
        }
        if (AccessClientLocatorVO.class.isAssignableFrom(clazz)) {
            AccessClientLocatorVO accessClientLocatorVO = new AccessClientLocatorVO();
            accessClientLocatorVO.setId(voLocator.id);
            if (voLocator.qualifier == null || voLocator.qualifier.equals(AccessClientLocatorVO.TOKEN.getName())) {
                accessClientLocatorVO.setToken(voLocator.value);
            }
            return (VO)accessClientLocatorVO;
        }
        if (OrderVO.class.isAssignableFrom(clazz)) {
            OrderVO orderVO = (OrderVO)ModelHelper.newInstance(clazz.asSubclass(OrderVO.class));
            orderVO.setId(voLocator.id);
            if (voLocator.qualifier == null || voLocator.qualifier.equals(OrderVO.NUMBER.getName())) {
                orderVO.setNumber(voLocator.value);
            }
            return (VO)orderVO;
        }
        if (BasicAdVO.class.isAssignableFrom(clazz)) {
            BasicAdVO basicAdVO = null;
            if ((voLocator.qualifier == null || voLocator.qualifier.equals(AdWebShopVO.PRODUCT_NUMBER.getName())) && voLocator.value != null) {
                basicAdVO = new AdWebShopVO();
                ((AdWebShopVO)basicAdVO).setProductNumber(StringUtils.substringBefore((String)voLocator.value, (String)"@"));
                basicAdVO.setOwner(voLocator.value.contains("@") ? ModelHelper.voFromString(UserVO.class, StringUtils.substringAfter((String)voLocator.value, (String)"@")) : null);
            } else {
                basicAdVO = (BasicAdVO)((Object)ModelHelper.newInstance(clazz.asSubclass(BasicAdVO.class)));
            }
            basicAdVO.setId(voLocator.id);
            return (VO)((Object)basicAdVO);
        }
        if (PhoneVO.class.isAssignableFrom(clazz)) {
            PhoneVO phoneVO = null;
            if ((voLocator.qualifier == null || voLocator.qualifier.equals(PhoneVO.NUMBER.getName())) && voLocator.value != null) {
                phoneVO = new PhoneVO();
                phoneVO.setNumber(voLocator.value);
            } else {
                phoneVO = (PhoneVO)((Object)ModelHelper.newInstance(clazz.asSubclass(PhoneVO.class)));
            }
            phoneVO.setId(voLocator.id);
            return (VO)((Object)phoneVO);
        }
        if (ImageVO.class.isAssignableFrom(clazz)) {
            ImageVO imageVO = (ImageVO)ModelHelper.newInstance(clazz.asSubclass(ImageVO.class));
            imageVO.setId(voLocator.id);
            if (voLocator.qualifier == null || voLocator.qualifier.equals(ImageVO.KEY.getName())) {
                imageVO.setKey(voLocator.value);
            }
            return (VO)imageVO;
        }
        if (IInternalNamedEntity.class.isAssignableFrom(clazz)) {
            IInternalNamedEntity iInternalNamedEntity = (IInternalNamedEntity)ModelHelper.newInstance(clazz.asSubclass(IInternalNamedEntity.class));
            ((EntityVO)iInternalNamedEntity).setId(voLocator.id);
            if (voLocator.qualifier == null || voLocator.qualifier.equals(ConfigurationEntityVO.INTERNAL_NAME.getName())) {
                iInternalNamedEntity.setInternalName(voLocator.value);
            }
            return (VO)((EntityVO)iInternalNamedEntity);
        }
        EntityVO entityVO = (EntityVO)ModelHelper.newInstance(clazz);
        entityVO.setId(voLocator.id);
        return (VO)entityVO;
    }

    @GwtIncompatible
    public static <VO extends EntityVO> List<VO> voListFromString(Class<VO> clazz, Collection<String> collection) {
        ArrayList arrayList = new ArrayList();
        ModelHelper.collectVOs(clazz, collection, arrayList);
        return arrayList;
    }

    @GwtIncompatible
    public static <VO extends EntityVO> Set<VO> vosFromString(Class<VO> clazz, Collection<String> collection) {
        HashSet hashSet = new HashSet();
        ModelHelper.collectVOs(clazz, collection, hashSet);
        return hashSet;
    }

    @GwtIncompatible
    private static <VO extends EntityVO> void collectVOs(Class<VO> clazz, Collection<String> collection, Collection<VO> collection2) {
        if (collection2 == null || collection == null) {
            return;
        }
        for (String string : collection) {
            VO VO = ModelHelper.voFromString(clazz, string);
            if (VO == null) continue;
            collection2.add(VO);
        }
    }

    private static String doInternalNameOrId(IEntity iEntity, boolean bl) {
        if (iEntity == null) {
            return null;
        }
        String string = null;
        if (iEntity instanceof ImageVO) {
            string = ((ImageVO)iEntity).getKey();
        } else if (iEntity instanceof IInternalNamedEntity) {
            string = ((IInternalNamedEntity)iEntity).getInternalName();
            if (bl) {
                string = ModelHelper.unqualifyInternalName(string);
            }
            try {
                Long.parseLong(string);
                string = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = iEntity.getId() == null ? null : iEntity.getId().toString();
        }
        return string;
    }

    private static String doStringFromVO(EntityVO entityVO, boolean bl) {
        if (entityVO instanceof UserLocatorVO) {
            UserLocatorVO userLocatorVO = (UserLocatorVO)entityVO;
            String string = StringHelper.isBlank((Object)userLocatorVO.getPrincipalType()) ? userLocatorVO.getPrincipal() : userLocatorVO.getPrincipalType() + ":" + userLocatorVO.getPrincipal();
            return (String)ObjectHelper.defaultValue((Object)userLocatorVO.getUsername(), (Object)(bl && StringHelper.isNumeric((String)string) ? LOCATOR_QUOTE + string : string));
        }
        if (entityVO instanceof AccountVO) {
            AccountVO accountVO = (AccountVO)entityVO;
            String string = ModelHelper.stringOrIdFromVO((EntityVO)accountVO.getType(), bl);
            InternalAccountOwner internalAccountOwner = accountVO.getOwner();
            String string2 = internalAccountOwner instanceof SystemAccountOwner ? "system" : ModelHelper.stringOrIdFromVO((EntityVO)internalAccountOwner, bl);
            return string == null || string2 == null ? null : string + "@" + string2;
        }
        if (entityVO instanceof TransferVO) {
            return ((TransferVO)entityVO).getTransactionNumber();
        }
        if (entityVO instanceof TicketVO) {
            return ((TicketVO)entityVO).getTicketNumber();
        }
        if (entityVO instanceof TransactionVO) {
            return ((TransactionVO)entityVO).getTransactionNumber();
        }
        if (entityVO instanceof VoucherVO) {
            return ((VoucherVO)entityVO).getToken();
        }
        if (entityVO instanceof AccessClientLocatorVO) {
            return entityVO.getId() == null ? "****" : null;
        }
        if (entityVO instanceof OrderVO) {
            return ((OrderVO)entityVO).getNumber();
        }
        if (entityVO instanceof AdWebShopVO) {
            AdWebShopVO adWebShopVO = (AdWebShopVO)entityVO;
            UserVO userVO = adWebShopVO.getOwner();
            if (userVO == null) {
                return adWebShopVO.getProductNumber();
            }
            return adWebShopVO.getProductNumber() + "@" + ModelHelper.stringOrIdFromVO(userVO);
        }
        if (entityVO instanceof PhoneVO) {
            return ((PhoneVO)entityVO).getNumber();
        }
        if (entityVO instanceof ImageVO) {
            return ((ImageVO)entityVO).getKey();
        }
        if (entityVO instanceof IInternalNamedEntity) {
            return ((IInternalNamedEntity)entityVO).getInternalName();
        }
        return null;
    }

    private static String getActiveRegistrationMesssage(BaseUserRegistrationResult baseUserRegistrationResult, MessageProducer messageProducer) {
        String string;
        List<UserPrincipalData> list = baseUserRegistrationResult.getPrincipalsData();
        if (list.size() == 1) {
            UserPrincipalData userPrincipalData = list.get(0);
            string = messageProducer.message(UsersKeys.Users.ACTIVE_SINGLE_PRINCIPAL, new Object[]{userPrincipalData.getPrincipalType(), userPrincipalData.getPrincipal(), userPrincipalData.getChannels()});
        } else {
            StringBuilder stringBuilder = new StringBuilder("<ul>");
            for (UserPrincipalData userPrincipalData : list) {
                String string2 = messageProducer.message(UsersKeys.Users.ACTIVE_MULTILPLE_PRINCIPALS_TEMPLATE, new Object[]{userPrincipalData.getPrincipalType(), userPrincipalData.getPrincipal(), userPrincipalData.getChannels()});
                stringBuilder.append("<li>").append(string2).append("</li>");
            }
            stringBuilder.append("</ul>");
            string = messageProducer.message(MessageFormat.HTML, UsersKeys.Users.ACTIVE_MULTILPLE_PRINCIPALS, stringBuilder);
        }
        return CollectionHelper.isEmpty(baseUserRegistrationResult.getGeneratedPasswords()) ? string : string + "<br>" + messageProducer.message(UsersKeys.Users.ACTIVE_PASSWORDS_SUFFIX, baseUserRegistrationResult.getGeneratedPasswords());
    }

    @GwtIncompatible
    private static <T, R extends T> R newInstance(Class<T> clazz) {
        try {
            return (R)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static VoLocator parseLocator(String string, String string2, boolean bl) {
        VoLocator voLocator = new VoLocator();
        if (string2 == null) {
            return voLocator;
        }
        int n = (string2 = string2.trim()).indexOf(58);
        if (n < 0) {
            try {
                if (!bl) {
                    throw new NumberFormatException();
                }
                voLocator.id = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                voLocator.value = ModelHelper.locatorText(string2);
            }
        } else {
            voLocator.qualifier = string2.substring(0, n).trim();
            voLocator.value = string2.substring(n + 1).trim();
            if ("id".equals(voLocator.qualifier)) {
                try {
                    if (!bl) {
                        throw new NumberFormatException();
                    }
                    voLocator.id = Long.parseLong(voLocator.value);
                    voLocator.qualifier = null;
                    voLocator.value = null;
                }
                catch (NumberFormatException numberFormatException) {
                    EntityNotFoundException entityNotFoundException = new EntityNotFoundException();
                    entityNotFoundException.setEntityType(string);
                    entityNotFoundException.setKey(voLocator.value);
                    throw entityNotFoundException;
                }
            }
        }
        return voLocator;
    }

    private static class VoLocator {
        private Long id;
        private String qualifier;
        private String value;

        private VoLocator() {
        }
    }
}

