/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cyclos.model.utils.AuthorizationData;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.MapParameterStorage;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.ParameterStorage;

@GwtIncompatible
public class RequestInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String method;
    private final ParameterStorage parameters;
    private final ParameterStorage headers;
    private final ParameterStorage cookies;
    @GwtIncompatible
    private final SerializableInputStream body;
    private transient Map<String, Object> attributes;

    public static RequestInfoBuilder builder() {
        return new RequestInfoBuilder();
    }

    private RequestInfo(String string, ParameterStorage parameterStorage, ParameterStorage parameterStorage2, ParameterStorage parameterStorage3, SerializableInputStream serializableInputStream) {
        this.method = string;
        this.parameters = parameterStorage;
        this.headers = parameterStorage3;
        this.cookies = parameterStorage2;
        this.body = serializableInputStream;
    }

    public Object getAttribute(String string) {
        return this.attributes == null ? null : this.attributes.get(string);
    }

    public Set<String> getAttributeNames() {
        return this.attributes == null ? Collections.emptySet() : this.attributes.keySet();
    }

    public AuthorizationData getAuthorization() {
        return AuthorizationData.of(this::getHeader);
    }

    @GwtIncompatible
    public SerializableInputStream getBody() {
        return this.body;
    }

    public String getCookie(String string) {
        return this.cookies == null ? null : this.cookies.getString(string);
    }

    public ParameterStorage getCookies() {
        return this.cookies;
    }

    public String getHeader(String string) {
        return this.headers == null ? null : this.headers.getString(string);
    }

    public String getHeader(String string, String string2) {
        return (String)ObjectHelper.defaultValue((Object)this.getHeader(string), (Object)string2);
    }

    public ParameterStorage getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String string) {
        return this.parameters == null ? null : this.parameters.getString(string);
    }

    public ParameterStorage getParameters() {
        return this.parameters;
    }

    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(string, object);
    }

    public static class RequestInfoBuilder {
        private String method;
        private ParameterStorage parameters;
        private ParameterStorage headers;
        private ParameterStorage cookies;
        private SerializableInputStream body;

        public RequestInfoBuilder body(SerializableInputStream serializableInputStream) {
            this.body = serializableInputStream;
            return this;
        }

        public RequestInfoBuilder body(String string) {
            this.body = new SerializableInputStream(string == null || string.isEmpty() ? new byte[]{} : string.getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public RequestInfo build() {
            return new RequestInfo(this.method, this.parameters, this.cookies, this.headers, this.body);
        }

        public RequestInfoBuilder cookies(ParameterStorage parameterStorage) {
            this.cookies = parameterStorage;
            return this;
        }

        public RequestInfoBuilder copy(RequestInfo requestInfo) {
            return this.copy(requestInfo, false);
        }

        public RequestInfoBuilder copy(RequestInfo requestInfo, boolean bl) {
            this.method = requestInfo.getMethod();
            this.parameters = bl ? new MapParameterStorage(requestInfo.getParameters()) : requestInfo.getParameters();
            this.headers = bl ? new MapParameterStorage(requestInfo.getHeaders()) : requestInfo.getHeaders();
            this.cookies = bl ? new MapParameterStorage(requestInfo.getCookies()) : requestInfo.getCookies();
            SerializableInputStream serializableInputStream = requestInfo.getBody();
            if (serializableInputStream != null && bl && !serializableInputStream.isStreamClosed()) {
                try {
                    serializableInputStream.forceCopyToFile();
                }
                catch (IOException iOException) {
                    serializableInputStream = requestInfo.getBody();
                }
            }
            this.body = serializableInputStream;
            return this;
        }

        public RequestInfoBuilder headers(ParameterStorage parameterStorage) {
            this.headers = parameterStorage;
            return this;
        }

        public RequestInfoBuilder method(String string) {
            this.method = string;
            return this;
        }

        public RequestInfoBuilder parameters(ParameterStorage parameterStorage) {
            this.parameters = parameterStorage;
            return this;
        }
    }
}

