/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.jackson.EntityVODeserializer;
import org.cyclos.utils.StringHelper;

abstract class BaseAccountOwnerDeserializer<T extends AccountOwner>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;

    protected BaseAccountOwnerDeserializer(Class<T> clazz) {
        super(clazz);
        this.type = clazz;
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        TreeNode treeNode;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText();
            AccountOwner accountOwner = this.handleString(string);
            if (!this.type.isInstance(accountOwner)) {
                return null;
            }
            return (T)accountOwner;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            UserVO userVO = EntityVODeserializer.deserializeFromLong(UserVO.class, jsonParser.getValueAsLong());
            if (!this.type.isInstance(userVO)) {
                return null;
            }
            return (T)userVO;
        }
        ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
        TreeNode treeNode2 = objectMapper.readTree(jsonParser);
        String string = null;
        if (treeNode2 != null && treeNode2.isObject() && (treeNode = treeNode2.get("class")) != null && treeNode.isValueNode() && treeNode instanceof TextNode) {
            string = StringHelper.trimToNull((Object)((TextNode)treeNode).asText());
        }
        return (T)this.handleUser(objectMapper, treeNode2, string);
    }

    protected AccountOwner handleString(String string) {
        switch (string.toUpperCase()) {
            case "SYSTEM": {
                return SystemAccountOwner.instance();
            }
            case "EXTERNAL": {
                return ExternalAccountOwner.instance();
            }
        }
        return (AccountOwner)ModelHelper.voFromString(UserVO.class, string);
    }

    protected BasicUserVO handleUser(ObjectMapper objectMapper, TreeNode treeNode, String string) throws JsonProcessingException {
        Class clazz;
        try {
            clazz = string == null ? UserLocatorVO.class : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Invalid class: " + string);
        }
        if (!BasicUserVO.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Cannot convert " + string + " to " + String.valueOf(BasicUserVO.class));
        }
        return (BasicUserVO)objectMapper.treeToValue(treeNode, clazz);
    }
}

