/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.ZonedDateTime;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.coercion.CoercionException;

class DateTimeDeserializer
extends StdDeserializer<DateTime> {
    private static final long serialVersionUID = 1L;
    public static final String NOW = "now";

    public DateTimeDeserializer() {
        super(DateTime.class);
    }

    public DateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText();
            if (NOW.equalsIgnoreCase(string)) {
                return new DateTime(ZonedDateTime.now());
            }
            try {
                return DateTime.parse((String)string);
            }
            catch (CoercionException coercionException) {
                throw new JsonParseException(jsonParser, coercionException.getMessage());
            }
        }
        return null;
    }
}

