/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.utils.ModelHelper;

public class EntityVODeserializer<VO extends EntityVO>
extends StdDeserializer<VO>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    private final JsonDeserializer<?> defaultDeserializer;
    private final Class<VO> voClass;

    public static <VO extends EntityVO> VO deserializeFromLong(Class<VO> clazz, long l) {
        try {
            EntityVO entityVO = (EntityVO)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            entityVO.setId(Long.valueOf(l));
            return (VO)entityVO;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public EntityVODeserializer(JsonDeserializer<?> jsonDeserializer, Class<VO> clazz) {
        super(clazz);
        this.defaultDeserializer = jsonDeserializer;
        this.voClass = clazz;
    }

    public VO deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            return ModelHelper.voFromString(this.voClass, jsonParser.getValueAsString());
        }
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            return EntityVODeserializer.deserializeFromLong(this.voClass, jsonParser.getValueAsLong());
        }
        return (VO)((EntityVO)this.defaultDeserializer.deserialize(jsonParser, deserializationContext));
    }

    public boolean isCachable() {
        return true;
    }

    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        if (this.defaultDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)this.defaultDeserializer).resolve(deserializationContext);
        }
    }
}

