/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.system.imports.AdImportField;
import org.cyclos.model.system.imports.GeneralReferenceImportField;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.RecordImportField;
import org.cyclos.model.system.imports.TokenImportField;
import org.cyclos.model.system.imports.TransactionImportField;
import org.cyclos.model.system.imports.UserImportField;

public class ImportFieldDeserializer
extends StdDeserializer<ImportField> {
    private static final long serialVersionUID = 1L;

    public ImportFieldDeserializer() {
        super(ImportField.class);
    }

    public ImportField deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String string;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING && (string = jsonParser.getText()) != null && string.contains(".")) {
            String string2 = StringUtils.substringBefore((String)string, (String)".");
            string = StringUtils.substringAfter((String)string, (String)".");
            if ("USER".equalsIgnoreCase(string2)) {
                return UserImportField.valueOf(string.toUpperCase());
            }
            if ("AD".equalsIgnoreCase(string2)) {
                return AdImportField.valueOf(string.toUpperCase());
            }
            if ("REFERENCE".equalsIgnoreCase(string2)) {
                return GeneralReferenceImportField.valueOf(string.toUpperCase());
            }
            if ("RECORD".equalsIgnoreCase(string2)) {
                return RecordImportField.valueOf(string.toUpperCase());
            }
            if ("TOKEN".equalsIgnoreCase(string2)) {
                return TokenImportField.valueOf(string.toUpperCase());
            }
            if ("TRANSACTION".equalsIgnoreCase(string2)) {
                return TransactionImportField.valueOf(string.toUpperCase());
            }
        }
        return null;
    }
}

