/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.utils.StringHelper;

class ProfileFieldDeserializer
extends StdDeserializer<ProfileField> {
    private static final long serialVersionUID = 1L;

    protected ProfileFieldDeserializer() {
        super(ProfileField.class);
    }

    public ProfileField deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        TreeNode treeNode;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText();
            return BasicProfileField.valueOf(string.toUpperCase());
        }
        ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
        TreeNode treeNode2 = objectMapper.readTree(jsonParser);
        String string = null;
        if (treeNode2 != null && treeNode2.isObject() && (treeNode = treeNode2.get("class")) != null && treeNode.isValueNode() && treeNode instanceof TextNode) {
            string = StringHelper.trimToNull((Object)((TextNode)treeNode).asText());
        }
        if (string == null) {
            string = CustomFieldVO.class.getName();
        }
        try {
            treeNode = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Invalid class: " + string);
        }
        return (ProfileField)objectMapper.treeToValue(treeNode2, (Class)treeNode);
    }
}

