/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.access;

import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.access.InvalidTokenException;
import org.cyclos.model.access.MaxTokenActivationAttemptsException;
import org.cyclos.model.access.TokenAlreadyInUseException;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateDTO;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateData;
import org.cyclos.model.access.tokens.InitializeNFCTagData;
import org.cyclos.model.access.tokens.InitializeNFCTagResult;
import org.cyclos.model.access.tokens.NFCTagInitializeDTO;
import org.cyclos.model.access.tokens.NFCTagPersonalizeDTO;
import org.cyclos.model.access.tokens.PersonalizeNFCTagData;
import org.cyclos.model.access.tokens.TokenActionDTO;
import org.cyclos.model.access.tokens.TokenBarcodeParams;
import org.cyclos.model.access.tokens.TokenDTO;
import org.cyclos.model.access.tokens.TokenData;
import org.cyclos.model.access.tokens.TokenDataParams;
import org.cyclos.model.access.tokens.TokenQuery;
import org.cyclos.model.access.tokens.TokenSearchData;
import org.cyclos.model.access.tokens.TokenVO;
import org.cyclos.model.access.tokens.TokensListData;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.CRUDService;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.Page;

public interface TokenService
extends CRUDService<TokenDTO, TokenData, TokenDataParams> {
    @Transaction(value=TransactionLevel.READ_WRITE)
    public Long activate(@NotNull TokenActionDTO var1, UserLocatorVO var2) throws FrameworkException, MaxTokenActivationAttemptsException, InvalidTokenException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void activatePending(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void assign(@NotNull Long var1, @NotNull UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @GwtIncompatible
    public SerializableInputStream barcode(@NotNull TokenBarcodeParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void block(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void cancel(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void cancelNFCToken(@NotNull TokenActionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public DeviceConfirmationVO createDeviceConfirmationForPersonalizeNFCTag(@NotNull UserLocatorVO var1, @NotNull TokenPrincipalTypeVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @GwtIncompatible
    public SerializableInputStream deviceConfirmationBarcodeForPersonalizeNFCTag(UserLocatorVO var1, @NotNull TokenPrincipalTypeVO var2, DeviceConfirmationBarcodeParams var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @GwtIncompatible
    public FileInfo exportTokens(@NotNull ExportFormatVO var1, @NotNull TokenQuery var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public InitializeNFCTagData getInitializeNFCTagData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TokensListData getListData(@NotNull TokenPrincipalTypeVO var1, @NotNull UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public PersonalizeNFCTagData getPersonalizeNFCTagData(@NotNull TokenPrincipalTypeVO var1, @NotNull UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TokenSearchData getSearchData(TokenPrincipalTypeVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public InitializeNFCTagResult initializeNFCTag(@NotNull NFCTagInitializeDTO var1) throws FrameworkException, TokenAlreadyInUseException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void personalizeNFCTag(@NotNull NFCTagPersonalizeDTO var1) throws FrameworkException, TokenAlreadyInUseException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void removeDeviceConfirmationForPersonalizeNFCTag(@NotNull UserLocatorVO var1, @NotNull TokenPrincipalTypeVO var2, String var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public ExternalNFCTagAuthenticateData requestForExternalAuthenticate(@NotNull ExternalNFCTagAuthenticateDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void requestNewOTPForPersonalizeNFCTag(@NotNull UserLocatorVO var1, @NotNull TokenPrincipalTypeVO var2, @NotNull SendMedium var3) throws FrameworkException, SmsSendingException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<TokenVO> search(@NotNull TokenQuery var1) throws FrameworkException, QueryParseException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void setActivationDeadline(@NotNull Long var1, DateTime var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void setExpiryDate(@NotNull Long var1, DateTime var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void unblock(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public DeviceConfirmationVO viewDeviceConfirmationForPersonalizeNFCTag(@NotNull UserLocatorVO var1, @NotNull TokenPrincipalTypeVO var2, String var3) throws FrameworkException;
}

