/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.banking;

import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.transactions.EasyInvoiceBarcodeParams;
import org.cyclos.model.banking.transactions.EasyInvoiceData;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentVO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceData;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceParams;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.Service;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.RunInChannel;

public interface EasyInvoiceService
extends Service {
    @Transaction(value=TransactionLevel.READ_ONLY)
    @GwtIncompatible
    @RunInChannel(value=BuiltInChannel.EASY_INVOICE)
    public SerializableInputStream barcode(@NotNull EasyInvoiceBarcodeParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @RunInChannel(value=BuiltInChannel.EASY_INVOICE)
    public EasyInvoiceData getEasyInvoiceData(PerformPaymentDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    @RunInChannel(value=BuiltInChannel.EASY_INVOICE)
    public PaymentVO perform(@NotNull PerformPaymentDTO var1) throws TransferException, FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @RunInChannel(value=BuiltInChannel.EASY_INVOICE)
    public PrepareEasyInvoiceData prepareEasyInvoice(PrepareEasyInvoiceParams var1) throws FrameworkException, RemoteAddressBlockedException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @RunInChannel(value=BuiltInChannel.EASY_INVOICE)
    public PaymentPreviewVO preview(@NotNull PerformPaymentDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    @RunInChannel(value=BuiltInChannel.EASY_INVOICE)
    public void validate(@NotNull PerformPaymentDTO var1) throws FrameworkException;
}

