/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.banking;

import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestDTO;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestPreviewVO;
import org.cyclos.model.banking.transactions.ChangePaymentRequestExpirationDateDTO;
import org.cyclos.model.banking.transactions.PaymentRequestActionDTO;
import org.cyclos.model.banking.transactions.PaymentRequestData;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.banking.transactions.RequestPaymentData;
import org.cyclos.model.banking.transactions.RequestPaymentPayerData;
import org.cyclos.model.banking.transactions.RequestPaymentTypeData;
import org.cyclos.model.banking.transactions.SendPaymentRequestDTO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.services.Service;

public interface PaymentRequestService
extends Service {
    @Transaction(value=TransactionLevel.READ_WRITE)
    public PaymentRequestVO accept(@NotNull AcceptPaymentRequestDTO var1) throws FrameworkException, TransferException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void cancel(@NotNull PaymentRequestActionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void changeExpirationDate(@NotNull ChangePaymentRequestExpirationDateDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void deny(@NotNull PaymentRequestActionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public PaymentRequestData getData(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public RequestPaymentData getRequestData(InternalAccountOwner var1, InternalAccountOwner var2, TransferTypeVO var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public RequestPaymentPayerData getRequestPaymentPayerData(InternalAccountOwner var1, InternalAccountOwner var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public RequestPaymentTypeData getRequestPaymentTypeData(InternalAccountOwner var1, InternalAccountOwner var2, TransferTypeVO var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AcceptPaymentRequestPreviewVO previewAccept(@NotNull PaymentRequestVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public PaymentRequestVO reschedule(@NotNull AcceptPaymentRequestDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public PaymentRequestVO send(@NotNull SendPaymentRequestDTO var1) throws FrameworkException;
}

