/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.banking;

import java.math.BigDecimal;
import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.banking.PosPayerException;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentOverviewSearchData;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentResultVO;
import org.cyclos.model.banking.transactions.InstallmentSearchData;
import org.cyclos.model.banking.transactions.MaturityTableItemData;
import org.cyclos.model.banking.transactions.MaturityTableQuery;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentData;
import org.cyclos.model.banking.transactions.PerformPaymentToOwnerData;
import org.cyclos.model.banking.transactions.PerformPaymentTypeData;
import org.cyclos.model.banking.transactions.ReceivePaymentData;
import org.cyclos.model.banking.transactions.ReceivePaymentFromUserData;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionOverviewSearchData;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionSearchData;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.Service;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.Page;

public interface TransactionService
extends Service {
    public static final int MAX_TRANSACTION_AMOUNT_INTEGERS = 15;
    public static final BigDecimal MAX_TRANSACTION_AMOUNT_EXCLUSIVE = BigDecimal.TEN.pow(15);

    @Transaction(value=TransactionLevel.READ_WRITE)
    public DeviceConfirmationVO createDeviceConfirmationForReceive(@NotNull PerformInternalTransactionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @GwtIncompatible
    public SerializableInputStream deviceConfirmationBarcodeForReceive(InternalAccountOwner var1, DeviceConfirmationBarcodeParams var2) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportInstallments(@NotNull ExportFormatVO var1, @NotNull InstallmentQuery var2);

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportInstallmentsOverview(@NotNull ExportFormatVO var1, @NotNull InstallmentOverviewQuery var2);

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportOverview(@NotNull ExportFormatVO var1, @NotNull TransactionOverviewQuery var2);

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportTransaction(@NotNull ExportFormatVO var1, @NotNull TransactionVO var2) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportTransactions(@NotNull ExportFormatVO var1, @NotNull TransactionQuery var2);

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TransactionData getData(@NotNull TransactionVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public InstallmentOverviewSearchData getInstallmentsOverviewSearchData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public InstallmentSearchData getInstallmentsSearchData(InternalAccountOwner var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<MaturityTableItemData> getMaturityTable(@NotNull MaturityTableQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TransactionOverviewSearchData getOverviewSearchData(boolean var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public PerformPaymentData getPaymentData(InternalAccountOwner var1, InternalAccountOwner var2, TransferTypeVO var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public PerformPaymentToOwnerData getPaymentToOwnerData(InternalAccountOwner var1, InternalAccountOwner var2, TransferTypeVO var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public PerformPaymentTypeData getPaymentTypeData(InternalAccountOwner var1, InternalAccountOwner var2, TransferTypeVO var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ReceivePaymentData getReceivePaymentData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ReceivePaymentFromUserData getReceivePaymentFromUserData(UserLocatorVO var1, TransferTypeVO var2) throws FrameworkException, PosPayerException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public PerformPaymentTypeData getReceivePaymentTypeData(UserLocatorVO var1, TransferTypeVO var2) throws FrameworkException, PosPayerException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TransactionSearchData getSearchData(InternalAccountOwner var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TransactionVO load(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TransactionVO loadByTransactionNumber(@NotNull String var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public TransferVO processInstallment(InstallmentActionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void removeDeviceConfirmationForReceive(String var1, @NotNull PerformInternalTransactionDTO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void requestNewOTPForReceive(@NotNull PerformInternalTransactionDTO var1, @NotNull SendMedium var2) throws FrameworkException, SmsSendingException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<TransactionResultVO> search(@NotNull TransactionQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<InstallmentResultVO> searchInstallments(@NotNull InstallmentQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<InstallmentResultVO> searchInstallmentsOverview(@NotNull InstallmentOverviewQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<TransactionResultVO> searchOverview(@NotNull TransactionOverviewQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void settleInstallment(InstallmentActionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public DeviceConfirmationVO viewDeviceConfirmationForReceive(String var1, @NotNull PerformInternalTransactionDTO var2) throws FrameworkException;
}

