/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ParameterStorage;
import org.cyclos.utils.coercion.CoercionHelper;

public abstract class AbstractParameterStorage
implements ParameterStorage {
    @Override
    public final boolean getBoolean(String string) {
        String string2 = this.getString(string);
        return string2 == null ? false : Boolean.parseBoolean(string2);
    }

    @Override
    public final Date getDate(String string) {
        Long l = this.getLong(string);
        return l == null ? null : new Date(l);
    }

    @Override
    public final BigDecimal getDecimal(String string) {
        String string2 = this.getString(string);
        return string2 == null ? null : (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)string2);
    }

    @Override
    public final List<BigDecimal> getDecimalList(String string) {
        List<String> list = this.getStringList(string);
        if (list == null) {
            return null;
        }
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>(list.size());
        for (String string2 : list) {
            arrayList.add((BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)string2));
        }
        return arrayList;
    }

    @Override
    public final <T extends Enum<T>> T getEnum(String string, Class<T> clazz) {
        String string2 = this.getString(string);
        return (T)(string2 == null ? null : (Enum)CoercionHelper.coerce(clazz, (Object)string2));
    }

    @Override
    public final <T extends Enum<T>> List<T> getEnumList(String string, Class<T> clazz) {
        List<String> list = this.getStringList(string);
        if (list == null) {
            return null;
        }
        ArrayList<Enum> arrayList = new ArrayList<Enum>(list.size());
        for (String string2 : list) {
            arrayList.add((Enum)CoercionHelper.coerce(clazz, (Object)string2));
        }
        return arrayList;
    }

    @Override
    public final Integer getInteger(String string) {
        String string2 = this.getString(string);
        return string2 == null ? null : (Integer)CoercionHelper.coerce(Integer.class, (Object)string2);
    }

    @Override
    public final List<Integer> getIntegerList(String string) {
        List<String> list = this.getStringList(string);
        if (list == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        for (String string2 : list) {
            arrayList.add((Integer)CoercionHelper.coerce(Integer.class, (Object)string2));
        }
        return arrayList;
    }

    @Override
    public final Long getLong(String string) {
        String string2 = this.getString(string);
        return string2 == null ? null : (Long)CoercionHelper.coerce(Long.class, (Object)string2);
    }

    @Override
    public final List<Long> getLongList(String string) {
        List<String> list = this.getStringList(string);
        if (list == null) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
        for (String string2 : list) {
            arrayList.add((Long)CoercionHelper.coerce(Long.class, (Object)string2));
        }
        return arrayList;
    }

    @Override
    public final boolean isSet(String string) {
        return this.getString(string) != null;
    }

    @Override
    public final void setBoolean(String string, boolean bl) {
        this.setString(string, String.valueOf(bl));
    }

    @Override
    public final void setDate(String string, Date date) {
        Long l = date == null ? null : Long.valueOf(date.getTime());
        this.setLong(string, l);
    }

    @Override
    public final void setDecimal(String string, BigDecimal ... bigDecimalArray) {
        if (CollectionHelper.isEmpty((Object[])bigDecimalArray)) {
            this.remove(string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(bigDecimalArray.length);
            for (BigDecimal bigDecimal : bigDecimalArray) {
                if (bigDecimal == null) continue;
                arrayList.add(bigDecimal.toString());
            }
            this.doSet(string, arrayList);
        }
    }

    @Override
    public final void setEnum(String string, Enum<?> ... enumArray) {
        if (CollectionHelper.isEmpty((Object[])enumArray)) {
            this.remove(string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
            for (Enum<?> enum_ : enumArray) {
                if (enum_ == null) continue;
                arrayList.add(enum_.name());
            }
            this.doSet(string, arrayList);
        }
    }

    @Override
    public final void setInteger(String string, Integer ... integerArray) {
        if (CollectionHelper.isEmpty((Object[])integerArray)) {
            this.remove(string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(integerArray.length);
            for (Integer n : integerArray) {
                if (n == null) continue;
                arrayList.add(n.toString());
            }
            this.doSet(string, arrayList);
        }
    }

    @Override
    public final void setLong(String string, Long ... longArray) {
        if (CollectionHelper.isEmpty((Object[])longArray)) {
            this.remove(string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(longArray.length);
            for (Long l : longArray) {
                if (l == null) continue;
                arrayList.add(l.toString());
            }
            this.doSet(string, arrayList);
        }
    }

    @Override
    public final void setString(String string, String ... stringArray) {
        if (CollectionHelper.isEmpty((Object[])stringArray)) {
            this.remove(string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            this.doSet(string, arrayList);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (String string : CollectionHelper.iterable(this.getNames())) {
            List<String> list = this.getStringList(string);
            if (CollectionHelper.isEmpty(list)) continue;
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string).append(":");
            if (list.size() == 1) {
                stringBuilder.append((String)CollectionHelper.first(list));
                continue;
            }
            stringBuilder.append(list);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    protected abstract void doSet(String var1, List<String> var2);
}

