/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.Property;
import org.cyclos.model.banking.transactions.HasTransactionNumber;
import org.cyclos.model.marketplace.fields.AdCustomFieldActions;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueVO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.DynamicFieldValueVO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.fields.ICustomFieldPossibleValue;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.ICustomFieldValueWithList;
import org.cyclos.model.system.fields.ICustomFieldValueWithSet;
import org.cyclos.model.system.fields.IDynamicFieldValue;
import org.cyclos.model.system.fields.LinkedAdVO;
import org.cyclos.model.system.fields.LinkedEntityVO;
import org.cyclos.model.system.fields.LinkedRecordVO;
import org.cyclos.model.system.fields.LinkedTransactionVO;
import org.cyclos.model.system.fields.LinkedTransferVO;
import org.cyclos.model.system.fields.LinkedUserVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.fields.UserCustomFieldDetailedVO;
import org.cyclos.model.users.fields.UserCustomFieldValueDTO;
import org.cyclos.model.users.products.UserBasicFieldActions;
import org.cyclos.model.users.products.UserCustomFieldActions;
import org.cyclos.model.users.products.UserProfileFieldActions;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.users.usersections.UserSectionDetailedVO;
import org.cyclos.model.utils.DateWrapper;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.IDate;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;

public class CustomFieldHelper {
    private static final List<Property<? extends EntityVO, ?>> LINKED_ENTITY_VO_PROPERTIES = Collections.unmodifiableList(Arrays.asList(LinkedUserVO.USER, LinkedTransactionVO.TRANSACTION, LinkedTransferVO.TRANSFER, LinkedAdVO.AD, LinkedRecordVO.RECORD));
    public static String VALUE_SEPARATOR = "|";
    public static Comparator<ICustomFieldPossibleValue<?>> POSSIBLE_VALUES_COMPARATOR = Comparator.comparing(ICustomFieldPossibleValue::getValue, Comparator.nullsFirst(Comparator.naturalOrder()));
    public static Comparator<IDynamicFieldValue> DYNAMIC_VALUES_COMPARATOR = Comparator.comparing(IDynamicFieldValue::asString);

    public static void fillNewFieldValue(CustomFieldDetailedVO customFieldDetailedVO, CustomFieldValueDTO customFieldValueDTO) {
        customFieldValueDTO.setField(customFieldDetailedVO);
        Object object = CustomFieldHelper.getDefaultValue(customFieldDetailedVO);
        CustomFieldHelper.setCustomFieldValue(customFieldValueDTO, object);
    }

    public static void fillNewFieldValue(UserCustomFieldDetailedVO userCustomFieldDetailedVO, UserCustomFieldValueDTO userCustomFieldValueDTO) {
        CustomFieldHelper.fillNewFieldValue((CustomFieldDetailedVO)userCustomFieldDetailedVO, (CustomFieldValueDTO)userCustomFieldValueDTO);
        userCustomFieldValueDTO.setHidden(userCustomFieldDetailedVO.isHiddenByDefault());
    }

    public static UserProfileFieldActions findActions(ProfileField profileField, Iterable<UserProfileFieldActions> iterable) {
        for (UserProfileFieldActions userProfileFieldActions : iterable) {
            if (!Objects.equals(profileField, CustomFieldHelper.getProfileField(userProfileFieldActions))) continue;
            return userProfileFieldActions;
        }
        return null;
    }

    public static UserCustomFieldValueDTO findUserValueOrNew(CustomFieldDetailedVO customFieldDetailedVO, Collection<UserCustomFieldValueDTO> collection) {
        return CustomFieldHelper.findValueOrNew(customFieldDetailedVO, collection, customFieldDetailedVO2 -> {
            UserCustomFieldValueDTO userCustomFieldValueDTO = new UserCustomFieldValueDTO();
            CustomFieldHelper.fillNewFieldValue(customFieldDetailedVO, (CustomFieldValueDTO)userCustomFieldValueDTO);
            if (customFieldDetailedVO instanceof UserCustomFieldDetailedVO) {
                UserCustomFieldDetailedVO userCustomFieldDetailedVO = (UserCustomFieldDetailedVO)customFieldDetailedVO;
                userCustomFieldValueDTO.setHidden(userCustomFieldDetailedVO.isHiddenByDefault());
            }
            return userCustomFieldValueDTO;
        });
    }

    public static <V extends ICustomFieldValue<?, ?, ?, ?>> V findValue(ICustomField iCustomField, Collection<? extends V> collection) {
        if (iCustomField == null || collection == null) {
            return null;
        }
        for (ICustomFieldValue iCustomFieldValue : collection) {
            ICustomField iCustomField2 = iCustomFieldValue == null ? null : iCustomFieldValue.getField();
            if (iCustomField2 == null) continue;
            if (iCustomField.equals(iCustomField2) || iCustomField.getId().equals(iCustomField2.getId())) {
                return (V)iCustomFieldValue;
            }
            String string = ModelHelper.unqualifyInternalName(iCustomField2.getInternalName());
            if (string == null || !string.equals(ModelHelper.unqualifyInternalName(iCustomField.getInternalName()))) continue;
            return (V)iCustomFieldValue;
        }
        return null;
    }

    public static CustomFieldValueDTO findValueOrNew(CustomFieldDetailedVO customFieldDetailedVO, Collection<CustomFieldValueDTO> collection) {
        return CustomFieldHelper.findValueOrNew(customFieldDetailedVO, collection, CustomFieldHelper::newFieldValue);
    }

    public static <DTO extends CustomFieldValueDTO> DTO findValueOrNew(CustomFieldDetailedVO customFieldDetailedVO, Collection<DTO> collection, Function<CustomFieldDetailedVO, DTO> function) {
        if (collection == null) {
            return null;
        }
        CustomFieldValueDTO customFieldValueDTO = (CustomFieldValueDTO)CustomFieldHelper.findValue(customFieldDetailedVO, collection);
        if (customFieldValueDTO == null) {
            customFieldValueDTO = (CustomFieldValueDTO)function.apply(customFieldDetailedVO);
            collection.add(customFieldValueDTO);
        }
        return (DTO)customFieldValueDTO;
    }

    public static List<UserCustomFieldDetailedVO> getCustomFields(Iterable<UserProfileFieldActions> iterable) {
        ArrayList<UserCustomFieldDetailedVO> arrayList = new ArrayList<UserCustomFieldDetailedVO>();
        for (UserProfileFieldActions userProfileFieldActions : iterable) {
            if (!(userProfileFieldActions instanceof UserCustomFieldActions)) continue;
            UserCustomFieldActions userCustomFieldActions = (UserCustomFieldActions)userProfileFieldActions;
            arrayList.add(userCustomFieldActions.getCustomField());
        }
        return arrayList;
    }

    public static Object getCustomFieldValue(CustomFieldType customFieldType, ICustomFieldValue iCustomFieldValue) {
        if (iCustomFieldValue == null) {
            return null;
        }
        switch (customFieldType) {
            case URL: 
            case STRING: {
                return ObjectHelper.emptyToNull((Object)iCustomFieldValue.getStringValue());
            }
            case DYNAMIC_SELECTION: {
                if (iCustomFieldValue.getStringValue() == null) {
                    return null;
                }
                return new DynamicFieldValueVO(iCustomFieldValue.getStringValue(), iCustomFieldValue.getTextValue());
            }
            case DYNAMIC_MULTI_SELECTION: {
                return ObjectHelper.emptyToNull(CustomFieldHelper.getDynamicValues(iCustomFieldValue));
            }
            case SINGLE_SELECTION: {
                return ObjectHelper.emptyToNull(iCustomFieldValue.getEnumeratedValue());
            }
            case MULTI_SELECTION: {
                return ObjectHelper.emptyToNull(CustomFieldHelper.getEnumeratedValues(iCustomFieldValue));
            }
            case BOOLEAN: {
                return ObjectHelper.emptyToNull((Object)iCustomFieldValue.getBooleanValue());
            }
            case DATE: {
                Object object = iCustomFieldValue.getDateValue();
                if (object instanceof DateWrapper) {
                    object = ((DateWrapper)object).getDate();
                }
                return ObjectHelper.emptyToNull((Object)object);
            }
            case DECIMAL: {
                return ObjectHelper.emptyToNull((Object)iCustomFieldValue.getDecimalValue());
            }
            case INTEGER: {
                return ObjectHelper.emptyToNull((Object)iCustomFieldValue.getIntegerValue());
            }
            case TEXT: {
                return ObjectHelper.emptyToNull((Object)iCustomFieldValue.getTextValue());
            }
            case RICH_TEXT: {
                return ObjectHelper.emptyToNull((Object)iCustomFieldValue.getRichTextValue());
            }
            case LINKED_ENTITY: {
                return ObjectHelper.emptyToNull((Object)((Object)iCustomFieldValue.getLinkedEntityValue()));
            }
            case FILE: {
                return ObjectHelper.emptyToNull(iCustomFieldValue.getFileValues());
            }
            case IMAGE: {
                return ObjectHelper.emptyToNull(iCustomFieldValue.getImageValues());
            }
        }
        throw new IllegalArgumentException("Can't retrieve value for custom field value: unknown type " + String.valueOf(iCustomFieldValue.getField().getType()));
    }

    public static Object getCustomFieldValue(ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue) {
        if (iCustomFieldValue == null) {
            return null;
        }
        return CustomFieldHelper.getCustomFieldValue(iCustomFieldValue.getField().getType(), iCustomFieldValue);
    }

    public static Object getDefaultValue(CustomFieldDetailedVO customFieldDetailedVO) {
        if (customFieldDetailedVO == null) {
            return null;
        }
        switch (customFieldDetailedVO.getType()) {
            case URL: 
            case STRING: {
                return customFieldDetailedVO.getDefaultStringValue();
            }
            case SINGLE_SELECTION: {
                if (customFieldDetailedVO.getPossibleValues() != null) {
                    for (CustomFieldPossibleValueVO customFieldPossibleValueVO : customFieldDetailedVO.getPossibleValues()) {
                        if (!customFieldPossibleValueVO.isDefaultValue()) continue;
                        return customFieldPossibleValueVO;
                    }
                }
                return null;
            }
            case DYNAMIC_SELECTION: {
                if (customFieldDetailedVO.getDynamicValues() != null) {
                    for (DynamicFieldValueVO dynamicFieldValueVO : customFieldDetailedVO.getDynamicValues()) {
                        if (!dynamicFieldValueVO.isDefaultValue()) continue;
                        return dynamicFieldValueVO;
                    }
                }
                return null;
            }
            case DYNAMIC_MULTI_SELECTION: {
                return CollectionHelper.orEmpty(customFieldDetailedVO.getDynamicValues()).stream().filter(DynamicFieldValueVO::isDefaultValue).collect(Collectors.toSet());
            }
            case MULTI_SELECTION: {
                return CollectionHelper.orEmpty(customFieldDetailedVO.getPossibleValues()).stream().filter(CustomFieldPossibleValueVO::isDefaultValue).collect(Collectors.toSet());
            }
            case BOOLEAN: {
                return customFieldDetailedVO.getDefaultBooleanValue();
            }
            case DATE: {
                return customFieldDetailedVO.getDefaultDateValue();
            }
            case DECIMAL: {
                return customFieldDetailedVO.getDefaultDecimalValue();
            }
            case INTEGER: {
                return customFieldDetailedVO.getDefaultIntegerValue();
            }
            case TEXT: {
                return customFieldDetailedVO.getDefaultTextValue();
            }
            case RICH_TEXT: {
                return customFieldDetailedVO.getDefaultRichTextValue();
            }
            case LINKED_ENTITY: {
                switch (customFieldDetailedVO.getLinkedEntityType()) {
                    case USER: {
                        return customFieldDetailedVO.getDefaultUserValue();
                    }
                }
                break;
            }
            case FILE: 
            case IMAGE: {
                return new ArrayList();
            }
        }
        return null;
    }

    public static Collection<DynamicFieldValueVO> getDynamicValues(ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue) {
        if (StringHelper.isNotBlank((Object)iCustomFieldValue.getStringValue())) {
            DynamicFieldValueVO dynamicFieldValueVO = new DynamicFieldValueVO();
            dynamicFieldValueVO.setLabel((String)ObjectHelper.defaultValue((Object)iCustomFieldValue.getTextValue(), (Object)iCustomFieldValue.getStringValue()));
            dynamicFieldValueVO.setValue(iCustomFieldValue.getStringValue());
            return Collections.singleton(dynamicFieldValueVO);
        }
        if (iCustomFieldValue instanceof ICustomFieldValueWithList) {
            return ((ICustomFieldValueWithList)iCustomFieldValue).getDynamicValues();
        }
        if (iCustomFieldValue instanceof ICustomFieldValueWithSet) {
            return new LinkedHashSet<DynamicFieldValueVO>(CollectionHelper.sort(((ICustomFieldValueWithSet)iCustomFieldValue).getDynamicValues(), DYNAMIC_VALUES_COMPARATOR));
        }
        return null;
    }

    public static Collection<CustomFieldPossibleValueVO> getEnumeratedValues(ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue) {
        if (iCustomFieldValue.getEnumeratedValue() != null) {
            return Collections.singleton((CustomFieldPossibleValueVO)iCustomFieldValue.getEnumeratedValue());
        }
        if (iCustomFieldValue instanceof ICustomFieldValueWithList) {
            return ((ICustomFieldValueWithList)iCustomFieldValue).getEnumeratedValues();
        }
        if (iCustomFieldValue instanceof ICustomFieldValueWithSet) {
            return new LinkedHashSet<CustomFieldPossibleValueVO>(CollectionHelper.sort(((ICustomFieldValueWithSet)iCustomFieldValue).getEnumeratedValues(), POSSIBLE_VALUES_COMPARATOR));
        }
        return null;
    }

    public static EntityVO getLinkedEntity(LinkedEntityVO linkedEntityVO) {
        if (linkedEntityVO == null) {
            return null;
        }
        return (EntityVO)ModelHelper.getFirstNonEmpty((Bean)linkedEntityVO, LINKED_ENTITY_VO_PROPERTIES);
    }

    public static ProfileField getProfileField(UserProfileFieldActions userProfileFieldActions) {
        if (userProfileFieldActions instanceof UserBasicFieldActions) {
            return ((UserBasicFieldActions)userProfileFieldActions).getBasicField();
        }
        if (userProfileFieldActions instanceof UserCustomFieldActions) {
            return ((UserCustomFieldActions)userProfileFieldActions).getCustomField();
        }
        return null;
    }

    public static String getReferenceValue(ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue) {
        if (iCustomFieldValue instanceof CustomFieldValueDTO) {
            return ((CustomFieldValueDTO)iCustomFieldValue).getReferenceValue();
        }
        return null;
    }

    public static Map<Long, UserSectionDetailedVO> getUserSectionsById(List<UserCustomFieldDetailedVO> list) {
        Set set = list.stream().map(UserCustomFieldDetailedVO::getSection).filter(userSectionDetailedVO -> userSectionDetailedVO != null).collect(Collectors.toSet());
        return CollectionHelper.orEmpty(set).stream().collect(Collectors.toMap(EntityModel::getId, userSectionDetailedVO -> userSectionDetailedVO));
    }

    public static Object getValue(Long l, Collection<? extends ICustomFieldValue<?, ?, ?, ?>> collection) {
        if (collection != null) {
            for (ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue : collection) {
                Long l2 = iCustomFieldValue.getField().getId();
                if (l2 == null || !l2.equals(l)) continue;
                return CustomFieldHelper.getCustomFieldValue(iCustomFieldValue);
            }
        }
        return null;
    }

    public static Object getValue(String string, Collection<? extends ICustomFieldValue<?, ?, ?, ?>> collection) {
        for (ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue : collection) {
            String string2 = ModelHelper.unqualifyInternalName(iCustomFieldValue.getField());
            if (string2 == null || !string.equals(string2) && !string2.endsWith("/" + string)) continue;
            return CustomFieldHelper.getCustomFieldValue(iCustomFieldValue);
        }
        return null;
    }

    public static Object getValue(UserWithFieldsVO userWithFieldsVO, ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            BasicProfileField basicProfileField = (BasicProfileField)profileField;
            Property<?, ? super UserWithFieldsVO> property = ModelHelper.userWithFieldsProperty(basicProfileField);
            return userWithFieldsVO.get(property);
        }
        if (profileField instanceof ICustomField) {
            ICustomField iCustomField = (ICustomField)((Object)profileField);
            return CustomFieldHelper.findValue(iCustomField, userWithFieldsVO.getCustomValues());
        }
        return null;
    }

    public static List<?> getValuesList(CustomFieldDetailedVO customFieldDetailedVO) {
        if (!customFieldDetailedVO.isHasValuesList()) {
            return null;
        }
        CustomFieldType customFieldType = customFieldDetailedVO.getType();
        if (customFieldType.isDynamic()) {
            return customFieldDetailedVO.getDynamicValues();
        }
        if (customFieldType.isEnumerated()) {
            return customFieldDetailedVO.getPossibleValues();
        }
        if (customFieldType.isString()) {
            return customFieldDetailedVO.getStringValues();
        }
        if (customFieldType == CustomFieldType.DATE) {
            return customFieldDetailedVO.getDateValues();
        }
        if (customFieldType == CustomFieldType.INTEGER) {
            return customFieldDetailedVO.getIntegerValues();
        }
        if (customFieldType == CustomFieldType.DECIMAL) {
            return customFieldDetailedVO.getDecimalValues();
        }
        if (customFieldType == CustomFieldType.LINKED_ENTITY) {
            switch (customFieldDetailedVO.getLinkedEntityType()) {
                case ADVERTISEMENT: {
                    return customFieldDetailedVO.getAdValues();
                }
                case RECORD: {
                    return customFieldDetailedVO.getRecordValues();
                }
                case TRANSACTION: {
                    return customFieldDetailedVO.getTransactionValues();
                }
                case TRANSFER: {
                    return customFieldDetailedVO.getTransferValues();
                }
                case USER: {
                    return customFieldDetailedVO.getUserValues();
                }
            }
        }
        return Collections.emptyList();
    }

    public static boolean hasAnyFieldWithInformation(Collection<?> collection) {
        return CollectionHelper.isNotEmpty(collection) && collection.stream().filter(object -> {
            CustomFieldDetailedVO customFieldDetailedVO = null;
            if (object instanceof UserCustomFieldActions) {
                customFieldDetailedVO = ((UserCustomFieldActions)((Object)((Object)object))).getCustomField();
            } else if (object instanceof AdCustomFieldActions) {
                customFieldDetailedVO = ((AdCustomFieldActions)((Object)((Object)object))).getCustomField();
            } else if (object instanceof CustomFieldDetailedVO) {
                customFieldDetailedVO = (CustomFieldDetailedVO)object;
            }
            return customFieldDetailedVO != null && StringHelper.isNotBlank((Object)customFieldDetailedVO.getInformationText());
        }).findFirst().isPresent();
    }

    public static boolean hasValue(CustomFieldValueDTO customFieldValueDTO) {
        if (customFieldValueDTO == null) {
            return false;
        }
        String string = CustomFieldHelper.getReferenceValue(customFieldValueDTO);
        if (StringHelper.isNotBlank((Object)string)) {
            return true;
        }
        CustomFieldType customFieldType = customFieldValueDTO.getField().getType();
        switch (customFieldType) {
            case URL: 
            case STRING: {
                return StringHelper.isNotBlank((Object)customFieldValueDTO.getStringValue());
            }
            case TEXT: {
                return StringHelper.isNotBlank((Object)customFieldValueDTO.getTextValue());
            }
            case RICH_TEXT: {
                return StringHelper.isNotBlank((Object)customFieldValueDTO.getRichTextValue());
            }
            case BOOLEAN: {
                return StringHelper.isNotBlank((Object)customFieldValueDTO.getBooleanValue());
            }
            case DATE: {
                return StringHelper.isNotBlank((Object)customFieldValueDTO.getDateValue());
            }
            case INTEGER: {
                return StringHelper.isNotBlank((Object)customFieldValueDTO.getIntegerValue());
            }
            case DECIMAL: {
                return StringHelper.isNotBlank((Object)customFieldValueDTO.getDecimalValue());
            }
            case SINGLE_SELECTION: {
                return customFieldValueDTO.getEnumeratedValue() != null;
            }
            case MULTI_SELECTION: {
                return CollectionHelper.isNotEmpty(CustomFieldHelper.getEnumeratedValues(customFieldValueDTO));
            }
            case DYNAMIC_SELECTION: {
                return StringHelper.isNotBlank((Object)customFieldValueDTO.getStringValue());
            }
            case DYNAMIC_MULTI_SELECTION: {
                return CollectionHelper.isNotEmpty(CustomFieldHelper.getDynamicValues(customFieldValueDTO));
            }
            case LINKED_ENTITY: {
                return customFieldValueDTO.getLinkedEntityValue() != null;
            }
            case FILE: {
                return CollectionHelper.isNotEmpty(customFieldValueDTO.getFileValues());
            }
            case IMAGE: {
                return CollectionHelper.isNotEmpty(customFieldValueDTO.getImageValues());
            }
        }
        return false;
    }

    public static CustomFieldValueDTO newFieldValue(CustomFieldDetailedVO customFieldDetailedVO) {
        CustomFieldValueDTO customFieldValueDTO = new CustomFieldValueDTO();
        CustomFieldHelper.fillNewFieldValue(customFieldDetailedVO, customFieldValueDTO);
        return customFieldValueDTO;
    }

    public static void qualifyInternalName(String string, CustomFieldPossibleValueVO customFieldPossibleValueVO) {
        String string2 = string + ".";
        if (customFieldPossibleValueVO == null || StringHelper.isBlank((Object)customFieldPossibleValueVO.getInternalName()) || customFieldPossibleValueVO.getInternalName().startsWith(string2)) {
            return;
        }
        customFieldPossibleValueVO.setInternalName(string2 + customFieldPossibleValueVO.getInternalName());
    }

    public static <FV extends ICustomFieldValue> FV setCustomFieldValue(FV FV, Object object) {
        if (FV == null) {
            return null;
        }
        CustomFieldType customFieldType = FV.getField().getType();
        switch (customFieldType) {
            case URL: 
            case STRING: {
                FV.setStringValue((String)object);
                break;
            }
            case SINGLE_SELECTION: {
                FV.setEnumeratedValue((ICustomFieldPossibleValue)((ICustomFieldPossibleValue)object));
                break;
            }
            case MULTI_SELECTION: {
                Consumer<Collection> consumer = collection -> {
                    if (object instanceof ICustomFieldPossibleValue) {
                        collection.add(object);
                    } else if (object instanceof Collection) {
                        collection.addAll((Collection)object);
                    }
                };
                if (FV instanceof ICustomFieldValueWithList) {
                    ArrayList arrayList = new ArrayList();
                    consumer.accept(arrayList);
                    ((ICustomFieldValueWithList)FV).setEnumeratedValues(arrayList);
                    break;
                }
                if (FV instanceof ICustomFieldValueWithSet) {
                    HashSet hashSet = new HashSet();
                    consumer.accept(hashSet);
                    ((ICustomFieldValueWithSet)FV).setEnumeratedValues(hashSet);
                    break;
                }
                throw new IllegalArgumentException("Not a valid custom field value");
            }
            case DYNAMIC_SELECTION: {
                String string = null;
                String string2 = null;
                if (object instanceof String) {
                    string = (String)object;
                } else if (object instanceof IDynamicFieldValue) {
                    IDynamicFieldValue iDynamicFieldValue = (IDynamicFieldValue)object;
                    string = iDynamicFieldValue.getValue();
                    string2 = iDynamicFieldValue.getLabel();
                }
                FV.setStringValue(string);
                FV.setTextValue(string2);
                break;
            }
            case DYNAMIC_MULTI_SELECTION: {
                Consumer<Collection> consumer = collection -> {
                    if (object instanceof IDynamicFieldValue) {
                        collection.add(object);
                    } else if (object instanceof Collection) {
                        collection.addAll((Collection)object);
                    }
                };
                if (FV instanceof ICustomFieldValueWithList) {
                    ArrayList arrayList = new ArrayList();
                    consumer.accept(arrayList);
                    ((ICustomFieldValueWithList)FV).setDynamicValues(arrayList);
                    break;
                }
                if (FV instanceof ICustomFieldValueWithSet) {
                    HashSet hashSet = new HashSet();
                    consumer.accept(hashSet);
                    ((ICustomFieldValueWithSet)FV).setDynamicValues(hashSet);
                    break;
                }
                throw new IllegalArgumentException("Not a valid custom field value");
            }
            case FILE: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (object instanceof Collection) {
                    arrayList.addAll((Collection)object);
                } else if (object != null) {
                    arrayList.add(object);
                }
                FV.setFileValues(arrayList);
                break;
            }
            case IMAGE: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (object instanceof Collection) {
                    arrayList.addAll((Collection)object);
                } else if (object != null) {
                    arrayList.add(object);
                }
                FV.setImageValues(arrayList);
                break;
            }
            case BOOLEAN: {
                FV.setBooleanValue((Boolean)CoercionHelper.coerce(Boolean.class, (Object)object));
                break;
            }
            case DATE: {
                if (object instanceof Date) {
                    FV.setDateValue(DateWrapper.instance((Date)object));
                    break;
                }
                FV.setDateValue((IDate)object);
                break;
            }
            case DECIMAL: {
                FV.setDecimalValue((BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)object));
                break;
            }
            case INTEGER: {
                FV.setIntegerValue((Integer)CoercionHelper.coerce(Integer.class, (Object)object));
                break;
            }
            case TEXT: {
                FV.setTextValue((String)CoercionHelper.coerce(String.class, (Object)object));
                break;
            }
            case RICH_TEXT: {
                FV.setRichTextValue((String)CoercionHelper.coerce(String.class, (Object)object));
                break;
            }
            case LINKED_ENTITY: {
                LinkedEntityVO linkedEntityVO = null;
                Long l = null;
                String string = null;
                String string3 = null;
                if (object instanceof Number) {
                    l = ((Number)object).longValue();
                } else if (object instanceof IEntity) {
                    l = ((IEntity)object).getId();
                    if (object instanceof IInternalNamedEntity) {
                        string = ((IInternalNamedEntity)object).getInternalName();
                    } else if (object instanceof UserLocatorVO) {
                        string = ((UserLocatorVO)object).getPrincipal();
                    } else if (object instanceof HasTransactionNumber) {
                        string = ((HasTransactionNumber)object).getTransactionNumber();
                    }
                    if (object instanceof INamedEntity) {
                        string3 = ((INamedEntity)object).getName();
                    } else if (object instanceof BasicUserVO) {
                        string3 = ((BasicUserVO)object).getDisplay();
                    }
                } else if (object != null) {
                    String string4 = object.toString();
                    try {
                        l = Long.parseLong(string4);
                    }
                    catch (Exception exception) {
                        string = StringHelper.removeStart((String)string4, (String)"'");
                    }
                }
                if (l != null || string != null) {
                    linkedEntityVO = new LinkedEntityVO(l);
                    linkedEntityVO.setInternalName(string);
                    linkedEntityVO.setName(string3);
                }
                FV.setLinkedEntityValue(linkedEntityVO);
            }
        }
        return FV;
    }

    public static boolean setValue(String string, Collection<? extends ICustomFieldValue<?, ?, ?, ?>> collection, Object object) {
        for (ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue : collection) {
            String string2 = ModelHelper.unqualifyInternalName(iCustomFieldValue.getField());
            if (!string.equals(string2)) continue;
            CustomFieldHelper.setCustomFieldValue(iCustomFieldValue, object);
            return true;
        }
        return false;
    }

    public static Map<String, ICustomField> toFieldsMap(Collection<? extends ICustomField> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        HashMap<String, ICustomField> hashMap = new HashMap<String, ICustomField>();
        for (ICustomField iCustomField : collection) {
            if (hashMap.containsKey(iCustomField.getInternalName())) {
                throw new IllegalArgumentException("The custom fields collection contains more than one occurrence for the same field: " + iCustomField.getInternalName());
            }
            hashMap.put(ModelHelper.unqualifyInternalName(iCustomField), iCustomField);
        }
        return hashMap;
    }

    public static Map<ICustomField, ICustomFieldValue> toMap(Collection<? extends ICustomFieldValue> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        HashMap<ICustomField, ICustomFieldValue> hashMap = new HashMap<ICustomField, ICustomFieldValue>();
        for (ICustomFieldValue iCustomFieldValue : collection) {
            if (hashMap.containsKey(iCustomFieldValue.getField())) {
                throw new IllegalArgumentException("The custom values collection contains more than one value for the field: " + iCustomFieldValue.getField().getInternalName());
            }
            hashMap.put(iCustomFieldValue.getField(), iCustomFieldValue);
        }
        return hashMap;
    }

    public static String toReference(ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO> iCustomFieldValue) {
        if (iCustomFieldValue == null) {
            return null;
        }
        CustomFieldType customFieldType = iCustomFieldValue.getField().getType();
        String string = CustomFieldHelper.getReferenceValue(iCustomFieldValue);
        if (string != null || customFieldType == null) {
            return string;
        }
        switch (customFieldType) {
            case URL: 
            case STRING: {
                return StringHelper.trimToNull((Object)iCustomFieldValue.getStringValue());
            }
            case TEXT: {
                return StringHelper.trimToNull((Object)iCustomFieldValue.getTextValue());
            }
            case RICH_TEXT: {
                return StringHelper.trimToNull((Object)iCustomFieldValue.getRichTextValue());
            }
            case BOOLEAN: {
                return StringHelper.trimToNull((Object)iCustomFieldValue.getBooleanValue());
            }
            case DATE: {
                return StringHelper.trimToNull((Object)iCustomFieldValue.getDateValue());
            }
            case INTEGER: {
                return StringHelper.trimToNull((Object)iCustomFieldValue.getIntegerValue());
            }
            case DECIMAL: {
                return StringHelper.trimToNull((Object)iCustomFieldValue.getDecimalValue());
            }
            case SINGLE_SELECTION: {
                return ModelHelper.unqualifiedInternalNameOrId(iCustomFieldValue.getEnumeratedValue());
            }
            case MULTI_SELECTION: {
                return CustomFieldHelper.customFieldValuesToString(CustomFieldHelper.getEnumeratedValues(iCustomFieldValue));
            }
            case DYNAMIC_SELECTION: {
                String string2 = StringHelper.trimToNull((Object)iCustomFieldValue.getStringValue());
                if (string2 == null) {
                    return null;
                }
                String string3 = StringHelper.trimToNull((Object)iCustomFieldValue.getTextValue());
                return string3 == null ? string2 : string2 + VALUE_SEPARATOR + string3;
            }
            case DYNAMIC_MULTI_SELECTION: {
                return CustomFieldHelper.dynamicValuesToString(CustomFieldHelper.getDynamicValues(iCustomFieldValue));
            }
            case LINKED_ENTITY: {
                LinkedEntityVO linkedEntityVO = iCustomFieldValue.getLinkedEntityValue();
                if (linkedEntityVO == null) {
                    return null;
                }
                EntityVO entityVO = CustomFieldHelper.getLinkedEntity(linkedEntityVO);
                String string4 = ModelHelper.internalNameOrId((IEntity)linkedEntityVO);
                String string5 = entityVO == null ? null : entityVO.toString();
                return string4 + (String)(string5 == null ? "" : VALUE_SEPARATOR + string5);
            }
            case FILE: {
                return CustomFieldHelper.customFieldValuesToString(iCustomFieldValue.getFileValues());
            }
            case IMAGE: {
                return CustomFieldHelper.customFieldValuesToString(iCustomFieldValue.getImageValues());
            }
        }
        return null;
    }

    private static String customFieldValuesToString(Collection<? extends IEntity> collection) {
        return StringHelper.trimToNull((Object)CollectionHelper.orEmpty(collection).stream().map(ModelHelper::unqualifiedInternalNameOrId).collect(Collectors.joining(VALUE_SEPARATOR)));
    }

    private static String dynamicValuesToString(Collection<? extends IDynamicFieldValue> collection) {
        return StringHelper.trimToNull((Object)CollectionHelper.orEmpty(collection).stream().map(IDynamicFieldValue::getValue).collect(Collectors.joining(VALUE_SEPARATOR)));
    }
}

