/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.model.banking.MaxAmountPerDayExceededException;
import org.cyclos.model.banking.MaxAmountPerMonthExceededException;
import org.cyclos.model.banking.MaxAmountPerWeekExceededException;
import org.cyclos.model.banking.MaxAmountPerYearExceededException;
import org.cyclos.model.banking.MaxPaymentAmountExceededException;
import org.cyclos.model.banking.MaxPaymentsPerDayExceededException;
import org.cyclos.model.banking.MaxPaymentsPerMonthExceededException;
import org.cyclos.model.banking.MaxPaymentsPerWeekExceededException;
import org.cyclos.model.banking.MinTimeBetweenPaymentsException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.UpperCreditLimitReachedException;
import org.cyclos.utils.TranslationMessageSpecification;

public class ExceptionTranslationHelper {
    public static TranslationMessageSpecification getForTransferException(TransferException transferException) {
        try {
            throw transferException;
        }
        catch (InsufficientBalanceException insufficientBalanceException) {
            return new TranslationMessageSpecification(insufficientBalanceException.isVoucher() ? BankingKeys.Transfers.ERROR_INSUFFICIENT_BALANCE_VOUCHER : BankingKeys.Transfers.ERROR_INSUFFICIENT_BALANCE);
        }
        catch (MaxPaymentsPerDayExceededException maxPaymentsPerDayExceededException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_MAX_PAYMENTS_PER_DAY_EXCEEDED, maxPaymentsPerDayExceededException.getMaxPayments());
        }
        catch (MaxPaymentsPerWeekExceededException maxPaymentsPerWeekExceededException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_MAX_PAYMENTS_PER_WEEK_EXCEEDED, maxPaymentsPerWeekExceededException.getMaxPayments());
        }
        catch (MaxPaymentsPerMonthExceededException maxPaymentsPerMonthExceededException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_MAX_PAYMENTS_PER_MONTH_EXCEEDED, maxPaymentsPerMonthExceededException.getMaxPayments());
        }
        catch (MinTimeBetweenPaymentsException minTimeBetweenPaymentsException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_MIN_TIME_BETWEEN_PAYMENTS_EXCEPTION);
        }
        catch (MaxAmountPerDayExceededException maxAmountPerDayExceededException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_MAX_AMOUNT_PER_DAY_EXCEEDED, maxAmountPerDayExceededException.getMaxAmount());
        }
        catch (MaxAmountPerWeekExceededException maxAmountPerWeekExceededException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_MAX_AMOUNT_PER_WEEK_EXCEEDED, maxAmountPerWeekExceededException.getMaxAmount());
        }
        catch (MaxAmountPerMonthExceededException maxAmountPerMonthExceededException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_MAX_AMOUNT_PER_MONTH_EXCEEDED, maxAmountPerMonthExceededException.getMaxAmount());
        }
        catch (MaxAmountPerYearExceededException maxAmountPerYearExceededException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_MAX_AMOUNT_PER_YEAR_EXCEEDED, maxAmountPerYearExceededException.getMaxAmount());
        }
        catch (MaxPaymentAmountExceededException maxPaymentAmountExceededException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_MAX_AMOUNT_EXCEEDED, maxPaymentAmountExceededException.getMaxAmount());
        }
        catch (UpperCreditLimitReachedException upperCreditLimitReachedException) {
            return new TranslationMessageSpecification(BankingKeys.Transfers.ERROR_UPPER_CREDIT_LIMIT_REACHED);
        }
    }
}

