/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.util.Objects;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Submodule;

public class MessageKeyImpl
implements MessageKey {
    private Submodule submodule;
    private String key;

    protected MessageKeyImpl(Submodule submodule, String string) {
        if (submodule == null) {
            throw new IllegalArgumentException("Can't create message key with a null submodule.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Can't create message key with a null key.");
        }
        this.submodule = submodule;
        this.key = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof MessageKey)) {
            return false;
        }
        MessageKey messageKey = (MessageKey)object;
        return Objects.equals(this.submodule, messageKey.submodule()) && Objects.equals(this.key, messageKey.key());
    }

    @Override
    public String fullKey() {
        return String.valueOf(this.submodule().module()) + "." + String.valueOf(this.submodule()) + "." + this.key;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.submodule == null ? 0 : this.submodule.hashCode());
        n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
        return n;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Submodule submodule() {
        return this.submodule;
    }

    public String toString() {
        return this.fullKey();
    }
}

