/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import org.cyclos.model.access.AccessSubmoduleMessageKeys;
import org.cyclos.model.app.AppSubmoduleMessageKeys;
import org.cyclos.model.banking.BankingSubmoduleMessageKeys;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.ContentManagementSubmoduleMessageKeys;
import org.cyclos.model.general.GeneralSubmoduleMessageKeys;
import org.cyclos.model.marketplace.MarketplaceSubmoduleMessageKeys;
import org.cyclos.model.messaging.MessagingSubmoduleMessageKeys;
import org.cyclos.model.mobile.MobileSubmoduleMessageKeys;
import org.cyclos.model.system.SystemSubmoduleMessageKeys;
import org.cyclos.model.users.UsersSubmoduleMessageKeys;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Module;
import org.cyclos.utils.Submodule;

public class ModuleMessageKeys
implements EnumMessageKeyResolver<Module> {
    private static ModuleMessageKeys instance;

    public static ModuleMessageKeys get() {
        if (instance == null) {
            instance = new ModuleMessageKeys();
        }
        return instance;
    }

    public static MessageKey resolveKeyForSubmodule(Submodule submodule) {
        EnumMessageKeyResolver<? extends Submodule> enumMessageKeyResolver = ModuleMessageKeys.resolverForSubmodule(submodule.module());
        return enumMessageKeyResolver.resolveKey((Submodule)((Enum)submodule));
    }

    public static EnumMessageKeyResolver<? extends Submodule> resolverForSubmodule(Module module) {
        switch (module) {
            case ACCESS: {
                return AccessSubmoduleMessageKeys.get();
            }
            case APP: {
                return AppSubmoduleMessageKeys.get();
            }
            case BANKING: {
                return BankingSubmoduleMessageKeys.get();
            }
            case CONTENT_MANAGEMENT: {
                return ContentManagementSubmoduleMessageKeys.get();
            }
            case GENERAL: {
                return GeneralSubmoduleMessageKeys.get();
            }
            case MARKETPLACE: {
                return MarketplaceSubmoduleMessageKeys.get();
            }
            case MESSAGING: {
                return MessagingSubmoduleMessageKeys.get();
            }
            case MOBILE: {
                return MobileSubmoduleMessageKeys.get();
            }
            case SYSTEM: {
                return SystemSubmoduleMessageKeys.get();
            }
            case USERS: {
                return UsersSubmoduleMessageKeys.get();
            }
        }
        throw new IllegalArgumentException();
    }

    private ModuleMessageKeys() {
    }

    @Override
    public MessageKey resolveKey(Module module) {
        if (module != null) {
            switch (module) {
                case ACCESS: {
                    return ContentManagementKeys.Translations.CATEGORY_ACCESS;
                }
                case APP: {
                    return ContentManagementKeys.Translations.CATEGORY_APP;
                }
                case BANKING: {
                    return ContentManagementKeys.Translations.CATEGORY_BANKING;
                }
                case CONTENT_MANAGEMENT: {
                    return ContentManagementKeys.Translations.CATEGORY_CONTENT_MANAGEMENT;
                }
                case GENERAL: {
                    return ContentManagementKeys.Translations.CATEGORY_GENERAL;
                }
                case MARKETPLACE: {
                    return ContentManagementKeys.Translations.CATEGORY_MARKETPLACE;
                }
                case MESSAGING: {
                    return ContentManagementKeys.Translations.CATEGORY_MESSAGING;
                }
                case MOBILE: {
                    return ContentManagementKeys.Translations.CATEGORY_MOBILE;
                }
                case SYSTEM: {
                    return ContentManagementKeys.Translations.CATEGORY_SYSTEM;
                }
                case USERS: {
                    return ContentManagementKeys.Translations.CATEGORY_USERS;
                }
            }
        }
        return null;
    }
}

