/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.cyclos.utils.TransformedSet;

public class TransformedMap<SK, SE, TK, TE>
extends AbstractMap<TK, TE> {
    private final Map<SK, SE> delegate;
    private final Function<SK, TK> keyTransformer;
    private final Function<SE, TE> elementTransformer;

    public TransformedMap(Map<SK, SE> map, Function<SK, TK> function, Function<SE, TE> function2) {
        this.delegate = map;
        this.keyTransformer = function;
        this.elementTransformer = function2;
    }

    @Override
    public Set<Map.Entry<TK, TE>> entrySet() {
        return new TransformedSet<Map.Entry, Map.Entry>(this.delegate.entrySet(), this::transform);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    private Map.Entry<TK, TE> transform(final Map.Entry<SK, SE> entry) {
        return new Map.Entry<TK, TE>(){

            @Override
            public TK getKey() {
                return TransformedMap.this.keyTransformer.apply(entry.getKey());
            }

            @Override
            public TE getValue() {
                return TransformedMap.this.elementTransformer.apply(entry.getValue());
            }

            @Override
            public TE setValue(TE TE) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

