/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.stream.Stream;
import org.cyclos.utils.GwtIncompatible;

@GwtIncompatible
public class URIHelper {
    public static String getDomain(URI uRI) {
        if (uRI == null) {
            return null;
        }
        int n = uRI.getPort();
        if (n < 1) {
            return String.format("%s://%s", uRI.getScheme(), uRI.getHost());
        }
        return URIHelper.getOrigin(uRI);
    }

    public static String getOrigin(URI uRI) {
        if (uRI == null) {
            return null;
        }
        int n = uRI.getPort();
        if (n < 1) {
            switch (uRI.getScheme()) {
                case "http": {
                    n = 80;
                    break;
                }
                case "https": {
                    n = 443;
                }
            }
        }
        return String.format("%s://%s:%d", uRI.getScheme(), uRI.getHost(), n);
    }

    public static boolean inSameOrigin(Stream<String> stream) {
        return stream.map(URIHelper::of).filter(Objects::nonNull).map(URIHelper::getOrigin).distinct().count() == 1L;
    }

    public static URI of(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

