/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import org.cyclos.model.general.GeneralKeys;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum WeekDay implements HasMessageKey
{
    SUNDAY,
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY;

    private static EnumMessageKeyResolver<WeekDay> resolverForShort;

    public static WeekDay fromCalendar(int n) {
        switch (n) {
            case 1: {
                return SUNDAY;
            }
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
        }
        throw new IllegalArgumentException("Expected a week day in the range 1 (sunday) to 7 (saturday)");
    }

    public static EnumMessageKeyResolver<WeekDay> resolverForShort() {
        if (resolverForShort == null) {
            resolverForShort = weekDay -> {
                switch (weekDay.ordinal()) {
                    case 0: {
                        return GeneralKeys.Ui.WEEK_DAY_SHORT_SUNDAY;
                    }
                    case 1: {
                        return GeneralKeys.Ui.WEEK_DAY_SHORT_MONDAY;
                    }
                    case 2: {
                        return GeneralKeys.Ui.WEEK_DAY_SHORT_TUESDAY;
                    }
                    case 3: {
                        return GeneralKeys.Ui.WEEK_DAY_SHORT_WEDNESDAY;
                    }
                    case 4: {
                        return GeneralKeys.Ui.WEEK_DAY_SHORT_THURSDAY;
                    }
                    case 6: {
                        return GeneralKeys.Ui.WEEK_DAY_SHORT_SATURDAY;
                    }
                    case 5: {
                        return GeneralKeys.Ui.WEEK_DAY_SHORT_FRIDAY;
                    }
                }
                return null;
            };
        }
        return resolverForShort;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return GeneralKeys.Ui.WEEK_DAY_SUNDAY;
            }
            case 1: {
                return GeneralKeys.Ui.WEEK_DAY_MONDAY;
            }
            case 2: {
                return GeneralKeys.Ui.WEEK_DAY_TUESDAY;
            }
            case 3: {
                return GeneralKeys.Ui.WEEK_DAY_WEDNESDAY;
            }
            case 4: {
                return GeneralKeys.Ui.WEEK_DAY_THURSDAY;
            }
            case 5: {
                return GeneralKeys.Ui.WEEK_DAY_FRIDAY;
            }
            case 6: {
                return GeneralKeys.Ui.WEEK_DAY_SATURDAY;
            }
        }
        return null;
    }

    public String toShortString() {
        switch (this.ordinal()) {
            case 0: {
                return "su";
            }
            case 1: {
                return "mo";
            }
            case 2: {
                return "tu";
            }
            case 3: {
                return "we";
            }
            case 4: {
                return "th";
            }
            case 5: {
                return "fr";
            }
            case 6: {
                return "sa";
            }
        }
        return null;
    }
}

