/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.mapping.get;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.action.ActionResponse;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.ParseField;
import org.opensearch.common.Strings;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public class GetMappingsResponse
extends ActionResponse
implements ToXContentFragment {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private final ImmutableOpenMap<String, MappingMetadata> mappings;

    public GetMappingsResponse(ImmutableOpenMap<String, MappingMetadata> mappings) {
        this.mappings = mappings;
    }

    GetMappingsResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder<String, MappingMetadata> indexMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            if (in.getVersion().before(Version.V_2_0_0)) {
                int mappingCount = in.readVInt();
                if (mappingCount == 0) {
                    indexMapBuilder.put(index, MappingMetadata.EMPTY_MAPPINGS);
                    continue;
                }
                if (mappingCount == 1) {
                    String type = in.readString();
                    if (!"_doc".equals(type)) {
                        throw new IllegalStateException("Expected _doc but got [" + type + "]");
                    }
                    indexMapBuilder.put(index, new MappingMetadata(in));
                    continue;
                }
                throw new IllegalStateException("Expected 0 or 1 mappings but got: " + mappingCount);
            }
            boolean hasMapping = in.readBoolean();
            indexMapBuilder.put(index, hasMapping ? new MappingMetadata(in) : MappingMetadata.EMPTY_MAPPINGS);
        }
        this.mappings = indexMapBuilder.build();
    }

    public ImmutableOpenMap<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, MappingMetadata> getMappings() {
        return this.mappings();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, MappingMetadata> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            if (out.getVersion().before(Version.V_2_0_0)) {
                out.writeVInt(objectObjectCursor.value == MappingMetadata.EMPTY_MAPPINGS ? 0 : 1);
                if (objectObjectCursor.value == MappingMetadata.EMPTY_MAPPINGS) continue;
                out.writeString("_doc");
                ((MappingMetadata)objectObjectCursor.value).writeTo(out);
                continue;
            }
            out.writeOptionalWriteable((Writeable)objectObjectCursor.value);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (ObjectObjectCursor<String, MappingMetadata> objectObjectCursor : this.getMappings()) {
            builder.startObject((String)objectObjectCursor.key);
            if (objectObjectCursor.value != null) {
                builder.field(MAPPINGS.getPreferredName(), ((MappingMetadata)objectObjectCursor.value).sourceAsMap());
            } else {
                builder.startObject(MAPPINGS.getPreferredName()).endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return this.mappings.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMappingsResponse other = (GetMappingsResponse)obj;
        return this.mappings.equals(other.mappings);
    }
}

