/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.delete;

import java.io.IOException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.index.shard.ShardId;
import org.opensearch.rest.RestStatus;

public class DeleteResponse
extends DocWriteResponse {
    public DeleteResponse(ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
    }

    public DeleteResponse(StreamInput in) throws IOException {
        super(in);
    }

    public DeleteResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, boolean found) {
        this(shardId, id, seqNo, primaryTerm, version, found ? DocWriteResponse.Result.DELETED : DocWriteResponse.Result.NOT_FOUND);
    }

    private DeleteResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, DocWriteResponse.Result result) {
        super(shardId, id, seqNo, primaryTerm, version, DeleteResponse.assertDeletedOrNotFound(result));
    }

    private static DocWriteResponse.Result assertDeletedOrNotFound(DocWriteResponse.Result result) {
        assert (result == DocWriteResponse.Result.DELETED || result == DocWriteResponse.Result.NOT_FOUND);
        return result;
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.DELETED ? super.status() : RestStatus.NOT_FOUND;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }

    public static DeleteResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        Builder context = new Builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            DeleteResponse.parseXContentFields(parser, context);
        }
        return context.build();
    }

    public static void parseXContentFields(XContentParser parser, Builder context) throws IOException {
        DocWriteResponse.parseInnerToXContent(parser, context);
    }

    public static class Builder
    extends DocWriteResponse.Builder {
        @Override
        public DeleteResponse build() {
            DeleteResponse deleteResponse = new DeleteResponse(this.shardId, this.id, this.seqNo, this.primaryTerm, (long)this.version, this.result);
            deleteResponse.setForcedRefresh(this.forcedRefresh);
            if (this.shardInfo != null) {
                deleteResponse.setShardInfo(this.shardInfo);
            }
            return deleteResponse;
        }
    }
}

