/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.transport.TransportRequest;

public class PeersRequest
extends TransportRequest {
    private final DiscoveryNode sourceNode;
    private final List<DiscoveryNode> knownPeers;

    public PeersRequest(DiscoveryNode sourceNode, List<DiscoveryNode> knownPeers) {
        assert (!knownPeers.contains(sourceNode)) : "local node is not a peer";
        this.sourceNode = sourceNode;
        this.knownPeers = knownPeers;
    }

    public PeersRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceNode = new DiscoveryNode(in);
        this.knownPeers = in.readList(DiscoveryNode::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceNode.writeTo(out);
        out.writeList(this.knownPeers);
    }

    public List<DiscoveryNode> getKnownPeers() {
        return this.knownPeers;
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public String toString() {
        return "PeersRequest{sourceNode=" + this.sourceNode + ", knownPeers=" + this.knownPeers + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeersRequest that = (PeersRequest)o;
        return Objects.equals(this.sourceNode, that.sourceNode) && Objects.equals(this.knownPeers, that.knownPeers);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNode, this.knownPeers);
    }
}

