/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.action;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.transport.TransportRequest;

public class ExtensionHandleTransportRequest
extends TransportRequest {
    private final String action;
    private final byte[] requestBytes;

    public ExtensionHandleTransportRequest(String action, byte[] requestBytes) {
        this.action = action;
        this.requestBytes = requestBytes;
    }

    public ExtensionHandleTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.action = in.readString();
        this.requestBytes = in.readByteArray();
    }

    public String getAction() {
        return this.action;
    }

    public byte[] getRequestBytes() {
        return this.requestBytes;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.action);
        out.writeByteArray(this.requestBytes);
    }

    public String toString() {
        return "ExtensionHandleTransportRequest{action=" + this.action + ", requestBytes=" + this.requestBytes + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionHandleTransportRequest that = (ExtensionHandleTransportRequest)obj;
        return Objects.equals(this.action, that.action) && Objects.equals(this.requestBytes, that.requestBytes);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.requestBytes);
    }
}

