/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.StepListener;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.UUIDs;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.recovery.MultiFileWriter;
import org.opensearch.indices.replication.CheckpointInfoResponse;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.SegmentReplicationSource;
import org.opensearch.indices.replication.SegmentReplicationState;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationFailedException;
import org.opensearch.indices.replication.common.ReplicationListener;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.indices.replication.common.ReplicationTarget;

public class SegmentReplicationTarget
extends ReplicationTarget {
    private final ReplicationCheckpoint checkpoint;
    private final SegmentReplicationSource source;
    private final SegmentReplicationState state;
    protected final MultiFileWriter multiFileWriter;

    public ReplicationCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public SegmentReplicationTarget(ReplicationCheckpoint checkpoint, IndexShard indexShard, SegmentReplicationSource source, ReplicationListener listener) {
        super("replication_target", indexShard, new ReplicationLuceneIndex(), listener);
        this.checkpoint = checkpoint;
        this.source = source;
        this.state = new SegmentReplicationState(this.stateIndex, this.getId());
        this.multiFileWriter = new MultiFileWriter(indexShard.store(), this.stateIndex, this.getPrefix(), this.logger, () -> this.ensureRefCount());
    }

    @Override
    protected void closeInternal() {
        try {
            this.multiFileWriter.close();
        }
        finally {
            super.closeInternal();
        }
    }

    @Override
    protected String getPrefix() {
        return "replication." + UUIDs.randomBase64UUID() + ".";
    }

    @Override
    protected void onDone() {
        this.state.setStage(SegmentReplicationState.Stage.DONE);
    }

    @Override
    public SegmentReplicationState state() {
        return this.state;
    }

    @Override
    public SegmentReplicationTarget retryCopy() {
        return new SegmentReplicationTarget(this.checkpoint, this.indexShard, this.source, this.listener);
    }

    @Override
    public String description() {
        return "Segment replication from " + this.source.toString();
    }

    @Override
    public void notifyListener(OpenSearchException e, boolean sendShardFailure) {
        Throwable cancelledException = ExceptionsHelper.unwrap(e, CancellableThreads.ExecutionCancelledException.class);
        if (cancelledException != null) {
            this.state.setStage(SegmentReplicationState.Stage.CANCELLED);
            this.listener.onFailure(this.state(), (CancellableThreads.ExecutionCancelledException)cancelledException, sendShardFailure);
        } else {
            this.listener.onFailure(this.state(), e, sendShardFailure);
        }
    }

    @Override
    public boolean reset(CancellableThreads newTargetCancellableThreads) throws IOException {
        return false;
    }

    @Override
    public void writeFileChunk(StoreFileMetadata metadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        try {
            this.multiFileWriter.writeFileChunk(metadata, position, content, lastChunk);
            listener.onResponse(null);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void startReplication(ActionListener<Void> listener) {
        this.cancellableThreads.setOnCancel((reason, beforeCancelEx) -> {
            CancellableThreads.ExecutionCancelledException executionCancelledException = new CancellableThreads.ExecutionCancelledException("replication was canceled reason [" + reason + "]");
            this.notifyListener(executionCancelledException, false);
            throw executionCancelledException;
        });
        this.state.setStage(SegmentReplicationState.Stage.REPLICATING);
        StepListener<CheckpointInfoResponse> checkpointInfoListener = new StepListener<CheckpointInfoResponse>();
        StepListener getFilesListener = new StepListener();
        StepListener finalizeListener = new StepListener();
        this.cancellableThreads.checkForCancel();
        this.logger.trace("[shardId {}] Replica starting replication [id {}]", (Object)this.shardId().getId(), (Object)this.getId());
        this.state.setStage(SegmentReplicationState.Stage.GET_CHECKPOINT_INFO);
        this.source.getCheckpointMetadata(this.getId(), this.checkpoint, checkpointInfoListener);
        checkpointInfoListener.whenComplete((CheckedConsumer<CheckpointInfoResponse, Exception>)((CheckedConsumer)checkpointInfo -> this.getFiles((CheckpointInfoResponse)checkpointInfo, getFilesListener)), listener::onFailure);
        getFilesListener.whenComplete(response -> this.finalizeReplication((CheckpointInfoResponse)checkpointInfoListener.result(), finalizeListener), listener::onFailure);
        finalizeListener.whenComplete(r -> listener.onResponse(null), listener::onFailure);
    }

    private void getFiles(CheckpointInfoResponse checkpointInfo, StepListener<GetSegmentFilesResponse> getFilesListener) throws IOException {
        this.cancellableThreads.checkForCancel();
        this.state.setStage(SegmentReplicationState.Stage.FILE_DIFF);
        Store.RecoveryDiff diff = Store.segmentReplicationDiff(checkpointInfo.getMetadataMap(), this.getMetadataMap());
        this.logger.trace("Replication diff {}", (Object)diff);
        if (!diff.different.isEmpty()) {
            getFilesListener.onFailure(new IllegalStateException(new ParameterizedMessage("Shard {} has local copies of segments that differ from the primary", (Object)this.indexShard.shardId()).getFormattedMessage()));
        }
        for (StoreFileMetadata file : diff.missing) {
            this.state.getIndex().addFileDetail(file.name(), file.length(), false);
        }
        this.state.setStage(SegmentReplicationState.Stage.GET_FILES);
        this.cancellableThreads.checkForCancel();
        this.source.getSegmentFiles(this.getId(), checkpointInfo.getCheckpoint(), diff.missing, this.store, getFilesListener);
    }

    private void finalizeReplication(CheckpointInfoResponse checkpointInfoResponse, ActionListener<Void> listener) {
        ActionListener.completeWith(listener, () -> {
            this.cancellableThreads.checkForCancel();
            this.state.setStage(SegmentReplicationState.Stage.FINALIZE_REPLICATION);
            this.multiFileWriter.renameAllTempFiles();
            Store store = this.store();
            store.incRef();
            try {
                ReplicationCheckpoint responseCheckpoint = checkpointInfoResponse.getCheckpoint();
                SegmentInfos infos = SegmentInfos.readCommit((Directory)store.directory(), (ChecksumIndexInput)this.toIndexInput(checkpointInfoResponse.getInfosBytes()), (long)responseCheckpoint.getSegmentsGen());
                this.cancellableThreads.checkForCancel();
                this.indexShard.finalizeReplication(infos, responseCheckpoint.getSeqNo());
                store.cleanupAndPreserveLatestCommitPoint("finalize - clean with in memory infos", infos);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                try {
                    try {
                        store.removeCorruptionMarker();
                    }
                    finally {
                        Lucene.cleanLuceneIndex(store.directory());
                    }
                }
                catch (Exception e) {
                    this.logger.debug("Failed to clean lucene index", (Throwable)e);
                    ex.addSuppressed(e);
                }
                ReplicationFailedException rfe = new ReplicationFailedException(this.indexShard.shardId(), "failed to clean after replication", ex);
                this.fail(rfe, true);
                throw rfe;
            }
            catch (Exception ex) {
                ReplicationFailedException rfe = new ReplicationFailedException(this.indexShard.shardId(), "failed to clean after replication", (Throwable)ex);
                this.fail(rfe, true);
                throw rfe;
            }
            finally {
                store.decRef();
            }
            return null;
        });
    }

    private ChecksumIndexInput toIndexInput(byte[] input) {
        return new BufferedChecksumIndexInput((IndexInput)new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(ByteBuffer.wrap(input))), "SegmentInfos"));
    }

    Map<String, StoreFileMetadata> getMetadataMap() throws IOException {
        if (this.indexShard.getSegmentInfosSnapshot() == null) {
            return Collections.emptyMap();
        }
        try (GatedCloseable<SegmentInfos> snapshot = this.indexShard.getSegmentInfosSnapshot();){
            Map<String, StoreFileMetadata> map = this.store.getSegmentMetadataMap(snapshot.get());
            return map;
        }
    }

    @Override
    protected void onCancel(String reason) {
        this.cancellableThreads.cancel(reason);
        this.source.cancel();
    }
}

