/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.stats;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.search.backpressure.settings.SearchBackpressureMode;
import org.opensearch.search.backpressure.stats.SearchShardTaskStats;

public class SearchBackpressureStats
implements ToXContentFragment,
Writeable {
    private final SearchShardTaskStats searchShardTaskStats;
    private final SearchBackpressureMode mode;

    public SearchBackpressureStats(SearchShardTaskStats searchShardTaskStats, SearchBackpressureMode mode) {
        this.searchShardTaskStats = searchShardTaskStats;
        this.mode = mode;
    }

    public SearchBackpressureStats(StreamInput in) throws IOException {
        this(new SearchShardTaskStats(in), SearchBackpressureMode.fromName(in.readString()));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject("search_backpressure").field("search_shard_task", (ToXContent)this.searchShardTaskStats).field("mode", this.mode.getName()).endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.searchShardTaskStats.writeTo(out);
        out.writeString(this.mode.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchBackpressureStats that = (SearchBackpressureStats)o;
        return this.searchShardTaskStats.equals(that.searchShardTaskStats) && this.mode == that.mode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.searchShardTaskStats, this.mode});
    }
}

