/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.tasks.TaskResourceUsage;

public class TaskResourceStats
implements Writeable,
ToXContentFragment {
    private final Map<String, TaskResourceUsage> resourceUsage;

    public TaskResourceStats(Map<String, TaskResourceUsage> resourceUsage) {
        this.resourceUsage = Objects.requireNonNull(resourceUsage, "resource usage is required");
    }

    public TaskResourceStats(StreamInput in) throws IOException {
        this.resourceUsage = in.readMap(StreamInput::readString, TaskResourceUsage::readFromStream);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.resourceUsage, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
    }

    public Map<String, TaskResourceUsage> getResourceUsageInfo() {
        return this.resourceUsage;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, TaskResourceUsage> resourceUsageEntry : this.resourceUsage.entrySet()) {
            builder.startObject(resourceUsageEntry.getKey());
            if (resourceUsageEntry.getValue() != null) {
                resourceUsageEntry.getValue().toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder;
    }

    public static TaskResourceStats fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        HashMap<String, TaskResourceUsage> resourceStats = new HashMap<String, TaskResourceUsage>();
        if (token == XContentParser.Token.FIELD_NAME) {
            assert (parser.currentToken() == XContentParser.Token.FIELD_NAME) : "Expected field name but saw [" + parser.currentToken() + "]";
            do {
                String fieldName = parser.currentName();
                TaskResourceUsage value = TaskResourceUsage.fromXContent(parser);
                resourceStats.put(fieldName, value);
            } while (parser.nextToken() == XContentParser.Token.FIELD_NAME);
        }
        return new TaskResourceStats(resourceStats);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != TaskResourceStats.class) {
            return false;
        }
        TaskResourceStats other = (TaskResourceStats)obj;
        return Objects.equals(this.resourceUsage, other.resourceUsage);
    }

    public int hashCode() {
        return Objects.hash(this.resourceUsage);
    }
}

