/*
 * Decompiled with CFR 0.152.
 */
package org.stro.jdartsass;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.function.Consumer;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class Installation {
    private final File executable;

    public static Installation archive(File archive, File rootDir) {
        Installation.extract(archive, rootDir);
        boolean windows = StringUtils.endsWithIgnoreCase((CharSequence)archive.getName(), (CharSequence)".zip");
        String executableName = "dart-sass" + File.separator + (windows ? "sass.bat" : "sass");
        File executable = new File(rootDir, executableName);
        if (!windows) {
            for (File file : FileUtils.listFiles((File)executable.getParentFile(), null, (boolean)true)) {
                try {
                    Files.setPosixFilePermissions(file.toPath(), EnumSet.allOf(PosixFilePermission.class));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return Installation.executable(executable);
    }

    public static Installation downloading(URL url, File tempDir, File rootDir) {
        String fileName = StringUtils.substringAfterLast((String)url.getPath(), (String)"/");
        File archive = new File(tempDir, fileName);
        if (!archive.exists()) {
            try (InputStream in = url.openStream();
                 FileOutputStream out = new FileOutputStream(archive);){
                out.getChannel().transferFrom(Channels.newChannel(in), 0L, Long.MAX_VALUE);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return Installation.archive(archive, rootDir);
    }

    public static Installation executable(File executable) {
        return new Installation(executable);
    }

    private static void extract(File archive, File dir) {
        block42: {
            boolean tarGz = StringUtils.endsWithIgnoreCase((CharSequence)archive.getName(), (CharSequence)".tar.gz");
            Consumer<ArchiveInputStream> extract = param -> {
                try (ArchiveInputStream i = param;){
                    ArchiveEntry entry = null;
                    while ((entry = i.getNextEntry()) != null) {
                        if (!i.canReadEntryData(entry)) continue;
                        File f = new File(dir, entry.getName());
                        if (entry.isDirectory()) {
                            if (f.isDirectory() || f.mkdirs()) continue;
                            throw new IOException("failed to create directory " + f);
                        }
                        File parent = f.getParentFile();
                        if (!parent.isDirectory() && !parent.mkdirs()) {
                            throw new IOException("failed to create directory " + parent);
                        }
                        OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                        try {
                            IOUtils.copy((InputStream)i, (OutputStream)o);
                        }
                        finally {
                            if (o == null) continue;
                            o.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
            if (tarGz) {
                try (InputStream fi = Files.newInputStream(archive.toPath(), new OpenOption[0]);
                     BufferedInputStream bi = new BufferedInputStream(fi);
                     GzipCompressorInputStream gzi = new GzipCompressorInputStream((InputStream)bi);
                     TarArchiveInputStream i = new TarArchiveInputStream((InputStream)gzi);){
                    extract.accept((ArchiveInputStream)i);
                    break block42;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            try (InputStream fi = Files.newInputStream(archive.toPath(), new OpenOption[0]);
                 BufferedInputStream bi = new BufferedInputStream(fi);
                 ZipArchiveInputStream i = new ZipArchiveInputStream((InputStream)bi);){
                extract.accept((ArchiveInputStream)i);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private Installation(File executable) {
        this.executable = executable;
    }

    public File getExecutable() {
        return this.executable;
    }
}

