/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl.executejar;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ResettableSingleton<T> {
    private volatile T remembered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public T get(Supplier<T> onceSupplier) {
        T loadResult = this.remembered;
        if (loadResult != null) {
            return loadResult;
        }
        ResettableSingleton resettableSingleton = this;
        synchronized (resettableSingleton) {
            if (this.remembered != null) {
                return this.remembered;
            }
            this.remembered = onceSupplier.get();
            if (this.remembered == null) {
                throw new NullPointerException("Supplier returned null");
            }
            return this.remembered;
        }
    }

    @Nullable
    public T remembered() {
        return this.remembered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRemembered() {
        ResettableSingleton resettableSingleton = this;
        synchronized (resettableSingleton) {
            this.remembered = null;
        }
    }
}

