/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.impl.connector.DataSourceFromJdbcUrl;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.spi.annotation.Beta;
import java.sql.PreparedStatement;
import javax.annotation.Nonnull;
import javax.sql.CommonDataSource;

public class JdbcSinkBuilder<T> {
    public static final boolean DEFAULT_EXACTLY_ONCE = true;
    public static final int DEFAULT_BATCH_LIMIT = 50;
    private String updateQuery;
    private String jdbcUrl;
    private BiConsumerEx<PreparedStatement, T> bindFn;
    private SupplierEx<? extends CommonDataSource> dataSourceSupplier;
    private boolean exactlyOnce = true;
    private int batchLimit = 50;
    private DataConnectionRef dataConnectionRef;

    JdbcSinkBuilder() {
    }

    @Nonnull
    public JdbcSinkBuilder<T> updateQuery(@Nonnull String updateQuery) {
        this.updateQuery = updateQuery;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> bindFn(@Nonnull BiConsumerEx<PreparedStatement, T> bindFn) {
        this.bindFn = bindFn;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> jdbcUrl(String connectionUrl) {
        this.jdbcUrl = connectionUrl;
        this.dataSourceSupplier = null;
        this.dataConnectionRef = null;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> dataSourceSupplier(SupplierEx<? extends CommonDataSource> dataSourceSupplier) {
        this.dataSourceSupplier = dataSourceSupplier;
        this.jdbcUrl = null;
        this.dataConnectionRef = null;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> exactlyOnce(boolean enabled) {
        this.exactlyOnce = enabled;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> batchLimit(int batchLimit) {
        Preconditions.checkPositive(batchLimit, "batch size limit must be positive");
        this.batchLimit = batchLimit;
        return this;
    }

    @Nonnull
    @Beta
    public JdbcSinkBuilder<T> dataConnectionRef(DataConnectionRef dataConnectionRef) {
        this.dataSourceSupplier = null;
        this.jdbcUrl = null;
        this.dataConnectionRef = dataConnectionRef;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        if (this.dataSourceSupplier == null && this.jdbcUrl == null && this.dataConnectionRef == null) {
            throw new IllegalStateException("Neither jdbcUrl() nor dataSourceSupplier() nor dataConnectionRef() set");
        }
        if (this.jdbcUrl != null) {
            String connectionUrl = this.jdbcUrl;
            this.dataSourceSupplier = () -> new DataSourceFromJdbcUrl(connectionUrl);
        }
        if (this.dataSourceSupplier != null) {
            return Sinks.fromProcessor("jdbcSink", SinkProcessors.writeJdbcP(this.jdbcUrl, this.updateQuery, this.dataSourceSupplier, this.bindFn, this.exactlyOnce, this.batchLimit));
        }
        return Sinks.fromProcessor("jdbcSink", SinkProcessors.writeJdbcP(this.updateQuery, this.dataConnectionRef, this.bindFn, this.exactlyOnce, this.batchLimit));
    }
}

