/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security;

import com.google.api.pathtemplate.ValidationException;
import com.querydsl.core.types.EntityPath;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.AuthHandler;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.EntityCheckRegistry;
import org.cyclos.impl.access.PermissionCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.UserPermissionCheck;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserLocatorHandler;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.validation.ValidationHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class BaseServiceSecurity {
    private static String VALIDATION_KEY = "BaseServiceSecurityValidation";
    @Autowired
    private EntityCheckRegistry entityCheckRegistry;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected EntityManagerHandler entityManagerHandler;
    @Autowired
    protected ConversionHandler conversionHandler;
    @Autowired
    protected UserLocatorHandler userLocatorHandler;
    @Autowired
    protected ConfigurationHandler configurationHandler;
    @Autowired
    protected ProductsHandler productsHandler;
    @Autowired
    protected GroupsHandler groupsHandler;
    @Autowired
    protected AccountHandler accountHandler;
    @Autowired
    protected AuthHandler authHandler;
    @Autowired
    protected ProfileFieldHandler profileFieldHandler;
    @Autowired
    protected CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    protected TranslationHandler translationHandler;
    @Autowired
    protected DataTranslationHandler dataTranslationHandler;
    @Autowired
    protected ValidationHandler validationHandler;

    public DBQuery<?> from(EntityPath<?> ... entityPathArray) {
        return this.entityManagerHandler.from(entityPathArray);
    }

    @PostConstruct
    public final void initialize() {
        EntityCheck<?> entityCheck = this.resolveEntityCheck();
        if (entityCheck != null) {
            this.entityCheckRegistry.register(entityCheck);
        }
        this.doInitialize();
    }

    public void validate(Validator validator, Object object) throws ValidationException {
        this.validationHandler.validate(validator, object, VALIDATION_KEY);
    }

    protected boolean canManage(BasicUser basicUser) {
        return this.getSessionData().manages(basicUser);
    }

    protected void checkGuest() {
        if (!this.getSessionData().isGuest()) {
            throw new PermissionDeniedException();
        }
    }

    protected void checkId(Class<? extends SimpleEntity> clazz, Long l) {
        if (l != null) {
            this.find(clazz, l);
        }
    }

    protected void checkIds(Class<? extends SimpleEntity> clazz, Collection<Long> collection) {
        if (collection != null) {
            for (Long l : collection) {
                this.find(clazz, l);
            }
        }
    }

    protected void checkInternalName(Class<? extends SimpleEntity> clazz, String string) {
        if (IInternalNamedEntity.class.isAssignableFrom(clazz) && string != null) {
            this.entityManagerHandler.find(clazz, string);
        }
    }

    protected void checkLoggedIn() {
        if (!this.getSessionData().isLoggedIn()) {
            throw new PermissionDeniedException();
        }
    }

    protected BasicUser checkManagesUser(BasicUser basicUser) throws PermissionDeniedException {
        if (!this.canManage(basicUser)) {
            throw new PermissionDeniedException();
        }
        return basicUser;
    }

    protected BasicUser checkManagesUser(IUser iUser) {
        return this.checkManagesUser(this.getUser(iUser));
    }

    protected void checkPermission(Permission ... permissionArray) throws PermissionDeniedException {
        if (!this.hasPermission(permissionArray)) {
            throw new PermissionDeniedException();
        }
    }

    protected BasicUser checkRelatesToUser(BasicUser basicUser) throws PermissionDeniedException {
        if (!this.isRelatedToUser(basicUser)) {
            throw new PermissionDeniedException();
        }
        return basicUser;
    }

    protected BasicUser checkRelatesToUser(IUser iUser) {
        return this.checkRelatesToUser(this.getUser(iUser));
    }

    protected OidcAccessToken checkScope(Scope ... scopeArray) {
        OidcAccessToken oidcAccessToken = this.getSessionData().getAccessToken();
        if (oidcAccessToken != null) {
            Set set = oidcAccessToken.getAuthorization().getScopes();
            if (CollectionHelper.isEmpty((Object[])scopeArray) || !CollectionHelper.containsAny((Collection)set, (Object[])scopeArray)) {
                throw new PermissionDeniedException();
            }
        }
        return oidcAccessToken;
    }

    protected void checkVO(Class<? extends SimpleEntity> clazz, EntityVO entityVO) {
        Long l = EntityVO.id((EntityVO)entityVO);
        if (l != null) {
            this.checkId(clazz, l);
        } else if (entityVO instanceof IInternalNamedEntity) {
            String string = ((IInternalNamedEntity)entityVO).getInternalName();
            this.checkInternalName(clazz, string);
        }
    }

    protected void checkVOs(Class<? extends SimpleEntity> clazz, Collection<? extends EntityVO> collection) {
        if (collection != null) {
            for (EntityVO entityVO : collection) {
                this.checkVO(clazz, entityVO);
            }
        }
    }

    protected void doInitialize() {
    }

    protected <E extends SimpleEntity> E find(Class<E> clazz, Long l) {
        return (E)((SimpleEntity)this.entityManagerHandler.find(clazz, l));
    }

    protected ConfigurationAccessor getConfiguration() {
        return this.getSessionData().getConfiguration();
    }

    protected EntityCheckRegistry getEntityCheckRegistry() {
        return this.entityCheckRegistry;
    }

    protected BasicUser getLoggedBasicUser() {
        return this.getSessionData().getLoggedBasicUser();
    }

    protected User getLoggedUser() {
        return this.getSessionData().getLoggedUser();
    }

    protected ProductsAccessor getProducts() {
        return this.getSessionData().getProducts();
    }

    protected SessionData getSessionData() {
        return InvocationContext.getSessionData();
    }

    protected BasicUser getUser(IUser iUser) {
        if (iUser == null) {
            return null;
        }
        if (iUser instanceof BasicUser) {
            return (BasicUser)iUser;
        }
        UserLocatorVO userLocatorVO = (UserLocatorVO)this.conversionHandler.convert(UserLocatorVO.class, (Object)iUser);
        return this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
    }

    protected boolean hasPermission(Permission ... permissionArray) {
        return this.getSessionData().hasPermission(permissionArray);
    }

    protected boolean hasValue(Permission permission, Object ... objectArray) {
        return this.authHandler.hasValue(permission, objectArray);
    }

    protected boolean inSameNetwork(NetworkedEntity networkedEntity) {
        SessionData sessionData = this.getSessionData();
        return sessionData.isSystem() ? true : Objects.equals(networkedEntity.getNetwork(), sessionData.getNetwork());
    }

    protected boolean inSameNetworkOrGlobal(NetworkedEntity networkedEntity) {
        Network network = networkedEntity.getNetwork();
        if (network == null) {
            return true;
        }
        SessionData sessionData = this.getSessionData();
        return sessionData.isSystem() ? true : Objects.equals(network, sessionData.getNetwork());
    }

    protected boolean isAdmin() {
        return this.getSessionData().isAdmin();
    }

    protected boolean isBroker() {
        return this.getSessionData().isBroker();
    }

    protected boolean isGlobalAdmin() {
        return this.getSessionData().isGlobalAdmin();
    }

    protected boolean isGlobalAdminInNetwork() {
        return this.getSessionData().isGlobalAdminInNetwork();
    }

    protected boolean isGuest() {
        return this.getSessionData().isGuest();
    }

    protected boolean isLoggedIn() {
        return this.getSessionData().isLoggedIn();
    }

    protected boolean isManagerOf(BasicUser basicUser) {
        return this.getSessionData().isManagerOf(basicUser);
    }

    protected boolean isMember() {
        return this.getSessionData().isMember();
    }

    protected boolean isMemberOnly() {
        return this.getSessionData().isMemberOnly();
    }

    protected boolean isNetworkAdmin() {
        return this.getSessionData().isNetworkAdmin();
    }

    protected boolean isOperator() {
        return this.getSessionData().isOperator();
    }

    protected boolean isRelatedToUser(BasicUser basicUser) {
        return this.getSessionData().relatesTo(basicUser);
    }

    protected boolean isSystem() {
        return this.getSessionData().isSystem();
    }

    protected boolean isUserManager() {
        return this.getSessionData().isUserManager();
    }

    protected String message(Language language, MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(language, messageKey, objectArray);
    }

    protected String message(MessageFormat messageFormat, Language language, MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(messageFormat, language, messageKey, objectArray);
    }

    protected String message(MessageFormat messageFormat, MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(messageFormat, messageKey, objectArray);
    }

    protected String message(MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(messageKey, objectArray);
    }

    protected UserPermissionCheck permission(BasicUser basicUser) {
        return this.authHandler.permission(basicUser);
    }

    protected PermissionCheck permission(Permission permission) {
        return this.authHandler.permission(permission);
    }

    protected PermissionCheck permissionOptionalValue(Permission permission) {
        return this.authHandler.permissionOptionalValue(permission);
    }

    protected UserPermissionCheck permissionOptionalValue(User user) {
        return this.authHandler.permissionOptionalValue((BasicUser)user);
    }

    protected abstract EntityCheck<?> resolveEntityCheck();
}

