/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import java.util.Set;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.AgreementLog;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.AgreementLogServiceLocal;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.agreementlogs.AgreementLogVO;
import org.cyclos.model.access.agreements.AgreementVO;
import org.cyclos.model.access.agreements.UserAgreementsData;
import org.cyclos.model.access.agreements.UserOptionalAgreementsDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.access.AgreementLogService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AgreementLogServiceSecurity
extends BaseServiceSecurity
implements AgreementLogService {
    @Autowired
    private AgreementLogServiceLocal agreementLogService;

    public void acceptPending(Set<AgreementVO> set) {
        this.checkLoggedIn();
        this.agreementLogService.acceptPending(set);
    }

    public UserAgreementsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        this.permission((BasicUser)user).my(new Permission[0]).user(new Permission[]{Permission.USER_AGREEMENT_LOG_VIEW}).check();
        UserAgreementsData userAgreementsData = this.agreementLogService.getData(userLocatorVO);
        SessionData sessionData = this.getSessionData();
        boolean bl = user.equals((Object)sessionData.getLoggedUser());
        userAgreementsData.setEditable(bl);
        if (bl && !sessionData.hasPermission(Permission.MY_AGREEMENT_LOG_VIEW)) {
            userAgreementsData.setLog(null);
        }
        return userAgreementsData;
    }

    public AgreementLogVO load(Long l) throws EntityNotFoundException {
        return this.agreementLogService.load(l);
    }

    public void saveOptional(@NotNull UserOptionalAgreementsDTO userOptionalAgreementsDTO) throws FrameworkException {
        this.checkLoggedIn();
        this.agreementLogService.saveOptional(userOptionalAgreementsDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<AgreementLog>(AgreementLog.class){

            public boolean isVisible(SessionData sessionData, AgreementLog agreementLog) {
                return AgreementLogServiceSecurity.this.accessible(agreementLog.getUser());
            }
        };
    }

    private boolean accessible(User user) {
        return this.permission((BasicUser)user).user(new Permission[]{Permission.USER_AGREEMENT_LOG_VIEW}).my(new Permission[]{Permission.MY_AGREEMENT_LOG_VIEW}).granted();
    }
}

