/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import javax.validation.constraints.NotNull;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.InternalAuthServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.model.access.login.AuthVO;
import org.cyclos.server.model.access.login.SessionPropertiesVO;
import org.cyclos.server.model.access.login.SetSessionPropertiesDTO;
import org.cyclos.services.access.InternalAuthService;
import org.cyclos.services.access.LoginDTO;
import org.cyclos.services.access.LoginUserDTO;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class InternalAuthServiceSecurity
extends BaseServiceSecurity
implements InternalAuthService {
    @Autowired
    private InternalAuthServiceLocal internalAuthService;

    public AuthVO getCurrentAuth() throws FrameworkException {
        return this.internalAuthService.getCurrentAuth();
    }

    public SessionPropertiesVO getSessionProperties() throws FrameworkException {
        return this.internalAuthService.getSessionProperties();
    }

    public AuthVO login(LoginDTO loginDTO) throws FrameworkException, LoginException, RemoteAddressBlockedException {
        SessionData sessionData = this.getSessionData();
        if (sessionData.getSession() != null) {
            throw new PermissionDeniedException();
        }
        return this.internalAuthService.login(loginDTO);
    }

    public AuthVO loginUser(LoginUserDTO loginUserDTO) throws FrameworkException, LoginException, RemoteAddressBlockedException {
        this.checkPermission(Permission.CONNECTED_USERS_LOGIN);
        return this.internalAuthService.loginUser(loginUserDTO);
    }

    public void logout() throws FrameworkException {
        this.internalAuthService.logout();
    }

    public void setSessionProperties(@NotNull SetSessionPropertiesDTO setSessionPropertiesDTO) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        if (sessionData.getSession() == null) {
            throw new PermissionDeniedException();
        }
        this.internalAuthService.setSessionProperties(setSessionPropertiesDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

