/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.InternalIdentityProviderServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.identityproviders.IdentityProviderRequestType;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.model.access.identityproviders.IdentityProviderRequest;
import org.cyclos.server.model.access.identityproviders.IdentityProviderRequestResult;
import org.cyclos.services.access.CallbackResult;
import org.cyclos.services.access.InternalIdentityProviderService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class InternalIdentityProviderServiceSecurity
extends BaseServiceSecurity
implements InternalIdentityProviderService {
    @Autowired
    private InternalIdentityProviderServiceLocal internalIdentityProviderService;

    public CallbackResult callback(String string) throws FrameworkException {
        return this.internalIdentityProviderService.callback(string);
    }

    public String redirect(String string) {
        return this.internalIdentityProviderService.redirect(string);
    }

    public IdentityProviderRequestResult request(IdentityProviderRequest identityProviderRequest) throws FrameworkException {
        IdentityProviderRequestType identityProviderRequestType;
        IdentityProviderRequestType identityProviderRequestType2 = identityProviderRequestType = identityProviderRequest == null ? null : identityProviderRequest.getType();
        if (identityProviderRequestType == null) {
            throw new ValidationException();
        }
        SessionData sessionData = this.getSessionData();
        switch (identityProviderRequestType) {
            case LINK: {
                if (sessionData.getSession() != null) break;
                throw new PermissionDeniedException("Must be logged-in with a session");
            }
            case REGISTER: 
            case WIZARD: 
            case LOGIN: {
                if (!sessionData.isLoggedIn()) break;
                throw new PermissionDeniedException("Must be guest");
            }
        }
        return this.internalIdentityProviderService.request(identityProviderRequest);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

