/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.PinServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.pins.CreatePinDTO;
import org.cyclos.model.access.pins.CurrentCredentialsForPinManage;
import org.cyclos.model.access.pins.PinDTO;
import org.cyclos.model.access.pins.PinData;
import org.cyclos.model.access.pins.PinDetailedVO;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.access.pins.PinVO;
import org.cyclos.model.access.pins.SetPinParams;
import org.cyclos.model.access.pins.UserPinsData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.access.PinService;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class PinServiceSecurity
extends BaseServiceSecurity
implements PinService {
    @Autowired
    private PinServiceLocal pinService;

    public void apply(BasicUser basicUser, UserPinsData userPinsData) {
        if (userPinsData != null) {
            boolean bl = userPinsData.isEnabled();
            userPinsData.setCanView(bl && this.hasPinPermission(basicUser, false));
            userPinsData.setCanManage(bl && this.hasPinPermission(basicUser, true));
        }
    }

    public UserPinsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        UserPinsData userPinsData = this.pinService.getData(userLocatorVO);
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        this.apply(basicUser, userPinsData);
        return userPinsData;
    }

    public PinData getEditData(PinLocatorVO pinLocatorVO) throws FrameworkException {
        Pin pin = this.pinService.ensurePin(pinLocatorVO);
        this.checkView(pin.getBasicUser());
        PinData pinData = this.pinService.getEditData(new PinLocatorVO(pin.getId()));
        pinData.setCanManage(pinData.isCanManage() && (this.getLoggedBasicUser().equals((Object)pin.getUser()) || this.hasPermission(Permission.USER_TRUSTED_DEVICES_MANAGE)));
        return pinData;
    }

    public CredentialInputDTO getPasswordInputForCreate() throws FrameworkException {
        this.checkLoggedIn();
        return this.pinService.getPasswordInputForCreate();
    }

    public List<PinVO> list(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        this.checkView(basicUser);
        return this.pinService.list(new UserLocatorVO(basicUser.getId()));
    }

    public PinDetailedVO locate(PinLocatorVO pinLocatorVO) {
        Pin pin = this.pinService.ensurePin(pinLocatorVO);
        this.checkView(pin.getBasicUser());
        return this.pinService.locate(pinLocatorVO);
    }

    public void remove(PinLocatorVO pinLocatorVO, CurrentCredentialsForPinManage currentCredentialsForPinManage) throws FrameworkException {
        this.checkManage(pinLocatorVO);
        this.pinService.remove(pinLocatorVO, currentCredentialsForPinManage);
    }

    public void save(PinDTO pinDTO) throws FrameworkException {
        Pin pin = this.find(Pin.class, pinDTO.getId());
        if (!this.canManage(pin)) {
            throw new PermissionDeniedException();
        }
        this.pinService.save(pinDTO);
    }

    public CreatePinDTO set(SetPinParams setPinParams) throws FrameworkException {
        this.checkLoggedIn();
        return this.pinService.set(setPinParams);
    }

    public ValidationResult validate(@NotNull String string) throws FrameworkException {
        this.checkLoggedIn();
        return this.pinService.validate(string);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<Pin>(Pin.class){

            public boolean isVisible(SessionData sessionData, Pin pin) {
                return PinServiceSecurity.this.canView(pin);
            }
        };
    }

    private boolean canManage(Pin pin) {
        return this.hasPinPermission(pin.getUser(), true);
    }

    private boolean canView(Pin pin) {
        return this.hasPinPermission(pin.getUser(), false);
    }

    private void checkManage(PinLocatorVO pinLocatorVO) {
        this.checkLoggedIn();
        Pin pin = this.pinService.ensurePin(pinLocatorVO);
        if (!this.canManage(pin)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkView(BasicUser basicUser) {
        if (!this.hasPinPermission(basicUser, false)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean hasPinPermission(BasicUser basicUser, boolean bl) {
        if (!this.pinService.pinEnabled(basicUser)) {
            return false;
        }
        if (basicUser.equals((Object)this.getLoggedBasicUser())) {
            return true;
        }
        if (basicUser instanceof Operator) {
            return this.permission(basicUser).my(new Permission[]{Permission.MY_OPERATORS_MANAGE_OPERATORS}).user(new Permission[]{bl ? Permission.USER_OPERATORS_MANAGE : Permission.USER_OPERATORS_VIEW}).granted();
        }
        return this.permission(basicUser).my(new Permission[0]).user(new Permission[]{bl ? Permission.USER_PINS_MANAGE : Permission.USER_PINS_VIEW}).granted();
    }
}

