/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TotpServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.access.passwords.SendOtpParams;
import org.cyclos.model.access.totps.RemoveTotpSecretParams;
import org.cyclos.model.access.totps.TotpSecretData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.access.TotpService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TotpServiceSecurity
extends BaseServiceSecurity
implements TotpService {
    @Autowired
    private TotpServiceLocal totpService;

    public void activate(@NotNull String string) throws FrameworkException {
        this.checkLoggedIn();
        this.totpService.activate(string);
    }

    public void apply(BasicUser basicUser, TotpSecretData totpSecretData) {
        if (totpSecretData == null) {
            return;
        }
        SessionData sessionData = this.getSessionData();
        totpSecretData.setCanActivate(totpSecretData.isCanActivate() && sessionData.getLoggedBasicUser().equals((Object)basicUser));
        totpSecretData.setCanRemove(totpSecretData.isCanRemove() && this.hasPermission(basicUser, true));
    }

    public TotpSecretData getData(BasicUserVO basicUserVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent(basicUserVO);
        if (!this.hasPermission(basicUser, false)) {
            throw new PermissionDeniedException();
        }
        return this.totpService.getData(basicUserVO);
    }

    public boolean isVisible(BasicUser basicUser) {
        return this.hasPermission(basicUser, false);
    }

    public void remove(RemoveTotpSecretParams removeTotpSecretParams) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent(removeTotpSecretParams.getUser());
        if (!this.hasPermission(basicUser, false)) {
            throw new PermissionDeniedException();
        }
        this.totpService.remove(removeTotpSecretParams);
    }

    public OtpResult requestActivationCode(@NotNull SendOtpParams sendOtpParams) throws FrameworkException {
        this.checkActivation();
        return this.totpService.requestActivationCode(sendOtpParams);
    }

    public String verifyActivationCode(@NotNull String string) throws FrameworkException {
        this.checkLoggedIn();
        return this.totpService.verifyActivationCode(string);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void checkActivation() {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isLoggedIn()) {
            throw new PermissionDeniedException();
        }
        if (!sessionData.getConfiguration().isTotpEnabled()) {
            throw new IllegalActionException();
        }
    }

    private boolean hasPermission(BasicUser basicUser, boolean bl) {
        return this.permission(basicUser).my(new Permission[0]).user(new Permission[]{bl ? Permission.USER_TOTP_MANAGE : Permission.USER_TOTP_VIEW}).granted();
    }
}

